/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Priority;
import com.tonyodev.fetch2.RequestInfo;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.FetchCoreUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001!B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\b\u0010 \u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/tonyodev/fetch2/Request;", "Lcom/tonyodev/fetch2/RequestInfo;", "Landroid/os/Parcelable;", "Ljava/io/Serializable;", "url", "", "file", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "fileUri", "Landroid/net/Uri;", "(Ljava/lang/String;Landroid/net/Uri;)V", "getUrl", "()Ljava/lang/String;", "getFile", "id", "", "getId", "()I", "getFileUri", "()Landroid/net/Uri;", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "describeContents", "CREATOR", "fetch2_release"})
public class Request
extends RequestInfo
implements Parcelable,
Serializable {
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);
    @NotNull
    private final String url;
    @NotNull
    private final String file;
    private final int id;

    public Request(@NotNull String url, @NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.url = url;
        this.file = file;
        this.id = FetchCoreUtils.getUniqueId((String)this.url, (String)this.file);
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getFile() {
        return this.file;
    }

    public Request(@NotNull String url, @NotNull Uri fileUri) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        String string2 = fileUri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this(url, string2);
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final Uri getFileUri() {
        return FetchCoreUtils.getFileUri((String)this.file);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.tonyodev.fetch2.Request");
        Request cfr_ignored_0 = (Request)other;
        if (this.id != ((Request)other).id) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)((Request)other).url)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.file, (Object)((Request)other).file);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.id;
        result = 31 * result + this.url.hashCode();
        result = 31 * result + this.file.hashCode();
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        return "Request(url='" + this.url + "', file='" + this.file + "', id=" + this.id + ", groupId=" + this.getGroupId() + ", headers=" + this.getHeaders() + ", priority=" + this.getPriority() + ", networkType=" + this.getNetworkType() + ", tag=" + this.getTag() + ")";
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        parcel.writeString(this.url);
        parcel.writeString(this.file);
        parcel.writeLong(this.getIdentifier());
        parcel.writeInt(this.getGroupId());
        parcel.writeSerializable((Serializable)new HashMap<String, String>(this.getHeaders()));
        parcel.writeInt(this.getPriority().getValue());
        parcel.writeInt(this.getNetworkType().getValue());
        parcel.writeString(this.getTag());
        parcel.writeInt(this.getEnqueueAction().getValue());
        parcel.writeInt(this.getDownloadOnEnqueue() ? 1 : 0);
        parcel.writeSerializable((Serializable)new HashMap(this.getExtras().getMap()));
        parcel.writeInt(this.getAutoRetryMaxAttempts());
    }

    public int describeContents() {
        return 0;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001d\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/tonyodev/fetch2/Request$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/tonyodev/fetch2/Request;", "<init>", "()V", "createFromParcel", "input", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/tonyodev/fetch2/Request;", "fetch2_release"})
    @SourceDebugExtension(value={"SMAP\nRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Request.kt\ncom/tonyodev/fetch2/Request$CREATOR\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,120:1\n216#2,2:121\n*S KotlinDebug\n*F\n+ 1 Request.kt\ncom/tonyodev/fetch2/Request$CREATOR\n*L\n102#1:121,2\n*E\n"})
    public static final class CREATOR
    implements Parcelable.Creator<Request> {
        private CREATOR() {
        }

        @NotNull
        public Request createFromParcel(@NotNull Parcel input) {
            String string2;
            String url;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            String string3 = input.readString();
            if (string3 == null) {
                string3 = url = "";
            }
            if ((string2 = input.readString()) == null) {
                string2 = "";
            }
            String file = string2;
            long identifier = input.readLong();
            int groupId = input.readInt();
            Serializable serializable = input.readSerializable();
            Intrinsics.checkNotNull((Object)serializable, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
            Map headers = (Map)((Object)serializable);
            Priority priority = Priority.Companion.valueOf(input.readInt());
            NetworkType networkType = NetworkType.Companion.valueOf(input.readInt());
            String tag = input.readString();
            EnqueueAction enqueueAction = EnqueueAction.Companion.valueOf(input.readInt());
            boolean downloadOnEnqueue = input.readInt() == 1;
            Serializable serializable2 = input.readSerializable();
            Intrinsics.checkNotNull((Object)serializable2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
            Map extras = (Map)((Object)serializable2);
            int autoRetryMaxAttempts = input.readInt();
            Request request = new Request(url, file);
            request.setIdentifier(identifier);
            request.setGroupId(groupId);
            Map $this$forEach$iv = headers;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                request.addHeader((String)it.getKey(), (String)it.getValue());
            }
            request.setPriority(priority);
            request.setNetworkType(networkType);
            request.setTag(tag);
            request.setEnqueueAction(enqueueAction);
            request.setDownloadOnEnqueue(downloadOnEnqueue);
            request.setExtras(new Extras(extras));
            request.setAutoRetryMaxAttempts(autoRetryMaxAttempts);
            return request;
        }

        @NotNull
        public Request[] newArray(int size) {
            return new Request[size];
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

