/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.database;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Priority;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.FetchCoreUtils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 }2\u00020\u0001:\u0001}B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010q\u001a\u00020\u0001H\u0016J\u0013\u0010r\u001a\u00020P2\b\u0010s\u001a\u0004\u0018\u00010tH\u0096\u0002J\b\u0010u\u001a\u00020\u0005H\u0016J\u0018\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020\u0005H\u0016J\b\u0010{\u001a\u00020\u0005H\u0016J\b\u0010|\u001a\u00020\u000bH\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u000b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001e\u0010\u0013\u001a\u00020\u000b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001e\u0010\u0016\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001e\u0010\u0019\u001a\u00020\u001a8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR*\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0 8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020&8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010+\u001a\u00020&8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R\u001e\u0010.\u001a\u00020/8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001e\u00104\u001a\u0002058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001e\u0010:\u001a\u00020;8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001e\u0010@\u001a\u00020&8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010(\"\u0004\bB\u0010*R \u0010C\u001a\u0004\u0018\u00010\u000b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\r\"\u0004\bE\u0010\u000fR\u001e\u0010F\u001a\u00020G8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u001e\u0010L\u001a\u00020&8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010(\"\u0004\bN\u0010*R\u001e\u0010O\u001a\u00020P8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u001e\u0010U\u001a\u00020V8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\u001e\u0010[\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\u0007\"\u0004\b]\u0010\tR\u001e\u0010^\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010\u0007\"\u0004\b`\u0010\tR\u001e\u0010a\u001a\u00020&8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010(\"\u0004\bc\u0010*R\u001e\u0010d\u001a\u00020&8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010(\"\u0004\bf\u0010*R\u0014\u0010g\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bh\u0010\u0007R\u0014\u0010i\u001a\u00020j8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bk\u0010lR\u0014\u0010m\u001a\u00020n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bo\u0010p\u00a8\u0006~"}, d2={"Lcom/tonyodev/fetch2/database/DownloadInfo;", "Lcom/tonyodev/fetch2/Download;", "<init>", "()V", "id", "", "getId", "()I", "setId", "(I)V", "namespace", "", "getNamespace", "()Ljava/lang/String;", "setNamespace", "(Ljava/lang/String;)V", "url", "getUrl", "setUrl", "file", "getFile", "setFile", "group", "getGroup", "setGroup", "priority", "Lcom/tonyodev/fetch2/Priority;", "getPriority", "()Lcom/tonyodev/fetch2/Priority;", "setPriority", "(Lcom/tonyodev/fetch2/Priority;)V", "headers", "", "getHeaders", "()Ljava/util/Map;", "setHeaders", "(Ljava/util/Map;)V", "downloaded", "", "getDownloaded", "()J", "setDownloaded", "(J)V", "total", "getTotal", "setTotal", "status", "Lcom/tonyodev/fetch2/Status;", "getStatus", "()Lcom/tonyodev/fetch2/Status;", "setStatus", "(Lcom/tonyodev/fetch2/Status;)V", "error", "Lcom/tonyodev/fetch2/Error;", "getError", "()Lcom/tonyodev/fetch2/Error;", "setError", "(Lcom/tonyodev/fetch2/Error;)V", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "getNetworkType", "()Lcom/tonyodev/fetch2/NetworkType;", "setNetworkType", "(Lcom/tonyodev/fetch2/NetworkType;)V", "created", "getCreated", "setCreated", "tag", "getTag", "setTag", "enqueueAction", "Lcom/tonyodev/fetch2/EnqueueAction;", "getEnqueueAction", "()Lcom/tonyodev/fetch2/EnqueueAction;", "setEnqueueAction", "(Lcom/tonyodev/fetch2/EnqueueAction;)V", "identifier", "getIdentifier", "setIdentifier", "downloadOnEnqueue", "", "getDownloadOnEnqueue", "()Z", "setDownloadOnEnqueue", "(Z)V", "extras", "Lcom/tonyodev/fetch2core/Extras;", "getExtras", "()Lcom/tonyodev/fetch2core/Extras;", "setExtras", "(Lcom/tonyodev/fetch2core/Extras;)V", "autoRetryMaxAttempts", "getAutoRetryMaxAttempts", "setAutoRetryMaxAttempts", "autoRetryAttempts", "getAutoRetryAttempts", "setAutoRetryAttempts", "etaInMilliSeconds", "getEtaInMilliSeconds", "setEtaInMilliSeconds", "downloadedBytesPerSecond", "getDownloadedBytesPerSecond", "setDownloadedBytesPerSecond", "progress", "getProgress", "fileUri", "Landroid/net/Uri;", "getFileUri", "()Landroid/net/Uri;", "request", "Lcom/tonyodev/fetch2/Request;", "getRequest", "()Lcom/tonyodev/fetch2/Request;", "copy", "equals", "other", "", "hashCode", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "describeContents", "toString", "CREATOR", "fetch2_release"})
@Entity(tableName="requests", indices={@Index(value={"_file"}, unique=true), @Index(value={"_group", "_status"}, unique=false)})
public class DownloadInfo
implements Download {
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);
    @PrimaryKey
    @ColumnInfo(name="_id", typeAffinity=3)
    private int id;
    @ColumnInfo(name="_namespace", typeAffinity=2)
    @NotNull
    private String namespace = "";
    @ColumnInfo(name="_url", typeAffinity=2)
    @NotNull
    private String url = "";
    @ColumnInfo(name="_file", typeAffinity=2)
    @NotNull
    private String file = "";
    @ColumnInfo(name="_group", typeAffinity=3)
    private int group;
    @ColumnInfo(name="_priority", typeAffinity=3)
    @NotNull
    private Priority priority = FetchDefaults.getDefaultPriority();
    @ColumnInfo(name="_headers", typeAffinity=2)
    @NotNull
    private Map<String, String> headers = new LinkedHashMap();
    @ColumnInfo(name="_written_bytes", typeAffinity=3)
    private long downloaded;
    @ColumnInfo(name="_total_bytes", typeAffinity=3)
    private long total = -1L;
    @ColumnInfo(name="_status", typeAffinity=3)
    @NotNull
    private Status status = FetchDefaults.getDefaultStatus();
    @ColumnInfo(name="_error", typeAffinity=3)
    @NotNull
    private Error error = FetchDefaults.getDefaultNoError();
    @ColumnInfo(name="_network_type", typeAffinity=3)
    @NotNull
    private NetworkType networkType = FetchDefaults.getDefaultNetworkType();
    @ColumnInfo(name="_created", typeAffinity=3)
    private long created = Calendar.getInstance().getTimeInMillis();
    @ColumnInfo(name="_tag", typeAffinity=2)
    @Nullable
    private String tag;
    @ColumnInfo(name="_enqueue_action", typeAffinity=3)
    @NotNull
    private EnqueueAction enqueueAction = EnqueueAction.REPLACE_EXISTING;
    @ColumnInfo(name="_identifier", typeAffinity=3)
    private long identifier;
    @ColumnInfo(name="_download_on_enqueue", typeAffinity=3)
    private boolean downloadOnEnqueue = true;
    @ColumnInfo(name="_extras", typeAffinity=2)
    @NotNull
    private Extras extras = Extras.CREATOR.getEmptyExtras();
    @ColumnInfo(name="_auto_retry_max_attempts", typeAffinity=3)
    private int autoRetryMaxAttempts;
    @ColumnInfo(name="_auto_retry_attempts", typeAffinity=3)
    private int autoRetryAttempts;
    @Ignore
    private long etaInMilliSeconds = -1L;
    @Ignore
    private long downloadedBytesPerSecond = -1L;

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.namespace = string2;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.url = string2;
    }

    @Override
    @NotNull
    public String getFile() {
        return this.file;
    }

    public void setFile(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.file = string2;
    }

    @Override
    public int getGroup() {
        return this.group;
    }

    public void setGroup(int n) {
        this.group = n;
    }

    @Override
    @NotNull
    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(@NotNull Priority priority) {
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"<set-?>");
        this.priority = priority;
    }

    @Override
    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.headers = map;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    public void setDownloaded(long l) {
        this.downloaded = l;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    public void setTotal(long l) {
        this.total = l;
    }

    @Override
    @NotNull
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"<set-?>");
        this.status = status;
    }

    @Override
    @NotNull
    public Error getError() {
        return this.error;
    }

    public void setError(@NotNull Error error) {
        Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"<set-?>");
        this.error = error;
    }

    @Override
    @NotNull
    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkNotNullParameter((Object)((Object)networkType), (String)"<set-?>");
        this.networkType = networkType;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public void setCreated(long l) {
        this.created = l;
    }

    @Override
    @Nullable
    public String getTag() {
        return this.tag;
    }

    public void setTag(@Nullable String string2) {
        this.tag = string2;
    }

    @Override
    @NotNull
    public EnqueueAction getEnqueueAction() {
        return this.enqueueAction;
    }

    public void setEnqueueAction(@NotNull EnqueueAction enqueueAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)enqueueAction), (String)"<set-?>");
        this.enqueueAction = enqueueAction;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(long l) {
        this.identifier = l;
    }

    @Override
    public boolean getDownloadOnEnqueue() {
        return this.downloadOnEnqueue;
    }

    public void setDownloadOnEnqueue(boolean bl) {
        this.downloadOnEnqueue = bl;
    }

    @Override
    @NotNull
    public Extras getExtras() {
        return this.extras;
    }

    public void setExtras(@NotNull Extras extras) {
        Intrinsics.checkNotNullParameter((Object)extras, (String)"<set-?>");
        this.extras = extras;
    }

    @Override
    public int getAutoRetryMaxAttempts() {
        return this.autoRetryMaxAttempts;
    }

    public void setAutoRetryMaxAttempts(int n) {
        this.autoRetryMaxAttempts = n;
    }

    @Override
    public int getAutoRetryAttempts() {
        return this.autoRetryAttempts;
    }

    public void setAutoRetryAttempts(int n) {
        this.autoRetryAttempts = n;
    }

    @Override
    public long getEtaInMilliSeconds() {
        return this.etaInMilliSeconds;
    }

    public void setEtaInMilliSeconds(long l) {
        this.etaInMilliSeconds = l;
    }

    @Override
    public long getDownloadedBytesPerSecond() {
        return this.downloadedBytesPerSecond;
    }

    public void setDownloadedBytesPerSecond(long l) {
        this.downloadedBytesPerSecond = l;
    }

    @Override
    public int getProgress() {
        return FetchCoreUtils.calculateProgress((long)this.getDownloaded(), (long)this.getTotal());
    }

    @Override
    @NotNull
    public Uri getFileUri() {
        return FetchCoreUtils.getFileUri((String)this.getFile());
    }

    @Override
    @NotNull
    public Request getRequest() {
        Request request = new Request(this.getUrl(), this.getFile());
        request.setGroupId(this.getGroup());
        request.getHeaders().putAll(this.getHeaders());
        request.setNetworkType(this.getNetworkType());
        request.setPriority(this.getPriority());
        request.setEnqueueAction(this.getEnqueueAction());
        request.setIdentifier(this.getIdentifier());
        request.setDownloadOnEnqueue(this.getDownloadOnEnqueue());
        request.setExtras(this.getExtras());
        request.setAutoRetryMaxAttempts(this.getAutoRetryMaxAttempts());
        return request;
    }

    @Override
    @NotNull
    public Download copy() {
        return FetchTypeConverterExtensions.toDownloadInfo(this, new DownloadInfo());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.tonyodev.fetch2.database.DownloadInfo");
        DownloadInfo cfr_ignored_0 = (DownloadInfo)other;
        if (this.getId() != ((DownloadInfo)other).getId()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getNamespace(), (Object)((DownloadInfo)other).getNamespace())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getUrl(), (Object)((DownloadInfo)other).getUrl())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getFile(), (Object)((DownloadInfo)other).getFile())) {
            return false;
        }
        if (this.getGroup() != ((DownloadInfo)other).getGroup()) {
            return false;
        }
        if (this.getPriority() != ((DownloadInfo)other).getPriority()) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getHeaders(), ((DownloadInfo)other).getHeaders())) {
            return false;
        }
        if (this.getDownloaded() != ((DownloadInfo)other).getDownloaded()) {
            return false;
        }
        if (this.getTotal() != ((DownloadInfo)other).getTotal()) {
            return false;
        }
        if (this.getStatus() != ((DownloadInfo)other).getStatus()) {
            return false;
        }
        if (this.getError() != ((DownloadInfo)other).getError()) {
            return false;
        }
        if (this.getNetworkType() != ((DownloadInfo)other).getNetworkType()) {
            return false;
        }
        if (this.getCreated() != ((DownloadInfo)other).getCreated()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTag(), (Object)((DownloadInfo)other).getTag())) {
            return false;
        }
        if (this.getEnqueueAction() != ((DownloadInfo)other).getEnqueueAction()) {
            return false;
        }
        if (this.getIdentifier() != ((DownloadInfo)other).getIdentifier()) {
            return false;
        }
        if (this.getDownloadOnEnqueue() != ((DownloadInfo)other).getDownloadOnEnqueue()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getExtras(), (Object)((DownloadInfo)other).getExtras())) {
            return false;
        }
        if (this.getEtaInMilliSeconds() != ((DownloadInfo)other).getEtaInMilliSeconds()) {
            return false;
        }
        if (this.getDownloadedBytesPerSecond() != ((DownloadInfo)other).getDownloadedBytesPerSecond()) {
            return false;
        }
        if (this.getAutoRetryMaxAttempts() != ((DownloadInfo)other).getAutoRetryMaxAttempts()) {
            return false;
        }
        return this.getAutoRetryAttempts() == ((DownloadInfo)other).getAutoRetryAttempts();
    }

    public int hashCode() {
        int result = this.getId();
        result = 31 * result + this.getNamespace().hashCode();
        result = 31 * result + this.getUrl().hashCode();
        result = 31 * result + this.getFile().hashCode();
        result = 31 * result + this.getGroup();
        result = 31 * result + this.getPriority().hashCode();
        result = 31 * result + ((Object)this.getHeaders()).hashCode();
        result = 31 * result + Long.hashCode(this.getDownloaded());
        result = 31 * result + Long.hashCode(this.getTotal());
        result = 31 * result + this.getStatus().hashCode();
        result = 31 * result + this.getError().hashCode();
        result = 31 * result + this.getNetworkType().hashCode();
        result = 31 * result + Long.hashCode(this.getCreated());
        String string2 = this.getTag();
        result = 31 * result + (string2 != null ? string2.hashCode() : 0);
        result = 31 * result + this.getEnqueueAction().hashCode();
        result = 31 * result + Long.hashCode(this.getIdentifier());
        result = 31 * result + Boolean.hashCode(this.getDownloadOnEnqueue());
        result = 31 * result + this.getExtras().hashCode();
        result = 31 * result + Long.hashCode(this.getEtaInMilliSeconds());
        result = 31 * result + Long.hashCode(this.getDownloadedBytesPerSecond());
        result = 31 * result + Integer.hashCode(this.getAutoRetryMaxAttempts());
        result = 31 * result + Integer.hashCode(this.getAutoRetryAttempts());
        return result;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeInt(this.getId());
        dest.writeString(this.getNamespace());
        dest.writeString(this.getUrl());
        dest.writeString(this.getFile());
        dest.writeInt(this.getGroup());
        dest.writeInt(this.getPriority().getValue());
        dest.writeSerializable((Serializable)new HashMap<String, String>(this.getHeaders()));
        dest.writeLong(this.getDownloaded());
        dest.writeLong(this.getTotal());
        dest.writeInt(this.getStatus().getValue());
        dest.writeInt(this.getError().getValue());
        dest.writeInt(this.getNetworkType().getValue());
        dest.writeLong(this.getCreated());
        dest.writeString(this.getTag());
        dest.writeInt(this.getEnqueueAction().getValue());
        dest.writeLong(this.getIdentifier());
        dest.writeInt(this.getDownloadOnEnqueue() ? 1 : 0);
        dest.writeLong(this.getEtaInMilliSeconds());
        dest.writeLong(this.getDownloadedBytesPerSecond());
        dest.writeSerializable((Serializable)new HashMap(this.getExtras().getMap()));
        dest.writeInt(this.getAutoRetryMaxAttempts());
        dest.writeInt(this.getAutoRetryAttempts());
    }

    public int describeContents() {
        return 0;
    }

    @NotNull
    public String toString() {
        return "DownloadInfo(id=" + this.getId() + ", namespace='" + this.getNamespace() + "', url='" + this.getUrl() + "', file='" + this.getFile() + "', group=" + this.getGroup() + ", priority=" + this.getPriority() + ", headers=" + this.getHeaders() + ", downloaded=" + this.getDownloaded() + ", total=" + this.getTotal() + ", status=" + this.getStatus() + ", error=" + this.getError() + ", networkType=" + this.getNetworkType() + ", created=" + this.getCreated() + ", tag=" + this.getTag() + ", enqueueAction=" + this.getEnqueueAction() + ", identifier=" + this.getIdentifier() + ", downloadOnEnqueue=" + this.getDownloadOnEnqueue() + ", extras=" + this.getExtras() + ", autoRetryMaxAttempts=" + this.getAutoRetryMaxAttempts() + ", autoRetryAttempts=" + this.getAutoRetryAttempts() + ", etaInMilliSeconds=" + this.getEtaInMilliSeconds() + ", downloadedBytesPerSecond=" + this.getDownloadedBytesPerSecond() + ")";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001d\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/tonyodev/fetch2/database/DownloadInfo$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "<init>", "()V", "createFromParcel", "source", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/tonyodev/fetch2/database/DownloadInfo;", "fetch2_release"})
    public static final class CREATOR
    implements Parcelable.Creator<DownloadInfo> {
        private CREATOR() {
        }

        @NotNull
        public DownloadInfo createFromParcel(@NotNull Parcel source) {
            String string2;
            String url;
            String string3;
            String namespace;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int id = source.readInt();
            String string4 = source.readString();
            if (string4 == null) {
                string4 = namespace = "";
            }
            if ((string3 = source.readString()) == null) {
                string3 = url = "";
            }
            if ((string2 = source.readString()) == null) {
                string2 = "";
            }
            String file = string2;
            int group = source.readInt();
            Priority priority = Priority.Companion.valueOf(source.readInt());
            Serializable serializable = source.readSerializable();
            Intrinsics.checkNotNull((Object)serializable, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
            Map headers = (Map)((Object)serializable);
            long downloaded = source.readLong();
            long total = source.readLong();
            Status status = Status.Companion.valueOf(source.readInt());
            Error error = Error.Companion.valueOf(source.readInt());
            NetworkType networkType = NetworkType.Companion.valueOf(source.readInt());
            long created = source.readLong();
            String tag = source.readString();
            EnqueueAction enqueueAction = EnqueueAction.Companion.valueOf(source.readInt());
            long identifier = source.readLong();
            boolean downloadOnEnqueue = source.readInt() == 1;
            long etaInMilliSeconds = source.readLong();
            long downloadedBytesPerSecond = source.readLong();
            Serializable serializable2 = source.readSerializable();
            Intrinsics.checkNotNull((Object)serializable2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
            Map extras = (Map)((Object)serializable2);
            int autoRetryMaxAttempts = source.readInt();
            int autoRetryAttempts = source.readInt();
            DownloadInfo downloadInfo = new DownloadInfo();
            downloadInfo.setId(id);
            downloadInfo.setNamespace(namespace);
            downloadInfo.setUrl(url);
            downloadInfo.setFile(file);
            downloadInfo.setGroup(group);
            downloadInfo.setPriority(priority);
            downloadInfo.setHeaders(headers);
            downloadInfo.setDownloaded(downloaded);
            downloadInfo.setTotal(total);
            downloadInfo.setStatus(status);
            downloadInfo.setError(error);
            downloadInfo.setNetworkType(networkType);
            downloadInfo.setCreated(created);
            downloadInfo.setTag(tag);
            downloadInfo.setEnqueueAction(enqueueAction);
            downloadInfo.setIdentifier(identifier);
            downloadInfo.setDownloadOnEnqueue(downloadOnEnqueue);
            downloadInfo.setEtaInMilliSeconds(etaInMilliSeconds);
            downloadInfo.setDownloadedBytesPerSecond(downloadedBytesPerSecond);
            downloadInfo.setExtras(new Extras(extras));
            downloadInfo.setAutoRetryMaxAttempts(autoRetryMaxAttempts);
            downloadInfo.setAutoRetryAttempts(autoRetryAttempts);
            return downloadInfo;
        }

        @NotNull
        public DownloadInfo[] newArray(int size) {
            return new DownloadInfo[size];
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

