package com.tonyodev.fetch2.database;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Priority;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2core.Extras;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class DownloadDao_Impl implements DownloadDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<DownloadInfo> __insertionAdapterOfDownloadInfo;

  private final Converter __converter = new Converter();

  private final EntityDeletionOrUpdateAdapter<DownloadInfo> __deletionAdapterOfDownloadInfo;

  private final EntityDeletionOrUpdateAdapter<DownloadInfo> __updateAdapterOfDownloadInfo;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public DownloadDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfDownloadInfo = new EntityInsertionAdapter<DownloadInfo>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `requests` (`_id`,`_namespace`,`_url`,`_file`,`_group`,`_priority`,`_headers`,`_written_bytes`,`_total_bytes`,`_status`,`_error`,`_network_type`,`_created`,`_tag`,`_enqueue_action`,`_identifier`,`_download_on_enqueue`,`_extras`,`_auto_retry_max_attempts`,`_auto_retry_attempts`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final DownloadInfo entity) {
        statement.bindLong(1, entity.getId());
        statement.bindString(2, entity.getNamespace());
        statement.bindString(3, entity.getUrl());
        statement.bindString(4, entity.getFile());
        statement.bindLong(5, entity.getGroup());
        final int _tmp = __converter.toPriorityValue(entity.getPriority());
        statement.bindLong(6, _tmp);
        final String _tmp_1 = __converter.toHeaderStringsMap(entity.getHeaders());
        statement.bindString(7, _tmp_1);
        statement.bindLong(8, entity.getDownloaded());
        statement.bindLong(9, entity.getTotal());
        final int _tmp_2 = __converter.toStatusValue(entity.getStatus());
        statement.bindLong(10, _tmp_2);
        final int _tmp_3 = __converter.toErrorValue(entity.getError());
        statement.bindLong(11, _tmp_3);
        final int _tmp_4 = __converter.toNetworkTypeValue(entity.getNetworkType());
        statement.bindLong(12, _tmp_4);
        statement.bindLong(13, entity.getCreated());
        if (entity.getTag() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getTag());
        }
        final int _tmp_5 = __converter.toEnqueueActionValue(entity.getEnqueueAction());
        statement.bindLong(15, _tmp_5);
        statement.bindLong(16, entity.getIdentifier());
        final int _tmp_6 = entity.getDownloadOnEnqueue() ? 1 : 0;
        statement.bindLong(17, _tmp_6);
        final String _tmp_7 = __converter.fromExtrasToString(entity.getExtras());
        statement.bindString(18, _tmp_7);
        statement.bindLong(19, entity.getAutoRetryMaxAttempts());
        statement.bindLong(20, entity.getAutoRetryAttempts());
      }
    };
    this.__deletionAdapterOfDownloadInfo = new EntityDeletionOrUpdateAdapter<DownloadInfo>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `requests` WHERE `_id` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final DownloadInfo entity) {
        statement.bindLong(1, entity.getId());
      }
    };
    this.__updateAdapterOfDownloadInfo = new EntityDeletionOrUpdateAdapter<DownloadInfo>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR REPLACE `requests` SET `_id` = ?,`_namespace` = ?,`_url` = ?,`_file` = ?,`_group` = ?,`_priority` = ?,`_headers` = ?,`_written_bytes` = ?,`_total_bytes` = ?,`_status` = ?,`_error` = ?,`_network_type` = ?,`_created` = ?,`_tag` = ?,`_enqueue_action` = ?,`_identifier` = ?,`_download_on_enqueue` = ?,`_extras` = ?,`_auto_retry_max_attempts` = ?,`_auto_retry_attempts` = ? WHERE `_id` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final DownloadInfo entity) {
        statement.bindLong(1, entity.getId());
        statement.bindString(2, entity.getNamespace());
        statement.bindString(3, entity.getUrl());
        statement.bindString(4, entity.getFile());
        statement.bindLong(5, entity.getGroup());
        final int _tmp = __converter.toPriorityValue(entity.getPriority());
        statement.bindLong(6, _tmp);
        final String _tmp_1 = __converter.toHeaderStringsMap(entity.getHeaders());
        statement.bindString(7, _tmp_1);
        statement.bindLong(8, entity.getDownloaded());
        statement.bindLong(9, entity.getTotal());
        final int _tmp_2 = __converter.toStatusValue(entity.getStatus());
        statement.bindLong(10, _tmp_2);
        final int _tmp_3 = __converter.toErrorValue(entity.getError());
        statement.bindLong(11, _tmp_3);
        final int _tmp_4 = __converter.toNetworkTypeValue(entity.getNetworkType());
        statement.bindLong(12, _tmp_4);
        statement.bindLong(13, entity.getCreated());
        if (entity.getTag() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getTag());
        }
        final int _tmp_5 = __converter.toEnqueueActionValue(entity.getEnqueueAction());
        statement.bindLong(15, _tmp_5);
        statement.bindLong(16, entity.getIdentifier());
        final int _tmp_6 = entity.getDownloadOnEnqueue() ? 1 : 0;
        statement.bindLong(17, _tmp_6);
        final String _tmp_7 = __converter.fromExtrasToString(entity.getExtras());
        statement.bindString(18, _tmp_7);
        statement.bindLong(19, entity.getAutoRetryMaxAttempts());
        statement.bindLong(20, entity.getAutoRetryAttempts());
        statement.bindLong(21, entity.getId());
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM requests";
        return _query;
      }
    };
  }

  @Override
  public long insert(final DownloadInfo downloadInfo) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfDownloadInfo.insertAndReturnId(downloadInfo);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public List<Long> insert(final List<? extends DownloadInfo> downloadInfoList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final List<Long> _result = __insertionAdapterOfDownloadInfo.insertAndReturnIdsList(downloadInfoList);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void delete(final DownloadInfo downloadInfo) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfDownloadInfo.handle(downloadInfo);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void delete(final List<? extends DownloadInfo> downloadInfoList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfDownloadInfo.handleMultiple(downloadInfoList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final DownloadInfo download) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfDownloadInfo.handle(download);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final List<? extends DownloadInfo> downloadInfoList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfDownloadInfo.handleMultiple(downloadInfoList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfDeleteAll.release(_stmt);
    }
  }

  @Override
  public List<DownloadInfo> get() {
    final String _sql = "SELECT * FROM requests";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final List<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final DownloadInfo _item;
        _item = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _item.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _item.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _item.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _item.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp);
        _item.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_1;
        _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_1);
        _item.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _item.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _item.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_2);
        _item.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_3);
        _item.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_4);
        _item.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _item.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _item.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_5);
        _item.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _item.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_6 != 0;
        _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_7;
        _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_7);
        _item.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public DownloadInfo get(final int id) {
    final String _sql = "SELECT * FROM requests WHERE _id = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, id);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final DownloadInfo _result;
      if (_cursor.moveToFirst()) {
        _result = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _result.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _result.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _result.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _result.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _result.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp);
        _result.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_1;
        _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_1);
        _result.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _result.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _result.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_2);
        _result.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_3);
        _result.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_4);
        _result.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _result.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _result.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_5);
        _result.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _result.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_6 != 0;
        _result.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_7;
        _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_7);
        _result.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _result.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _result.setAutoRetryAttempts(_tmpAutoRetryAttempts);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<DownloadInfo> get(final List<Integer> ids) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT * FROM requests WHERE _id IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (int _item : ids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final List<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final DownloadInfo _item_1;
        _item_1 = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item_1.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _item_1.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _item_1.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _item_1.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _item_1.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp);
        _item_1.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_1;
        _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_1);
        _item_1.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _item_1.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _item_1.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_2);
        _item_1.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_3);
        _item_1.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_4);
        _item_1.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _item_1.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _item_1.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_5);
        _item_1.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _item_1.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_6 != 0;
        _item_1.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_7;
        _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_7);
        _item_1.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _item_1.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _item_1.setAutoRetryAttempts(_tmpAutoRetryAttempts);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public DownloadInfo getByFile(final String file) {
    final String _sql = "SELECT * FROM requests WHERE _file = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, file);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final DownloadInfo _result;
      if (_cursor.moveToFirst()) {
        _result = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _result.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _result.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _result.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _result.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _result.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp);
        _result.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_1;
        _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_1);
        _result.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _result.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _result.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_2);
        _result.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_3);
        _result.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_4);
        _result.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _result.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _result.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_5);
        _result.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _result.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_6 != 0;
        _result.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_7;
        _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_7);
        _result.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _result.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _result.setAutoRetryAttempts(_tmpAutoRetryAttempts);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<DownloadInfo> getByStatus(final Status status) {
    final String _sql = "SELECT * FROM requests WHERE _status = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final int _tmp = __converter.toStatusValue(status);
    _statement.bindLong(_argIndex, _tmp);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final List<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final DownloadInfo _item;
        _item = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _item.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _item.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _item.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _item.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp_1);
        _item.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_2;
        _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_2);
        _item.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _item.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _item.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_3);
        _item.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_4);
        _item.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_5);
        _item.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _item.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _item.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_6);
        _item.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _item.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_7;
        _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_7 != 0;
        _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_8;
        _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_8);
        _item.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<DownloadInfo> getByStatus(final List<Status> statuses) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT * FROM requests WHERE _status IN (");
    final int _inputSize = statuses.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (Status _item : statuses) {
      final int _tmp = __converter.toStatusValue(_item);
      _statement.bindLong(_argIndex, _tmp);
      _argIndex++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final List<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final DownloadInfo _item_1;
        _item_1 = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item_1.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _item_1.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _item_1.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _item_1.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _item_1.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp_1);
        _item_1.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_2;
        _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_2);
        _item_1.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _item_1.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _item_1.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_3);
        _item_1.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_4);
        _item_1.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_5);
        _item_1.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _item_1.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _item_1.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_6);
        _item_1.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _item_1.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_7;
        _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_7 != 0;
        _item_1.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_8;
        _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_8);
        _item_1.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _item_1.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _item_1.setAutoRetryAttempts(_tmpAutoRetryAttempts);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<DownloadInfo> getByGroup(final int group) {
    final String _sql = "SELECT * FROM requests WHERE _group = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, group);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final List<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final DownloadInfo _item;
        _item = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _item.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _item.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _item.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _item.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp);
        _item.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_1;
        _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_1);
        _item.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _item.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _item.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_2);
        _item.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_3);
        _item.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_4);
        _item.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _item.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _item.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_5);
        _item.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _item.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_6 != 0;
        _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_7;
        _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_7);
        _item.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<DownloadInfo> getByGroupWithStatus(final int group, final List<Status> statuses) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT * FROM requests WHERE _group = ");
    _stringBuilder.append("?");
    _stringBuilder.append(" AND _status IN (");
    final int _inputSize = statuses.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 1 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, group);
    _argIndex = 2;
    for (Status _item : statuses) {
      final int _tmp = __converter.toStatusValue(_item);
      _statement.bindLong(_argIndex, _tmp);
      _argIndex++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final List<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final DownloadInfo _item_1;
        _item_1 = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item_1.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _item_1.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _item_1.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _item_1.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _item_1.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp_1);
        _item_1.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_2;
        _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_2);
        _item_1.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _item_1.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _item_1.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_3);
        _item_1.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_4);
        _item_1.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_5);
        _item_1.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _item_1.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _item_1.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_6);
        _item_1.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _item_1.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_7;
        _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_7 != 0;
        _item_1.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_8;
        _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_8);
        _item_1.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _item_1.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _item_1.setAutoRetryAttempts(_tmpAutoRetryAttempts);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<DownloadInfo> getPendingDownloadsSorted(final Status status) {
    final String _sql = "SELECT * FROM requests WHERE _status = ? ORDER BY _priority DESC, _created ASC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final int _tmp = __converter.toStatusValue(status);
    _statement.bindLong(_argIndex, _tmp);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final List<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final DownloadInfo _item;
        _item = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _item.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _item.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _item.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _item.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp_1);
        _item.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_2;
        _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_2);
        _item.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _item.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _item.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_3);
        _item.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_4);
        _item.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_5);
        _item.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _item.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _item.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_6);
        _item.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _item.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_7;
        _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_7 != 0;
        _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_8;
        _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_8);
        _item.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<DownloadInfo> getPendingDownloadsSortedDesc(final Status status) {
    final String _sql = "SELECT * FROM requests WHERE _status = ? ORDER BY _priority DESC, _created DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final int _tmp = __converter.toStatusValue(status);
    _statement.bindLong(_argIndex, _tmp);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final List<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final DownloadInfo _item;
        _item = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _item.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _item.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _item.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _item.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp_1);
        _item.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_2;
        _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_2);
        _item.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _item.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _item.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_3);
        _item.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_4);
        _item.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_5);
        _item.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _item.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _item.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_6);
        _item.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _item.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_7;
        _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_7 != 0;
        _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_8;
        _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_8);
        _item.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<DownloadInfo> getDownloadsByRequestIdentifier(final long identifier) {
    final String _sql = "SELECT * FROM requests WHERE _identifier = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, identifier);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final List<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final DownloadInfo _item;
        _item = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _item.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _item.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _item.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _item.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp);
        _item.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_1;
        _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_1);
        _item.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _item.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _item.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_2);
        _item.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_3);
        _item.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_4);
        _item.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _item.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _item.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_5);
        _item.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _item.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_6 != 0;
        _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_7;
        _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_7);
        _item.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<DownloadInfo> getDownloadsByTag(final String tag) {
    final String _sql = "SELECT * FROM requests WHERE _tag = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, tag);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow(_cursor, "_namespace");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "_url");
      final int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow(_cursor, "_file");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "_group");
      final int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow(_cursor, "_priority");
      final int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "_headers");
      final int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow(_cursor, "_written_bytes");
      final int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "_total_bytes");
      final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "_status");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "_error");
      final int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow(_cursor, "_network_type");
      final int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "_created");
      final int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow(_cursor, "_tag");
      final int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow(_cursor, "_enqueue_action");
      final int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow(_cursor, "_identifier");
      final int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow(_cursor, "_download_on_enqueue");
      final int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow(_cursor, "_extras");
      final int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_max_attempts");
      final int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow(_cursor, "_auto_retry_attempts");
      final List<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final DownloadInfo _item;
        _item = new DownloadInfo();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item.setId(_tmpId);
        final String _tmpNamespace;
        _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
        _item.setNamespace(_tmpNamespace);
        final String _tmpUrl;
        _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        _item.setUrl(_tmpUrl);
        final String _tmpFile;
        _tmpFile = _cursor.getString(_cursorIndexOfFile);
        _item.setFile(_tmpFile);
        final int _tmpGroup;
        _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
        _item.setGroup(_tmpGroup);
        final Priority _tmpPriority;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfPriority);
        _tmpPriority = __converter.fromPriorityValue(_tmp);
        _item.setPriority(_tmpPriority);
        final Map<String, String> _tmpHeaders;
        final String _tmp_1;
        _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
        _tmpHeaders = __converter.fromJsonString(_tmp_1);
        _item.setHeaders(_tmpHeaders);
        final long _tmpDownloaded;
        _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
        _item.setDownloaded(_tmpDownloaded);
        final long _tmpTotal;
        _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
        _item.setTotal(_tmpTotal);
        final Status _tmpStatus;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
        _tmpStatus = __converter.fromStatusValue(_tmp_2);
        _item.setStatus(_tmpStatus);
        final Error _tmpError;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfError);
        _tmpError = __converter.fromErrorValue(_tmp_3);
        _item.setError(_tmpError);
        final NetworkType _tmpNetworkType;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
        _tmpNetworkType = __converter.fromNetworkTypeValue(_tmp_4);
        _item.setNetworkType(_tmpNetworkType);
        final long _tmpCreated;
        _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
        _item.setCreated(_tmpCreated);
        final String _tmpTag;
        if (_cursor.isNull(_cursorIndexOfTag)) {
          _tmpTag = null;
        } else {
          _tmpTag = _cursor.getString(_cursorIndexOfTag);
        }
        _item.setTag(_tmpTag);
        final EnqueueAction _tmpEnqueueAction;
        final int _tmp_5;
        _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
        _tmpEnqueueAction = __converter.fromEnqueueActionValue(_tmp_5);
        _item.setEnqueueAction(_tmpEnqueueAction);
        final long _tmpIdentifier;
        _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
        _item.setIdentifier(_tmpIdentifier);
        final boolean _tmpDownloadOnEnqueue;
        final int _tmp_6;
        _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
        _tmpDownloadOnEnqueue = _tmp_6 != 0;
        _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
        final Extras _tmpExtras;
        final String _tmp_7;
        _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
        _tmpExtras = __converter.fromExtrasJsonToExtras(_tmp_7);
        _item.setExtras(_tmpExtras);
        final int _tmpAutoRetryMaxAttempts;
        _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
        _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
        final int _tmpAutoRetryAttempts;
        _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
        _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<Integer> getAllGroupIds() {
    final String _sql = "SELECT DISTINCT _group from requests";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final List<Integer> _result = new ArrayList<Integer>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Integer _item;
        _item = _cursor.getInt(0);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
