/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2;

import com.tonyodev.fetch2.Error;
import java.io.IOException;
import java.net.SocketTimeoutException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"getErrorFromMessage", "Lcom/tonyodev/fetch2/Error;", "message", "", "getErrorFromThrowable", "throwable", "", "fetch2_release"})
@JvmName(name="FetchErrorUtils")
public final class FetchErrorUtils {
    @NotNull
    public static final Error getErrorFromThrowable(@NotNull Throwable throwable) {
        String message;
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        String string2 = throwable.getMessage();
        if (string2 == null) {
            string2 = message = "";
        }
        if (throwable instanceof SocketTimeoutException) {
            CharSequence charSequence = message;
            boolean bl = false;
            if (charSequence.length() == 0) {
                message = "timeout";
            }
        }
        Error error = FetchErrorUtils.getErrorFromMessage(message);
        error = error == Error.UNKNOWN && throwable instanceof SocketTimeoutException ? Error.CONNECTION_TIMED_OUT : (error == Error.UNKNOWN && throwable instanceof IOException ? Error.UNKNOWN_IO_ERROR : error);
        error.setThrowable(throwable);
        return error;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Error getErrorFromMessage(@Nullable String message) {
        Error error;
        block32: {
            block31: {
                if (message == null) break block31;
                CharSequence charSequence = message;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block32;
            }
            error = Error.UNKNOWN;
            return error;
        }
        if (StringsKt.equals((String)message, (String)"request_with_file_path_already_exist", (boolean)true) || StringsKt.contains((CharSequence)message, (CharSequence)"UNIQUE constraint failed: requests._file (code 2067)", (boolean)true)) {
            error = Error.REQUEST_WITH_FILE_PATH_ALREADY_EXIST;
            return error;
        }
        if (StringsKt.contains$default((CharSequence)message, (CharSequence)"UNIQUE constraint failed: requests._id", (boolean)false, (int)2, null)) {
            error = Error.REQUEST_WITH_ID_ALREADY_EXIST;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"empty_response_body", (boolean)true)) {
            error = Error.EMPTY_RESPONSE_FROM_SERVER;
            return error;
        }
        if (StringsKt.equals((String)message, (String)"FNC", (boolean)true) || StringsKt.equals((String)message, (String)"open failed: ENOENT (No such file or directory)", (boolean)true)) {
            error = Error.FILE_NOT_CREATED;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"recvfrom failed: ETIMEDOUT (Connection timed out)", (boolean)true) || StringsKt.contains((CharSequence)message, (CharSequence)"timeout", (boolean)true) || StringsKt.contains((CharSequence)message, (CharSequence)"Software caused connection abort", (boolean)true) || StringsKt.contains((CharSequence)message, (CharSequence)"Read timed out at", (boolean)true)) {
            error = Error.CONNECTION_TIMED_OUT;
            return error;
        }
        if (StringsKt.equals((String)message, (String)"java.io.IOException: 404", (boolean)true) || StringsKt.contains$default((CharSequence)message, (CharSequence)"No address associated with hostname", (boolean)false, (int)2, null)) {
            error = Error.HTTP_NOT_FOUND;
            return error;
        }
        if (StringsKt.contains$default((CharSequence)message, (CharSequence)"Unable to resolve host", (boolean)false, (int)2, null)) {
            error = Error.UNKNOWN_HOST;
            return error;
        }
        if (StringsKt.equals((String)message, (String)"open failed: EACCES (Permission denied)", (boolean)true)) {
            error = Error.WRITE_PERMISSION_DENIED;
            return error;
        }
        if (StringsKt.equals((String)message, (String)"write failed: ENOSPC (No space left on device)", (boolean)true) || StringsKt.equals((String)message, (String)"database or disk is full (code 13)", (boolean)true)) {
            error = Error.NO_STORAGE_SPACE;
            return error;
        }
        if (StringsKt.equals((String)message, (String)"UNIQUE constraint failed: requests._id (code 1555)", (boolean)true)) {
            error = Error.REQUEST_ALREADY_EXIST;
            return error;
        }
        if (StringsKt.equals((String)message, (String)"fetch download not found", (boolean)true)) {
            error = Error.DOWNLOAD_NOT_FOUND;
            return error;
        }
        if (StringsKt.equals((String)message, (String)"Fetch data base error", (boolean)true)) {
            error = Error.FETCH_DATABASE_ERROR;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"request_not_successful", (boolean)true) || StringsKt.contains((CharSequence)message, (CharSequence)"Failed to connect", (boolean)true)) {
            error = Error.REQUEST_NOT_SUCCESSFUL;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"invalid content hash", (boolean)true)) {
            error = Error.INVALID_CONTENT_HASH;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"download_incomplete", (boolean)true)) {
            error = Error.UNKNOWN_IO_ERROR;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"failed_to_update_request", (boolean)true)) {
            error = Error.FAILED_TO_UPDATE_REQUEST;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"failed_to_add_completed_download", (boolean)true)) {
            error = Error.FAILED_TO_ADD_COMPLETED_DOWNLOAD;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"fetch_file_server_invalid_response_type", (boolean)true)) {
            error = Error.FETCH_FILE_SERVER_INVALID_RESPONSE;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"request_does_not_exist", (boolean)true)) {
            error = Error.REQUEST_DOES_NOT_EXIST;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"no_network_connection", (boolean)true)) {
            error = Error.NO_NETWORK_CONNECTION;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"file_not_found", (boolean)true)) {
            error = Error.FILE_NOT_FOUND;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"fetch_file_server_url_invalid", (boolean)true)) {
            error = Error.FETCH_FILE_SERVER_URL_INVALID;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"request_list_not_distinct", (boolean)true)) {
            error = Error.ENQUEUED_REQUESTS_ARE_NOT_DISTINCT;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"enqueue_not_successful", (boolean)true)) {
            error = Error.ENQUEUE_NOT_SUCCESSFUL;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"cannot rename file associated with incomplete download", (boolean)true)) {
            error = Error.FAILED_TO_RENAME_INCOMPLETE_DOWNLOAD_FILE;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"file_cannot_be_renamed", (boolean)true)) {
            error = Error.FAILED_TO_RENAME_FILE;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"file_allocation_error", (boolean)true)) {
            error = Error.FILE_ALLOCATION_FAILED;
            return error;
        }
        if (StringsKt.contains((CharSequence)message, (CharSequence)"Cleartext HTTP traffic to", (boolean)true)) {
            error = Error.HTTP_CONNECTION_NOT_ALLOWED;
            return error;
        }
        error = Error.UNKNOWN;
        return error;
    }
}

