/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.ParallelFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.AverageCalculator;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.DownloadBlockInfo;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileSlice;
import com.tonyodev.fetch2core.FileSliceInfo;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.OutputResourceWrapper;
import com.tonyodev.fetch2core.StorageResolver;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00af\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001/\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002J\b\u0010I\u001a\u00020\u0007H\u0002J\u0010\u0010J\u001a\u00020K2\u0006\u0010F\u001a\u00020GH\u0002J\u001e\u0010L\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010M\u001a\u00020\r2\u0006\u0010F\u001a\u00020GH\u0002J\b\u0010N\u001a\u00020EH\u0002J\b\u0010O\u001a\u00020\rH\u0002J\b\u0010P\u001a\u00020EH\u0016J\u0010\u0010Q\u001a\u00020E2\u0006\u0010R\u001a\u00020SH\u0002J\b\u0010T\u001a\u00020EH\u0002J\b\u0010U\u001a\u00020EH\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00100R$\u00102\u001a\u00020\r2\u0006\u00101\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001b\"\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010<\u001a\u00020\r2\u0006\u00101\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u001b\"\u0004\b>\u00105R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "initialDownload", "Lcom/tonyodev/fetch2/Download;", "downloader", "Lcom/tonyodev/fetch2core/Downloader;", "progressReportingIntervalMillis", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "fileTempDir", "", "hashCheckingEnabled", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "(Lcom/tonyodev/fetch2/Download;Lcom/tonyodev/fetch2core/Downloader;JLcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZLjava/lang/String;ZLcom/tonyodev/fetch2core/StorageResolver;)V", "actionsCounter", "", "actionsTotal", "averageDownloadedBytesPerSecond", "", "completedDownload", "getCompletedDownload", "()Z", "delegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;)V", "download", "getDownload", "()Lcom/tonyodev/fetch2/Download;", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "downloaded", "estimatedTimeRemainingInMilliseconds", "executorService", "Ljava/util/concurrent/ExecutorService;", "fileSlices", "", "Lcom/tonyodev/fetch2core/FileSlice;", "interruptMonitor", "com/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1", "Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1;", "value", "interrupted", "getInterrupted", "setInterrupted", "(Z)V", "lock", "Ljava/lang/Object;", "movingAverageCalculator", "Lcom/tonyodev/fetch2core/AverageCalculator;", "outputResourceWrapper", "Lcom/tonyodev/fetch2core/OutputResourceWrapper;", "terminated", "getTerminated", "setTerminated", "throwable", "", "total", "totalDownloadBlocks", "totalUnknown", "downloadSliceFiles", "", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "fileSlicesDownloadsList", "getAverageDownloadedBytesPerSecond", "getChuckInfo", "Lcom/tonyodev/fetch2core/FileSliceInfo;", "getFileSliceList", "acceptsRanges", "incrementActionCompletedCount", "isDownloadComplete", "run", "setIsTotalUnknown", "response", "Lcom/tonyodev/fetch2core/Downloader$Response;", "throwExceptionIfFound", "waitAndPerformProgressReporting", "fetch2_release"})
public final class ParallelFileDownloaderImpl
implements FileDownloader {
    private volatile boolean interrupted;
    private volatile boolean terminated;
    @Nullable
    private FileDownloader.Delegate delegate;
    private final DownloadInfo downloadInfo;
    private volatile long downloaded;
    private volatile long total;
    private volatile boolean totalUnknown;
    private double averageDownloadedBytesPerSecond;
    private final AverageCalculator movingAverageCalculator;
    private long estimatedTimeRemainingInMilliseconds;
    private ExecutorService executorService;
    private volatile int actionsCounter;
    private int actionsTotal;
    private final Object lock;
    private volatile Throwable throwable;
    private List<FileSlice> fileSlices;
    private OutputResourceWrapper outputResourceWrapper;
    private int totalDownloadBlocks;
    private final interruptMonitor.1 interruptMonitor;
    private final Download initialDownload;
    private final Downloader<?, ?> downloader;
    private final long progressReportingIntervalMillis;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    private final String fileTempDir;
    private final boolean hashCheckingEnabled;
    private final StorageResolver storageResolver;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        if (!(delegate instanceof FileDownloaderDelegate)) {
            delegate = null;
        }
        FileDownloaderDelegate fileDownloaderDelegate = (FileDownloaderDelegate)delegate;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.interrupted = value;
    }

    @Override
    public boolean getTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        if (!(delegate instanceof FileDownloaderDelegate)) {
            delegate = null;
        }
        FileDownloaderDelegate fileDownloaderDelegate = (FileDownloaderDelegate)delegate;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.terminated = value;
    }

    @Override
    public boolean getCompletedDownload() {
        return this.isDownloadComplete();
    }

    @Override
    @Nullable
    public FileDownloader.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FileDownloader.Delegate delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Download getDownload() {
        this.downloadInfo.setDownloaded(this.downloaded);
        this.downloadInfo.setTotal(this.total);
        return this.downloadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Downloader.Response openingResponse;
        block84: {
            Unit unit;
            Unit unit2;
            Iterable $receiver$iv;
            block94: {
                Object element$iv$iv;
                Iterator iterator;
                Object destination$iv$iv;
                Downloader.ServerRequest openingRequest;
                block93: {
                    block92: {
                        void $receiver$iv$iv;
                        openingResponse = null;
                        this.downloaded = this.initialDownload.getDownloaded();
                        this.total = this.initialDownload.getTotal();
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        openingRequest = this.downloader.getHeadRequestMethodSupported(FetchUtils.getRequestForDownload$default(this.initialDownload, null, 2, null)) ? FetchUtils.getRequestForDownload(this.initialDownload, "HEAD") : FetchUtils.getRequestForDownload$default(this.initialDownload, null, 2, null);
                        openingResponse = this.downloader.execute(openingRequest, (InterruptMonitor)this.interruptMonitor);
                        if (openingResponse != null) {
                            this.setIsTotalUnknown(openingResponse);
                        }
                        if (this.getInterrupted() || this.getTerminated()) break block92;
                        Downloader.Response response2 = openingResponse;
                        if (response2 == null || !response2.isSuccessful()) break block92;
                        this.total = openingResponse.getContentLength();
                        if (!this.totalUnknown) {
                            if (this.total <= 0L) throw (Throwable)new FetchException("empty_response_body");
                        }
                        this.downloaded = 0L;
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        this.fileSlices = this.getFileSliceList(openingResponse.getAcceptsRanges(), openingRequest);
                        this.totalDownloadBlocks = this.fileSlices.size();
                        try {
                            this.downloader.disconnect(openingResponse);
                        }
                        catch (Exception e) {
                            this.logger.e("FileDownloader", (Throwable)e);
                        }
                        Iterable iterable = $receiver$iv = (Iterable)this.fileSlices;
                        destination$iv$iv = new ArrayList();
                        iterator = $receiver$iv$iv.iterator();
                        break block93;
                    }
                    if (!(openingResponse != null || this.getInterrupted() || this.getTerminated() || this.isDownloadComplete())) {
                        throw (Throwable)new FetchException("empty_response_body");
                    }
                    Downloader.Response response3 = openingResponse;
                    if (response3 != null && !response3.isSuccessful() && !this.getInterrupted()) {
                        if (!this.getTerminated() && !this.isDownloadComplete()) {
                            throw (Throwable)new FetchException("request_not_successful");
                        }
                    }
                    if (!(this.getInterrupted() || this.getTerminated() || this.isDownloadComplete())) {
                        throw (Throwable)new FetchException("unknown");
                    }
                    break block94;
                }
                while (iterator.hasNext()) {
                    element$iv$iv = iterator.next();
                    FileSlice it = (FileSlice)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.isDownloaded())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List sliceFileDownloadsList = (List)destination$iv$iv;
                if (!this.getInterrupted() && !this.getTerminated()) {
                    Iterator $receiver$iv$iv;
                    Object $receiver$iv2;
                    this.downloadInfo.setDownloaded(this.downloaded);
                    this.downloadInfo.setTotal(this.total);
                    destination$iv$iv = $receiver$iv2 = (Iterable)this.fileSlices;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    element$iv$iv = $receiver$iv$iv.iterator();
                    while (element$iv$iv.hasNext()) {
                        void it;
                        Object item$iv$iv = element$iv$iv.next();
                        FileSlice bl = (FileSlice)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        DownloadBlockInfo downloadBlock2 = new DownloadBlockInfo();
                        downloadBlock2.setDownloadId(it.getId());
                        downloadBlock2.setBlockPosition(it.getPosition());
                        downloadBlock2.setDownloadedBytes(it.getDownloaded());
                        downloadBlock2.setStartByte(it.getStartBytes());
                        downloadBlock2.setEndByte(it.getEndBytes());
                        DownloadBlockInfo downloadBlockInfo = downloadBlock2;
                        collection.add(downloadBlockInfo);
                    }
                    List downloadBlocks = (List)destination$iv$iv2;
                    if (!this.getInterrupted() && !this.getTerminated()) {
                        Unit unit3;
                        this.downloadInfo.setEtaInMilliSeconds(-1L);
                        this.downloadInfo.setDownloadedBytesPerSecond(-1L);
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.onStarted(this.downloadInfo, downloadBlocks, this.totalDownloadBlocks);
                            unit3 = Unit.INSTANCE;
                        } else {
                            unit3 = null;
                        }
                        $receiver$iv2 = downloadBlocks;
                        $receiver$iv$iv = $receiver$iv2.iterator();
                        while ($receiver$iv$iv.hasNext()) {
                            Unit unit4;
                            Object element$iv = $receiver$iv$iv.next();
                            DownloadBlockInfo downloadBlock3 = (DownloadBlockInfo)element$iv;
                            boolean bl = false;
                            FileDownloader.Delegate delegate2 = this.getDelegate();
                            if (delegate2 != null) {
                                delegate2.onDownloadBlockUpdated(this.downloadInfo, (DownloadBlock)downloadBlock3, this.totalDownloadBlocks);
                                unit4 = Unit.INSTANCE;
                                continue;
                            }
                            unit4 = null;
                        }
                    }
                    if (!($receiver$iv2 = (Collection)sliceFileDownloadsList).isEmpty()) {
                        this.executorService = Executors.newFixedThreadPool(sliceFileDownloadsList.size());
                    }
                    this.downloadSliceFiles(openingRequest, sliceFileDownloadsList);
                    this.waitAndPerformProgressReporting();
                    this.downloadInfo.setDownloaded(this.downloaded);
                    this.downloadInfo.setTotal(this.total);
                }
            }
            this.downloadInfo.setDownloaded(this.downloaded);
            this.downloadInfo.setTotal(this.total);
            this.throwExceptionIfFound();
            if (!(this.isDownloadComplete() || this.getTerminated() || this.getInterrupted())) {
                Unit unit5;
                Unit unit6;
                FileDownloader.Delegate delegate = this.getDelegate();
                if (delegate != null) {
                    delegate.saveDownloadProgress(this.downloadInfo);
                    unit6 = Unit.INSTANCE;
                } else {
                    unit6 = null;
                }
                this.downloadInfo.setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
                this.downloadInfo.setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
                FileDownloader.Delegate delegate3 = this.getDelegate();
                if (delegate3 != null) {
                    delegate3.onProgress(this.downloadInfo, this.downloadInfo.getEtaInMilliSeconds(), this.downloadInfo.getDownloadedBytesPerSecond());
                    unit5 = Unit.INSTANCE;
                    break block84;
                } else {
                    unit5 = null;
                }
                break block84;
            }
            if (this.getInterrupted() || this.getTerminated() || !this.isDownloadComplete()) break block84;
            if (!this.totalUnknown) {
                long fileSlicesTotal = 0L;
                $receiver$iv = this.fileSlices;
                for (Object element$iv : $receiver$iv) {
                    FileSlice it = (FileSlice)element$iv;
                    boolean bl = false;
                    fileSlicesTotal += it.getDownloaded();
                }
                if (fileSlicesTotal != this.total) {
                    this.throwable = new FetchException("download_incomplete");
                    this.throwExceptionIfFound();
                }
            } else {
                this.total = this.downloaded;
                this.downloadInfo.setDownloaded(this.downloaded);
                this.downloadInfo.setTotal(this.total);
            }
            if (!this.getTerminated() && !this.getInterrupted()) {
                Unit unit7;
                FileDownloader.Delegate delegate = this.getDelegate();
                if (delegate != null) {
                    delegate.saveDownloadProgress(this.downloadInfo);
                    unit7 = Unit.INSTANCE;
                } else {
                    unit7 = null;
                }
            }
            if (this.hashCheckingEnabled) {
                if (openingResponse != null && this.downloader.verifyContentHash(openingResponse.getRequest(), openingResponse.getHash())) {
                    FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
                    if (!this.getInterrupted() && !this.getTerminated()) {
                        Unit unit8;
                        Unit unit9;
                        this.downloadInfo.setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
                        this.downloadInfo.setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.onProgress(this.downloadInfo, this.downloadInfo.getEtaInMilliSeconds(), this.downloadInfo.getDownloadedBytesPerSecond());
                            unit9 = Unit.INSTANCE;
                        } else {
                            unit9 = null;
                        }
                        this.downloadInfo.setEtaInMilliSeconds(-1L);
                        this.downloadInfo.setDownloadedBytesPerSecond(-1L);
                        FileDownloader.Delegate delegate4 = this.getDelegate();
                        if (delegate4 != null) {
                            delegate4.onComplete(this.downloadInfo);
                            unit8 = Unit.INSTANCE;
                            break block84;
                        } else {
                            unit8 = null;
                        }
                    }
                    break block84;
                }
                FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
                throw (Throwable)new FetchException("invalid content hash");
            }
            FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
            if (this.getInterrupted() || this.getTerminated()) break block84;
            this.downloadInfo.setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
            this.downloadInfo.setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
            FileDownloader.Delegate delegate = this.getDelegate();
            if (delegate != null) {
                delegate.onProgress(this.downloadInfo, this.downloadInfo.getEtaInMilliSeconds(), this.downloadInfo.getDownloadedBytesPerSecond());
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            this.downloadInfo.setEtaInMilliSeconds(-1L);
            this.downloadInfo.setDownloadedBytesPerSecond(-1L);
            FileDownloader.Delegate delegate5 = this.getDelegate();
            if (delegate5 != null) {
                delegate5.onComplete(this.downloadInfo);
                unit = Unit.INSTANCE;
                break block84;
            }
            unit = null;
        }
        try {
            Unit unit;
            ExecutorService executorService = this.executorService;
            if (executorService != null) {
                executorService.shutdown();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (Exception e) {
            this.logger.e("FileDownloader", (Throwable)e);
        }
        try {
            Unit unit;
            OutputResourceWrapper outputResourceWrapper = this.outputResourceWrapper;
            if (outputResourceWrapper != null) {
                outputResourceWrapper.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (Exception e) {
            this.logger.e("FileDownloader", (Throwable)e);
        }
        if (openingResponse != null) {
            try {
                this.downloader.disconnect(openingResponse);
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
        }
        this.setTerminated(true);
        return;
        catch (Exception e) {
            block87: {
                try {
                    Unit unit;
                    if (this.getInterrupted() || this.getTerminated()) break block87;
                    this.logger.e("FileDownloader download:" + this.getDownload(), (Throwable)e);
                    Error error = FetchErrorUtils.getErrorFromThrowable(e);
                    error.setThrowable(e);
                    if (openingResponse != null) {
                        error.setHttpResponse(FetchCoreUtils.copyDownloadResponseNoStream((Downloader.Response)openingResponse));
                    }
                    if (this.retryOnNetworkGain) {
                        boolean disconnectDetected = !this.networkInfoProvider.isNetworkAvailable();
                        int $receiver$iv2 = 1;
                        int n = 10;
                        while ($receiver$iv2 <= n) {
                            void i;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e2) {
                                this.logger.e("FileDownloader", (Throwable)e2);
                                break;
                            }
                            if (!this.networkInfoProvider.isNetworkAvailable()) {
                                disconnectDetected = true;
                                break;
                            }
                            ++i;
                        }
                        if (disconnectDetected) {
                            error = Error.NO_NETWORK_CONNECTION;
                        }
                    }
                    this.downloadInfo.setDownloaded(this.downloaded);
                    this.downloadInfo.setTotal(this.total);
                    this.downloadInfo.setError(error);
                    if (this.getTerminated() || this.getInterrupted()) break block87;
                    this.downloadInfo.setEtaInMilliSeconds(-1L);
                    this.downloadInfo.setDownloadedBytesPerSecond(-1L);
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.onError(this.downloadInfo, error, e);
                        unit = Unit.INSTANCE;
                        break block87;
                    }
                    unit = null;
                }
                catch (Throwable throwable) {
                    try {
                        Unit unit;
                        ExecutorService executorService = this.executorService;
                        if (executorService != null) {
                            executorService.shutdown();
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                    }
                    catch (Exception e3) {
                        this.logger.e("FileDownloader", (Throwable)e3);
                    }
                    try {
                        Unit unit;
                        OutputResourceWrapper outputResourceWrapper = this.outputResourceWrapper;
                        if (outputResourceWrapper != null) {
                            outputResourceWrapper.close();
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                    }
                    catch (Exception e4) {
                        this.logger.e("FileDownloader", (Throwable)e4);
                    }
                    if (openingResponse != null) {
                        try {
                            this.downloader.disconnect(openingResponse);
                        }
                        catch (Exception e5) {
                            this.logger.e("FileDownloader", (Throwable)e5);
                        }
                    }
                    this.setTerminated(true);
                    throw throwable;
                }
            }
            try {
                Unit unit;
                ExecutorService executorService = this.executorService;
                if (executorService != null) {
                    executorService.shutdown();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            catch (Exception e6) {
                this.logger.e("FileDownloader", (Throwable)e6);
            }
            try {
                Unit unit;
                OutputResourceWrapper outputResourceWrapper = this.outputResourceWrapper;
                if (outputResourceWrapper != null) {
                    outputResourceWrapper.close();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            catch (Exception e7) {
                this.logger.e("FileDownloader", (Throwable)e7);
            }
            if (openingResponse != null) {
                try {
                    this.downloader.disconnect(openingResponse);
                }
                catch (Exception e8) {
                    this.logger.e("FileDownloader", (Throwable)e8);
                }
            }
            this.setTerminated(true);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileSlice> getFileSliceList(boolean acceptsRanges, Downloader.ServerRequest request) {
        List list;
        if (!this.storageResolver.fileExists(this.downloadInfo.getFile())) {
            FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
        }
        int previousSliceSize = FetchUtils.getPreviousSliceCount(this.downloadInfo.getId(), this.fileTempDir);
        if (acceptsRanges && !this.totalUnknown) {
            FileSliceInfo fileSliceInfo = this.getChuckInfo(request);
            if (previousSliceSize != fileSliceInfo.getSlicingCount()) {
                FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
            }
            FetchUtils.saveCurrentSliceCount(this.downloadInfo.getId(), fileSliceInfo.getSlicingCount(), this.fileTempDir);
            long counterBytes = 0L;
            List fileSlices = new ArrayList();
            int n = 1;
            int n2 = fileSliceInfo.getSlicingCount();
            if (n <= n2) {
                while (!this.getInterrupted() && !this.getTerminated()) {
                    void position;
                    long endBytes;
                    long startBytes = counterBytes;
                    counterBytes = endBytes = fileSliceInfo.getSlicingCount() == position ? this.total : counterBytes + fileSliceInfo.getBytesPerFileSlice();
                    FileSlice fileSlice = new FileSlice(this.downloadInfo.getId(), (int)position, startBytes, endBytes, FetchUtils.getSavedDownloadedInfo(this.downloadInfo.getId(), (int)position, this.fileTempDir));
                    this.downloaded += fileSlice.getDownloaded();
                    fileSlices.add(fileSlice);
                    if (position == n2) break;
                    ++position;
                }
            }
            list = fileSlices;
        } else {
            if (previousSliceSize != 1) {
                FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
            }
            FetchUtils.saveCurrentSliceCount(this.downloadInfo.getId(), 1, this.fileTempDir);
            FileSlice fileSlice = new FileSlice(this.downloadInfo.getId(), 1, 0L, this.total, FetchUtils.getSavedDownloadedInfo(this.downloadInfo.getId(), 1, this.fileTempDir));
            this.downloaded += fileSlice.getDownloaded();
            list = CollectionsKt.listOf((Object)fileSlice);
        }
        return list;
    }

    private final FileSliceInfo getChuckInfo(Downloader.ServerRequest request) {
        Integer n = this.downloader.getFileSlicingCount(request, this.total);
        int fileSliceSize = n != null ? n : -1;
        return FetchUtils.getFileSliceInfo(fileSliceSize, this.total);
    }

    private final long getAverageDownloadedBytesPerSecond() {
        if (this.averageDownloadedBytesPerSecond < 1.0) {
            return 0L;
        }
        double d = this.averageDownloadedBytesPerSecond;
        return (long)Math.ceil(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitAndPerformProgressReporting() {
        long reportingStopTime = 0L;
        long downloadSpeedStopTime = 0L;
        long downloadedBytesPerSecond = this.downloaded;
        long reportingStartTime = System.nanoTime();
        long downloadSpeedStartTime = System.nanoTime();
        while (this.actionsCounter != this.actionsTotal && !this.getInterrupted() && !this.getTerminated()) {
            boolean hasReportingTimeElapsed;
            this.downloadInfo.setDownloaded(this.downloaded);
            this.downloadInfo.setTotal(this.total);
            downloadSpeedStopTime = System.nanoTime();
            boolean downloadSpeedCheckTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)downloadSpeedStartTime, (long)downloadSpeedStopTime, (long)1000L);
            if (downloadSpeedCheckTimeElapsed) {
                downloadedBytesPerSecond = this.downloaded - downloadedBytesPerSecond;
                this.movingAverageCalculator.add((double)downloadedBytesPerSecond);
                this.averageDownloadedBytesPerSecond = AverageCalculator.getMovingAverageWithWeightOnRecentValues$default((AverageCalculator)this.movingAverageCalculator, (int)0, (int)1, null);
                this.estimatedTimeRemainingInMilliseconds = FetchCoreUtils.calculateEstimatedTimeRemainingInMilliseconds((long)this.downloaded, (long)this.total, (long)this.getAverageDownloadedBytesPerSecond());
                downloadedBytesPerSecond = this.downloaded;
            }
            if (hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)(reportingStopTime = System.nanoTime()), (long)this.progressReportingIntervalMillis)) {
                Object object = this.lock;
                synchronized (object) {
                    boolean bl = false;
                    if (!this.getInterrupted() && !this.getTerminated()) {
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.saveDownloadProgress(this.downloadInfo);
                        }
                        this.downloadInfo.setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
                        this.downloadInfo.setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
                        FileDownloader.Delegate delegate2 = this.getDelegate();
                        if (delegate2 != null) {
                            delegate2.onProgress(this.downloadInfo, this.downloadInfo.getEtaInMilliSeconds(), this.downloadInfo.getDownloadedBytesPerSecond());
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                reportingStartTime = System.nanoTime();
            }
            if (!downloadSpeedCheckTimeElapsed) continue;
            downloadSpeedStartTime = System.nanoTime();
        }
    }

    private final void downloadSliceFiles(Downloader.ServerRequest request, List<FileSlice> fileSlicesDownloadsList) {
        this.actionsCounter = 0;
        this.actionsTotal = fileSlicesDownloadsList.size();
        OutputResourceWrapper outputResourceWrapper = this.outputResourceWrapper = this.storageResolver.getRequestOutputResourceWrapper(request);
        if (outputResourceWrapper != null) {
            outputResourceWrapper.setWriteOffset(0L);
        }
        for (FileSlice fileSlice : fileSlicesDownloadsList) {
            if (this.getInterrupted() || this.getTerminated()) break;
            ExecutorService executorService = this.executorService;
            if (executorService == null) continue;
            executorService.execute(new Runnable(this, fileSlice){
                final /* synthetic */ ParallelFileDownloaderImpl this$0;
                final /* synthetic */ FileSlice $fileSlice;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final void run() {
                    block42: {
                        try {
                            v0 = Thread.currentThread();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"Thread.currentThread()");
                            v0.setName(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0).getNamespace() + '-' + ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0).getId() + "-Slice-" + this.$fileSlice.getPosition());
                        }
                        catch (Exception var1_1) {
                            // empty catch block
                        }
                        downloadBlock = new DownloadBlockInfo();
                        downloadBlock.setDownloadId(this.$fileSlice.getId());
                        downloadBlock.setBlockPosition(this.$fileSlice.getPosition());
                        downloadBlock.setDownloadedBytes(this.$fileSlice.getDownloaded());
                        downloadBlock.setStartByte(this.$fileSlice.getStartBytes());
                        downloadBlock.setEndByte(this.$fileSlice.getEndBytes());
                        downloadRequest = FetchUtils.getRequestForDownload$default(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0), this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded(), 0L, null, 12, null);
                        downloadResponse = null;
                        saveRandomAccessFile = null;
                        file = FetchCoreUtils.getFile((String)FetchUtils.getDownloadedInfoFilePath(this.$fileSlice.getId(), this.$fileSlice.getPosition(), ParallelFileDownloaderImpl.access$getFileTempDir$p(this.this$0)));
                        saveRandomAccessFile = new RandomAccessFile(file, "rw");
                        downloadResponse = ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).execute(downloadRequest, (InterruptMonitor)ParallelFileDownloaderImpl.access$getInterruptMonitor$p(this.this$0));
                        if (this.this$0.getTerminated() || this.this$0.getInterrupted()) ** GOTO lbl-1000
                        v1 = downloadResponse;
                        if (v1 == null) ** GOTO lbl-1000
                        if (v1.isSuccessful()) {
                            var6_14 = new Ref.LongRef();
                            bufferSize = ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).getRequestBufferSize(downloadRequest);
                            buffer = new byte[bufferSize];
                            v2 = downloadResponse.getByteStream();
                            read = v2 != null ? v2.read(buffer, 0, bufferSize) : -1;
                            naturalEnd = this.$fileSlice.getEndBytes() < 1L ? 0L : this.$fileSlice.getEndBytes();
                            remainderBytes = naturalEnd - (this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded());
                            reportingStartTime = System.nanoTime();
                            streamBytes = new Ref.IntRef();
                            var15_24 = new Ref.LongRef();
                            while (!(!ParallelFileDownloaderImpl.access$getTotalUnknown$p(this.this$0) && remainderBytes <= 0L || read == -1 || this.this$0.getInterrupted() || this.this$0.getTerminated())) {
                                if (ParallelFileDownloaderImpl.access$getTotalUnknown$p(this.this$0) || (long)read <= remainderBytes) {
                                    v3 = read;
                                } else {
                                    read = -1;
                                    v3 = (int)remainderBytes;
                                }
                                streamBytes.element = v3;
                                var15_24.element = this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded();
                                var16_25 = ParallelFileDownloaderImpl.access$getLock$p(this.this$0);
                                synchronized (var16_25) {
                                    $i$a$-synchronized-ParallelFileDownloaderImpl$downloadSliceFiles$1$1 = false;
                                    if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                        v4 = ParallelFileDownloaderImpl.access$getOutputResourceWrapper$p(this.this$0);
                                        if (v4 != null) {
                                            v4.setWriteOffset(var15_24.element);
                                        }
                                        v5 = ParallelFileDownloaderImpl.access$getOutputResourceWrapper$p(this.this$0);
                                        if (v5 != null) {
                                            v5.write(buffer, 0, streamBytes.element);
                                        }
                                        if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                            v6 = this.$fileSlice;
                                            v6.setDownloaded(v6.getDownloaded() + (long)streamBytes.element);
                                            saveRandomAccessFile.seek(0L);
                                            saveRandomAccessFile.setLength(0L);
                                            saveRandomAccessFile.writeLong(this.$fileSlice.getDownloaded());
                                            v7 = this.this$0;
                                            ParallelFileDownloaderImpl.access$setDownloaded$p(v7, ParallelFileDownloaderImpl.access$getDownloaded$p(v7) + (long)streamBytes.element);
                                        }
                                        var6_14.element = System.nanoTime();
                                        hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)var6_14.element, (long)ParallelFileDownloaderImpl.access$getProgressReportingIntervalMillis$p(this.this$0));
                                        if (hasReportingTimeElapsed) {
                                            if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                                downloadBlock.setDownloadedBytes(this.$fileSlice.getDownloaded());
                                                v8 = this.this$0.getDelegate();
                                                if (v8 != null) {
                                                    v8.onDownloadBlockUpdated(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0), (DownloadBlock)downloadBlock, ParallelFileDownloaderImpl.access$getTotalDownloadBlocks$p(this.this$0));
                                                }
                                            }
                                            reportingStartTime = System.nanoTime();
                                        }
                                    }
                                    var18_27 = Unit.INSTANCE;
                                }
                                if (this.this$0.getInterrupted() || this.this$0.getTerminated() || read == -1) continue;
                                v9 = downloadResponse.getByteStream();
                                v10 = read = v9 != null ? v9.read(buffer, 0, bufferSize) : -1;
                                if (ParallelFileDownloaderImpl.access$getTotalUnknown$p(this.this$0)) continue;
                                remainderBytes = naturalEnd - (this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded());
                            }
                        } else lbl-1000:
                        // 3 sources

                        {
                            if (downloadResponse == null && !this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                throw (Throwable)new FetchException("empty_response_body");
                            }
                            v11 = downloadResponse;
                            if (v11 != null) {
                                if (!v11.isSuccessful()) {
                                    if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                        throw (Throwable)new FetchException("request_not_successful");
                                    }
                                }
                            }
                            if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                throw (Throwable)new FetchException("unknown");
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [3 : 1006->1027)] { 
lbl-1000:
                        // 1 sources

                        {
                            if (downloadResponse != null) {
                                ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).disconnect(downloadResponse);
                            }
                        }
lbl100:
                        // 1 sources

                        catch (Exception e) {
                            ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader", (Throwable)e);
                        }
                        try {
                            saveRandomAccessFile.close();
                        }
                        catch (Exception e) {
                            ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader", (Throwable)e);
                        }
                        ParallelFileDownloaderImpl.access$incrementActionCompletedCount(this.this$0);
                        break block42;
                        catch (Exception e) {
                            ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader downloads slice " + this.$fileSlice, (Throwable)e);
                            ParallelFileDownloaderImpl.access$setThrowable$p(this.this$0, e);
                            break block42;
                        }
                        finally {
                            try {
                                if (downloadResponse != null) {
                                    ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).disconnect(downloadResponse);
                                }
                            }
                            catch (Exception e) {
                                ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader", (Throwable)e);
                            }
                            try {
                                v12 = saveRandomAccessFile;
                                if (v12 != null) {
                                    v12.close();
                                }
                            }
                            catch (Exception e) {
                                ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader", (Throwable)e);
                            }
                            ParallelFileDownloaderImpl.access$incrementActionCompletedCount(this.this$0);
                        }
                    }
                }
                {
                    this.this$0 = parallelFileDownloaderImpl;
                    this.$fileSlice = fileSlice;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void incrementActionCompletedCount() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            ++this.actionsCounter;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean isDownloadComplete() {
        return (this.downloaded > 0L && this.total > 0L || this.totalUnknown) && this.downloaded >= this.total;
    }

    private final void setIsTotalUnknown(Downloader.Response response2) {
        if (response2.isSuccessful() && response2.getContentLength() == -1L) {
            this.totalUnknown = true;
        }
    }

    private final void throwExceptionIfFound() {
        Throwable exception = this.throwable;
        if (exception != null) {
            throw exception;
        }
    }

    public ParallelFileDownloaderImpl(@NotNull Download initialDownload, @NotNull Downloader<?, ?> downloader, long progressReportingIntervalMillis, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, @NotNull String fileTempDir, boolean hashCheckingEnabled, @NotNull StorageResolver storageResolver) {
        Intrinsics.checkParameterIsNotNull((Object)initialDownload, (String)"initialDownload");
        Intrinsics.checkParameterIsNotNull(downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        Intrinsics.checkParameterIsNotNull((Object)storageResolver, (String)"storageResolver");
        this.initialDownload = initialDownload;
        this.downloader = downloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.fileTempDir = fileTempDir;
        this.hashCheckingEnabled = hashCheckingEnabled;
        this.storageResolver = storageResolver;
        this.downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(this.initialDownload);
        this.total = -1L;
        this.movingAverageCalculator = new AverageCalculator(5);
        this.estimatedTimeRemainingInMilliseconds = -1L;
        this.lock = new Object();
        this.fileSlices = CollectionsKt.emptyList();
        this.interruptMonitor = new InterruptMonitor(this){
            final /* synthetic */ ParallelFileDownloaderImpl this$0;

            public boolean isInterrupted() {
                return this.this$0.getInterrupted();
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ DownloadInfo access$getDownloadInfo$p(ParallelFileDownloaderImpl $this) {
        return $this.downloadInfo;
    }

    public static final /* synthetic */ String access$getFileTempDir$p(ParallelFileDownloaderImpl $this) {
        return $this.fileTempDir;
    }

    public static final /* synthetic */ Downloader access$getDownloader$p(ParallelFileDownloaderImpl $this) {
        return $this.downloader;
    }

    public static final /* synthetic */ interruptMonitor.1 access$getInterruptMonitor$p(ParallelFileDownloaderImpl $this) {
        return $this.interruptMonitor;
    }

    public static final /* synthetic */ boolean access$getTotalUnknown$p(ParallelFileDownloaderImpl $this) {
        return $this.totalUnknown;
    }

    public static final /* synthetic */ void access$setTotalUnknown$p(ParallelFileDownloaderImpl $this, boolean bl) {
        $this.totalUnknown = bl;
    }

    public static final /* synthetic */ Object access$getLock$p(ParallelFileDownloaderImpl $this) {
        return $this.lock;
    }

    public static final /* synthetic */ OutputResourceWrapper access$getOutputResourceWrapper$p(ParallelFileDownloaderImpl $this) {
        return $this.outputResourceWrapper;
    }

    public static final /* synthetic */ void access$setOutputResourceWrapper$p(ParallelFileDownloaderImpl $this, OutputResourceWrapper outputResourceWrapper) {
        $this.outputResourceWrapper = outputResourceWrapper;
    }

    public static final /* synthetic */ long access$getDownloaded$p(ParallelFileDownloaderImpl $this) {
        return $this.downloaded;
    }

    public static final /* synthetic */ void access$setDownloaded$p(ParallelFileDownloaderImpl $this, long l) {
        $this.downloaded = l;
    }

    public static final /* synthetic */ long access$getProgressReportingIntervalMillis$p(ParallelFileDownloaderImpl $this) {
        return $this.progressReportingIntervalMillis;
    }

    public static final /* synthetic */ int access$getTotalDownloadBlocks$p(ParallelFileDownloaderImpl $this) {
        return $this.totalDownloadBlocks;
    }

    public static final /* synthetic */ void access$setTotalDownloadBlocks$p(ParallelFileDownloaderImpl $this, int n) {
        $this.totalDownloadBlocks = n;
    }

    public static final /* synthetic */ Logger access$getLogger$p(ParallelFileDownloaderImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$incrementActionCompletedCount(ParallelFileDownloaderImpl $this) {
        $this.incrementActionCompletedCount();
    }

    public static final /* synthetic */ Throwable access$getThrowable$p(ParallelFileDownloaderImpl $this) {
        return $this.throwable;
    }

    public static final /* synthetic */ void access$setThrowable$p(ParallelFileDownloaderImpl $this, Throwable throwable) {
        $this.throwable = throwable;
    }
}

