/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2core.DownloadBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J&\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\"2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/tonyodev/fetch2/helper/FileDownloaderDelegate;", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "fetchListener", "Lcom/tonyodev/fetch2/FetchListener;", "retryOnNetworkGain", "", "(Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;Lcom/tonyodev/fetch2/FetchListener;Z)V", "interrupted", "getInterrupted", "()Z", "setInterrupted", "(Z)V", "onComplete", "", "download", "Lcom/tonyodev/fetch2/Download;", "onDownloadBlockUpdated", "downloadBlock", "Lcom/tonyodev/fetch2core/DownloadBlock;", "totalBlocks", "", "onError", "error", "Lcom/tonyodev/fetch2/Error;", "throwable", "", "onProgress", "etaInMilliSeconds", "", "downloadedBytesPerSecond", "onStarted", "downloadBlocks", "", "saveDownloadProgress", "fetch2_release"})
public final class FileDownloaderDelegate
implements FileDownloader.Delegate {
    private volatile boolean interrupted;
    private final DownloadInfoUpdater downloadInfoUpdater;
    private final FetchListener fetchListener;
    private final boolean retryOnNetworkGain;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    @Override
    public void onStarted(@NotNull Download download, @NotNull List<? extends DownloadBlock> downloadBlocks, int totalBlocks) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Intrinsics.checkParameterIsNotNull(downloadBlocks, (String)"downloadBlocks");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            downloadInfo.setStatus(Status.DOWNLOADING);
            this.downloadInfoUpdater.update(downloadInfo);
            this.fetchListener.onStarted(download, downloadBlocks, totalBlocks);
        }
    }

    @Override
    public void onProgress(@NotNull Download download, long etaInMilliSeconds, long downloadedBytesPerSecond) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            this.fetchListener.onProgress(download, etaInMilliSeconds, downloadedBytesPerSecond);
        }
    }

    @Override
    public void onDownloadBlockUpdated(@NotNull Download download, @NotNull DownloadBlock downloadBlock2, int totalBlocks) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Intrinsics.checkParameterIsNotNull((Object)downloadBlock2, (String)"downloadBlock");
        if (!this.getInterrupted()) {
            this.fetchListener.onDownloadBlockUpdated(download, downloadBlock2, totalBlocks);
        }
    }

    @Override
    public void onError(@NotNull Download download, @NotNull Error error, @Nullable Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Intrinsics.checkParameterIsNotNull((Object)((Object)error), (String)"error");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            if (this.retryOnNetworkGain && downloadInfo.getError() == Error.NO_NETWORK_CONNECTION) {
                downloadInfo.setStatus(Status.QUEUED);
                downloadInfo.setError(FetchDefaults.getDefaultNoError());
                this.downloadInfoUpdater.update(downloadInfo);
                this.fetchListener.onQueued(download, true);
            } else {
                downloadInfo.setStatus(Status.FAILED);
                this.downloadInfoUpdater.update(downloadInfo);
                this.fetchListener.onError(download, error, throwable);
            }
        }
    }

    @Override
    public void onComplete(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            downloadInfo.setStatus(Status.COMPLETED);
            this.downloadInfoUpdater.update(downloadInfo);
            this.fetchListener.onCompleted(download);
        }
    }

    @Override
    public void saveDownloadProgress(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            downloadInfo.setStatus(Status.DOWNLOADING);
            this.downloadInfoUpdater.updateFileBytesInfoAndStatusOnly(downloadInfo);
        }
    }

    public FileDownloaderDelegate(@NotNull DownloadInfoUpdater downloadInfoUpdater, @NotNull FetchListener fetchListener, boolean retryOnNetworkGain) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfoUpdater, (String)"downloadInfoUpdater");
        Intrinsics.checkParameterIsNotNull((Object)fetchListener, (String)"fetchListener");
        this.downloadInfoUpdater = downloadInfoUpdater;
        this.fetchListener = fetchListener;
        this.retryOnNetworkGain = retryOnNetworkGain;
    }
}

