/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.os.Handler;
import android.os.Looper;
import com.tonyodev.fetch2.CompletedDownload;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.FetchNotificationManager;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.fetch.FetchHandlerImpl$WhenMappings;
import com.tonyodev.fetch2.fetch.FetchModulesBuilder;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.DownloadBlockInfo;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileResource;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.FileSliceInfo;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.StorageResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u0010\u001bJ \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0'H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0'H\u0016J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0'H\u0002J\u0016\u0010-\u001a\u00020#2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0'H\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u0010/\u001a\u00020\u001eH\u0016J\b\u00100\u001a\u00020#H\u0016J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0'H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\n0'H\u0016J$\u00103\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u00104\u001a\u00020\u001e2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060'H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u00108\u001a\u000206H\u0016J\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0'H\u0002J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u0010/\u001a\u00020\u001eH\u0016J\u0010\u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020\u000eH\u0016J\u001c\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020?0>2\u0006\u0010@\u001a\u00020AH\u0016J(\u0010=\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020?0>0'2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020A0'H\u0016J\u0010\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020EH\u0016J\u001c\u0010F\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020E0'H\u0016J(\u0010H\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020?0>0'2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020A0'H\u0002J\b\u0010I\u001a\u00020#H\u0016J\u0018\u0010J\u001a\u00020K2\u0006\u0010@\u001a\u00020A2\u0006\u0010L\u001a\u00020\u000eH\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010\n2\u0006\u0010/\u001a\u00020\u001eH\u0016J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020O0'2\u0006\u0010/\u001a\u00020\u001eH\u0016J\u000e\u0010P\u001a\b\u0012\u0004\u0012\u00020\n0'H\u0016J\u001c\u0010P\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u001e0'H\u0016J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u0010S\u001a\u00020KH\u0016J\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u0010/\u001a\u00020\u001eH\u0016J$\u0010U\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u00104\u001a\u00020\u001e2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060'H\u0016J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u00108\u001a\u000206H\u0016J\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020X0'2\u0006\u0010@\u001a\u00020AH\u0016J\u000e\u0010Y\u001a\b\u0012\u0004\u0012\u00020!0ZH\u0016J\b\u0010[\u001a\u00020KH\u0016J&\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020\u00032\u0014\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010`H\u0016J\b\u0010a\u001a\u00020\u000eH\u0016J\b\u0010b\u001a\u00020#H\u0016J\u001c\u0010c\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0'H\u0016J\u001c\u0010d\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0'H\u0002J\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u0010/\u001a\u00020\u001eH\u0016J\u0010\u0010f\u001a\u00020#2\u0006\u0010g\u001a\u00020,H\u0002J\u0010\u0010h\u001a\u00020\u000e2\u0006\u0010g\u001a\u00020,H\u0002J\u001c\u0010i\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0'H\u0016J\u000e\u0010j\u001a\b\u0012\u0004\u0012\u00020\n0'H\u0016J$\u0010k\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u00104\u001a\u00020\u001e2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060'H\u0016J\u0016\u0010l\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u00108\u001a\u000206H\u0016J\u001c\u0010m\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0'H\u0002J\u0016\u0010n\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u0010/\u001a\u00020\u001eH\u0016J\u0010\u0010o\u001a\u00020#2\u0006\u0010$\u001a\u00020!H\u0016J\u0018\u0010p\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u001e2\u0006\u0010q\u001a\u00020rH\u0016J\u001c\u0010s\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0'H\u0016J\u001c\u0010t\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010u\u001a\b\u0012\u0004\u0012\u00020\u001e0'H\u0002J\u0016\u0010v\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u0010/\u001a\u00020\u001eH\u0016J\u001c\u0010w\u001a\b\u0012\u0004\u0012\u00020\n0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0'H\u0016J\u0010\u0010x\u001a\u00020#2\u0006\u0010y\u001a\u00020\u001eH\u0016J\u0010\u0010z\u001a\u00020#2\u0006\u0010{\u001a\u00020|H\u0016J\b\u0010}\u001a\u00020#H\u0002J\b\u0010~\u001a\u00020#H\u0016J&\u0010\u007f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0>2\u0007\u0010\u0080\u0001\u001a\u00020\u001e2\u0007\u0010\u0081\u0001\u001a\u00020AH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0082\u0001"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchHandlerImpl;", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "namespace", "", "databaseManager", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "priorityListProcessor", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "autoStart", "", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "uiHandler", "Landroid/os/Handler;", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "fetchNotificationManager", "Lcom/tonyodev/fetch2/FetchNotificationManager;", "(Ljava/lang/String;Lcom/tonyodev/fetch2/database/DatabaseManager;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/helper/PriorityListProcessor;Lcom/tonyodev/fetch2core/Logger;ZLcom/tonyodev/fetch2core/Downloader;Lcom/tonyodev/fetch2core/FileServerDownloader;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Landroid/os/Handler;Lcom/tonyodev/fetch2core/StorageResolver;Lcom/tonyodev/fetch2/FetchNotificationManager;)V", "isTerminating", "listenerId", "", "listenerSet", "", "Lcom/tonyodev/fetch2/FetchListener;", "addListener", "", "listener", "notify", "cancel", "", "ids", "cancelAll", "cancelDownloads", "downloads", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "cancelDownloadsIfDownloading", "cancelGroup", "id", "close", "delete", "deleteAll", "deleteAllInGroupWithStatus", "groupId", "statuses", "Lcom/tonyodev/fetch2/Status;", "deleteAllWithStatus", "status", "deleteDownloads", "deleteGroup", "enableLogging", "enabled", "enqueue", "Lkotlin/Pair;", "Lcom/tonyodev/fetch2/Error;", "request", "Lcom/tonyodev/fetch2/Request;", "requests", "enqueueCompletedDownload", "completedDownload", "Lcom/tonyodev/fetch2/CompletedDownload;", "enqueueCompletedDownloads", "completedDownloads", "enqueueRequests", "freeze", "getContentLengthForRequest", "", "fromServer", "getDownload", "getDownloadBlocks", "Lcom/tonyodev/fetch2core/DownloadBlock;", "getDownloads", "idList", "getDownloadsByRequestIdentifier", "identifier", "getDownloadsInGroup", "getDownloadsInGroupWithStatus", "getDownloadsWithStatus", "getFetchFileServerCatalog", "Lcom/tonyodev/fetch2core/FileResource;", "getListenerSet", "", "getPendingCount", "getServerResponse", "Lcom/tonyodev/fetch2core/Downloader$Response;", "url", "header", "", "hasActiveDownloads", "init", "pause", "pauseDownloads", "pausedGroup", "prepareCompletedDownloadInfoForEnqueue", "downloadInfo", "prepareDownloadInfoForEnqueue", "remove", "removeAll", "removeAllInGroupWithStatus", "removeAllWithStatus", "removeDownloads", "removeGroup", "removeListener", "replaceExtras", "extras", "Lcom/tonyodev/fetch2core/Extras;", "resume", "resumeDownloads", "downloadIds", "resumeGroup", "retry", "setDownloadConcurrentLimit", "downloadConcurrentLimit", "setGlobalNetworkType", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "startPriorityQueueIfNotStarted", "unfreeze", "updateRequest", "requestId", "newRequest", "fetch2_release"})
public final class FetchHandlerImpl
implements FetchHandler {
    private final int listenerId;
    private final Set<FetchListener> listenerSet;
    private volatile boolean isTerminating;
    private final String namespace;
    private final DatabaseManager databaseManager;
    private final DownloadManager downloadManager;
    private final PriorityListProcessor<Download> priorityListProcessor;
    private final Logger logger;
    private final boolean autoStart;
    private final Downloader<?, ?> httpDownloader;
    private final FileServerDownloader fileServerDownloader;
    private final ListenerCoordinator listenerCoordinator;
    private final Handler uiHandler;
    private final StorageResolver storageResolver;
    private final FetchNotificationManager fetchNotificationManager;

    @Override
    public void init() {
        if (this.fetchNotificationManager != null) {
            this.listenerCoordinator.addNotificationManager(this.fetchNotificationManager);
        }
        this.databaseManager.sanitizeOnFirstEntry();
        if (this.autoStart) {
            this.priorityListProcessor.start();
        }
    }

    @Override
    @NotNull
    public Pair<Download, Error> enqueue(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (Pair)CollectionsKt.first(this.enqueueRequests(CollectionsKt.listOf((Object)request)));
    }

    @Override
    @NotNull
    public List<Pair<Download, Error>> enqueue(@NotNull List<? extends Request> requests) {
        Intrinsics.checkParameterIsNotNull(requests, (String)"requests");
        return this.enqueueRequests(requests);
    }

    private final List<Pair<Download, Error>> enqueueRequests(List<? extends Request> requests) {
        List results = new ArrayList();
        Iterable $receiver$iv = requests;
        for (Object element$iv : $receiver$iv) {
            Request it = (Request)element$iv;
            DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(it);
            downloadInfo.setNamespace(this.namespace);
            try {
                boolean existing = this.prepareDownloadInfoForEnqueue(downloadInfo);
                if (downloadInfo.getStatus() != Status.COMPLETED) {
                    downloadInfo.setStatus(it.getDownloadOnEnqueue() ? Status.QUEUED : Status.ADDED);
                    if (!existing) {
                        Pair<DownloadInfo, Boolean> downloadPair = this.databaseManager.insert(downloadInfo);
                        this.logger.d("Enqueued download " + (DownloadInfo)downloadPair.getFirst());
                        results.add(new Pair(downloadPair.getFirst(), (Object)Error.NONE));
                        continue;
                    }
                    this.databaseManager.update(downloadInfo);
                    this.logger.d("Updated download " + downloadInfo);
                    results.add(new Pair((Object)downloadInfo, (Object)Error.NONE));
                    continue;
                }
                results.add(new Pair((Object)downloadInfo, (Object)Error.NONE));
            }
            catch (Exception e) {
                Error error = FetchErrorUtils.getErrorFromThrowable(e);
                error.setThrowable(e);
                results.add(new Pair((Object)downloadInfo, (Object)error));
            }
        }
        this.startPriorityQueueIfNotStarted();
        return results;
    }

    private final boolean prepareDownloadInfoForEnqueue(DownloadInfo downloadInfo) {
        boolean bl;
        this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)downloadInfo));
        DownloadInfo existingDownload = this.databaseManager.getByFile(downloadInfo.getFile());
        if (existingDownload == null) {
            if (downloadInfo.getEnqueueAction() != EnqueueAction.INCREMENT_FILE_NAME) {
                StorageResolver.DefaultImpls.createFile$default((StorageResolver)this.storageResolver, (String)downloadInfo.getFile(), (boolean)false, (int)2, null);
            }
        } else {
            this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)existingDownload));
            existingDownload = this.databaseManager.getByFile(downloadInfo.getFile());
            if (existingDownload != null && existingDownload.getStatus() == Status.DOWNLOADING) {
                existingDownload.setStatus(Status.QUEUED);
                try {
                    this.databaseManager.update(existingDownload);
                }
                catch (Exception exception) {}
            } else {
                DownloadInfo downloadInfo2 = existingDownload;
                if ((downloadInfo2 != null ? downloadInfo2.getStatus() : null) == Status.COMPLETED && downloadInfo.getEnqueueAction() == EnqueueAction.UPDATE_ACCORDINGLY && !this.storageResolver.fileExists(existingDownload.getFile())) {
                    try {
                        this.databaseManager.delete(existingDownload);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    existingDownload = null;
                    if (downloadInfo.getEnqueueAction() != EnqueueAction.INCREMENT_FILE_NAME) {
                        StorageResolver.DefaultImpls.createFile$default((StorageResolver)this.storageResolver, (String)downloadInfo.getFile(), (boolean)false, (int)2, null);
                    }
                }
            }
        }
        switch (FetchHandlerImpl$WhenMappings.$EnumSwitchMapping$0[downloadInfo.getEnqueueAction().ordinal()]) {
            case 1: {
                if (existingDownload != null) {
                    downloadInfo.setDownloaded(existingDownload.getDownloaded());
                    downloadInfo.setTotal(existingDownload.getTotal());
                    downloadInfo.setError(existingDownload.getError());
                    downloadInfo.setStatus(existingDownload.getStatus());
                    if (downloadInfo.getStatus() != Status.COMPLETED) {
                        downloadInfo.setStatus(Status.QUEUED);
                        downloadInfo.setError(FetchDefaults.getDefaultNoError());
                    }
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (existingDownload != null) {
                    throw (Throwable)new FetchException("request_with_file_path_already_exist");
                }
                bl = false;
                break;
            }
            case 3: {
                if (existingDownload != null) {
                    this.deleteDownloads(CollectionsKt.listOf((Object)existingDownload));
                }
                this.deleteDownloads(CollectionsKt.listOf((Object)downloadInfo));
                return false;
            }
            case 4: {
                String file = this.storageResolver.createFile(downloadInfo.getFile(), true);
                downloadInfo.setFile(file);
                downloadInfo.setId(FetchCoreUtils.getUniqueId((String)downloadInfo.getUrl(), (String)downloadInfo.getFile()));
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Download enqueueCompletedDownload(@NotNull CompletedDownload completedDownload) {
        Intrinsics.checkParameterIsNotNull((Object)completedDownload, (String)"completedDownload");
        return (Download)CollectionsKt.first(this.enqueueCompletedDownloads(CollectionsKt.listOf((Object)completedDownload)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> enqueueCompletedDownloads(@NotNull List<? extends CompletedDownload> completedDownloads) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(completedDownloads, (String)"completedDownloads");
        Iterable iterable = $receiver$iv = (Iterable)completedDownloads;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CompletedDownload completedDownload = (CompletedDownload)item$iv$iv;
            Collection collection = destination$iv$iv;
            DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo((CompletedDownload)it);
            downloadInfo.setNamespace(this.namespace);
            downloadInfo.setStatus(Status.COMPLETED);
            this.prepareCompletedDownloadInfoForEnqueue(downloadInfo);
            Pair<DownloadInfo, Boolean> downloadPair = this.databaseManager.insert(downloadInfo);
            this.logger.d("Enqueued CompletedDownload " + (DownloadInfo)downloadPair.getFirst());
            DownloadInfo downloadInfo2 = (DownloadInfo)downloadPair.getFirst();
            collection.add(downloadInfo2);
        }
        return (List)destination$iv$iv;
    }

    private final void prepareCompletedDownloadInfoForEnqueue(DownloadInfo downloadInfo) {
        DownloadInfo existingDownload = this.databaseManager.getByFile(downloadInfo.getFile());
        if (existingDownload != null) {
            this.deleteDownloads(CollectionsKt.listOf((Object)downloadInfo));
        }
    }

    @Override
    @NotNull
    public List<Download> pause(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.pauseDownloads(CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> pausedGroup(int id) {
        return this.pauseDownloads(this.databaseManager.getByGroup(id));
    }

    private final List<Download> pauseDownloads(List<DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        List pausedDownloads = new ArrayList();
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canPauseDownload(it)) continue;
            it.setStatus(Status.PAUSED);
            pausedDownloads.add(it);
        }
        this.databaseManager.update(pausedDownloads);
        return pausedDownloads;
    }

    @Override
    public void freeze() {
        this.priorityListProcessor.pause();
        this.downloadManager.cancelAll();
    }

    @Override
    public void unfreeze() {
        this.priorityListProcessor.resume();
    }

    @Override
    @NotNull
    public List<Download> resume(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.resumeDownloads(ids);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> resumeGroup(int id) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.databaseManager.getByGroup(id);
        FetchHandlerImpl fetchHandlerImpl = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.resumeDownloads((List<Integer>)collection);
    }

    private final List<Download> resumeDownloads(List<Integer> downloadIds) {
        List downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(downloadIds));
        List resumedDownloads = new ArrayList();
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (this.downloadManager.contains(it.getId()) || !FetchUtils.canResumeDownload(it)) continue;
            it.setStatus(Status.QUEUED);
            resumedDownloads.add(it);
        }
        this.databaseManager.update(resumedDownloads);
        this.startPriorityQueueIfNotStarted();
        return resumedDownloads;
    }

    @Override
    @NotNull
    public List<Download> remove(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.removeDownloads(CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> removeGroup(int id) {
        return this.removeDownloads(this.databaseManager.getByGroup(id));
    }

    @Override
    @NotNull
    public List<Download> removeAll() {
        return this.removeDownloads(this.databaseManager.get());
    }

    @Override
    @NotNull
    public List<Download> removeAllWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        return this.removeDownloads(this.databaseManager.getByStatus(status));
    }

    @Override
    @NotNull
    public List<Download> removeAllInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
        return this.removeDownloads(this.databaseManager.getDownloadsInGroupWithStatus(groupId, statuses));
    }

    private final List<Download> removeDownloads(List<DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        this.databaseManager.delete(downloads);
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(Status.REMOVED);
            DatabaseManager.Delegate delegate = this.databaseManager.getDelegate();
            if (delegate == null) continue;
            delegate.deleteTempFilesForDownload(it);
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<Download> delete(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.deleteDownloads(CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> deleteGroup(int id) {
        return this.deleteDownloads(this.databaseManager.getByGroup(id));
    }

    @Override
    @NotNull
    public List<Download> deleteAll() {
        return this.deleteDownloads(this.databaseManager.get());
    }

    @Override
    @NotNull
    public List<Download> deleteAllWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        return this.deleteDownloads(this.databaseManager.getByStatus(status));
    }

    @Override
    @NotNull
    public List<Download> deleteAllInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
        return this.deleteDownloads(this.databaseManager.getDownloadsInGroupWithStatus(groupId, statuses));
    }

    private final List<Download> deleteDownloads(List<DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        this.databaseManager.delete(downloads);
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(Status.DELETED);
            this.storageResolver.deleteFile(it.getFile());
            DatabaseManager.Delegate delegate = this.databaseManager.getDelegate();
            if (delegate == null) continue;
            delegate.deleteTempFilesForDownload(it);
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<Download> cancel(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.cancelDownloads(CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> cancelGroup(int id) {
        return this.cancelDownloads(this.databaseManager.getByGroup(id));
    }

    @Override
    @NotNull
    public List<Download> cancelAll() {
        return this.cancelDownloads(this.databaseManager.get());
    }

    private final List<Download> cancelDownloads(List<DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        List cancelledDownloads = new ArrayList();
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
            cancelledDownloads.add(it);
        }
        this.databaseManager.update(cancelledDownloads);
        return cancelledDownloads;
    }

    @Override
    @NotNull
    public List<Download> retry(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        List downloadInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids));
        List retryDownloads = new ArrayList();
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canRetryDownload(it)) continue;
            it.setStatus(Status.QUEUED);
            it.setError(FetchDefaults.getDefaultNoError());
            retryDownloads.add(it);
        }
        this.databaseManager.update(retryDownloads);
        this.startPriorityQueueIfNotStarted();
        return retryDownloads;
    }

    @Override
    @NotNull
    public Pair<Download, Boolean> updateRequest(int requestId, @NotNull Request newRequest) {
        Intrinsics.checkParameterIsNotNull((Object)newRequest, (String)"newRequest");
        DownloadInfo oldDownloadInfo = this.databaseManager.get(requestId);
        if (oldDownloadInfo != null) {
            this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)oldDownloadInfo));
            oldDownloadInfo = this.databaseManager.get(requestId);
        }
        if (oldDownloadInfo != null) {
            if (Intrinsics.areEqual((Object)newRequest.getFile(), (Object)oldDownloadInfo.getFile())) {
                DownloadInfo newDownloadInfo = FetchTypeConverterExtensions.toDownloadInfo(newRequest);
                newDownloadInfo.setNamespace(this.namespace);
                newDownloadInfo.setDownloaded(oldDownloadInfo.getDownloaded());
                newDownloadInfo.setTotal(oldDownloadInfo.getTotal());
                if (oldDownloadInfo.getStatus() == Status.DOWNLOADING) {
                    newDownloadInfo.setStatus(Status.QUEUED);
                    newDownloadInfo.setError(FetchDefaults.getDefaultNoError());
                } else {
                    newDownloadInfo.setStatus(oldDownloadInfo.getStatus());
                    newDownloadInfo.setError(oldDownloadInfo.getError());
                }
                this.databaseManager.delete(oldDownloadInfo);
                this.databaseManager.insert(newDownloadInfo);
                this.startPriorityQueueIfNotStarted();
                return new Pair((Object)newDownloadInfo, (Object)true);
            }
        } else {
            throw (Throwable)new FetchException("request_does_not_exist");
        }
        this.delete(CollectionsKt.listOf((Object)requestId));
        Pair<Download, Error> enqueuePair = this.enqueue(newRequest);
        return new Pair(enqueuePair.getFirst(), (Object)((Error)((Object)enqueuePair.getSecond()) == Error.NONE ? 1 : 0));
    }

    @Override
    @NotNull
    public Download replaceExtras(int id, @NotNull Extras extras) {
        DownloadInfo downloadInfo;
        Intrinsics.checkParameterIsNotNull((Object)extras, (String)"extras");
        DownloadInfo downloadInfo2 = this.databaseManager.get(id);
        if (downloadInfo2 != null) {
            this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)downloadInfo2));
            downloadInfo2 = this.databaseManager.get(id);
        }
        if (downloadInfo2 != null) {
            DownloadInfo download;
            downloadInfo = download = this.databaseManager.updateExtras(id, extras);
            if (downloadInfo == null) {
                throw (Throwable)new FetchException("request_does_not_exist");
            }
        } else {
            throw (Throwable)new FetchException("request_does_not_exist");
        }
        return downloadInfo;
    }

    @Override
    @NotNull
    public List<Download> getDownloads() {
        return this.databaseManager.get();
    }

    @Override
    @Nullable
    public Download getDownload(int id) {
        return this.databaseManager.get(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloads(@NotNull List<Integer> idList) {
        Intrinsics.checkParameterIsNotNull(idList, (String)"idList");
        return CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(idList));
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroup(int id) {
        return this.databaseManager.getByGroup(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        return this.databaseManager.getByStatus(status);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
        return this.databaseManager.getDownloadsInGroupWithStatus(groupId, statuses);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsByRequestIdentifier(long identifier) {
        return this.databaseManager.getDownloadsByRequestIdentifier(identifier);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadBlock> getDownloadBlocks(int id) {
        List list;
        DownloadInfo download = this.databaseManager.get(id);
        if (download != null) {
            String fileTempDir = this.downloadManager.getDownloadFileTempDir(download);
            FileSliceInfo fileSliceInfo = FetchUtils.getFileSliceInfo(FetchUtils.getPreviousSliceCount(download.getId(), fileTempDir), download.getTotal());
            if (download.getTotal() < 1L) {
                list = CollectionsKt.emptyList();
            } else if (fileSliceInfo.getSlicingCount() < 2) {
                DownloadBlockInfo downloadBlockInfo = new DownloadBlockInfo();
                downloadBlockInfo.setDownloadId(download.getId());
                downloadBlockInfo.setBlockPosition(1);
                downloadBlockInfo.setStartByte(0L);
                downloadBlockInfo.setEndByte(download.getTotal());
                downloadBlockInfo.setDownloadedBytes(download.getDownloaded());
                list = CollectionsKt.listOf((Object)downloadBlockInfo);
            } else {
                long counterBytes = 0L;
                List downloadBlocksList = new ArrayList();
                int n = 1;
                int n2 = fileSliceInfo.getSlicingCount();
                if (n <= n2) {
                    while (true) {
                        void position;
                        long endBytes;
                        long startBytes = counterBytes;
                        counterBytes = endBytes = fileSliceInfo.getSlicingCount() == position ? download.getTotal() : counterBytes + fileSliceInfo.getBytesPerFileSlice();
                        DownloadBlockInfo downloadBlockInfo = new DownloadBlockInfo();
                        downloadBlockInfo.setDownloadId(download.getId());
                        downloadBlockInfo.setBlockPosition((int)position);
                        downloadBlockInfo.setStartByte(startBytes);
                        downloadBlockInfo.setEndByte(endBytes);
                        downloadBlockInfo.setDownloadedBytes(FetchUtils.getSavedDownloadedInfo(download.getId(), (int)position, fileTempDir));
                        downloadBlocksList.add(downloadBlockInfo);
                        if (position == n2) break;
                        ++position;
                    }
                }
                list = downloadBlocksList;
            }
        } else {
            return CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public long getContentLengthForRequest(@NotNull Request request, boolean fromServer) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        DownloadInfo download = this.databaseManager.get(request.getId());
        if (download != null && download.getTotal() > 0L) {
            return download.getTotal();
        }
        return fromServer ? (FetchCoreUtils.isFetchFileServerUrl((String)request.getUrl()) ? this.fileServerDownloader.getRequestContentLength(FetchUtils.getServerRequestFromRequest(request)) : this.httpDownloader.getRequestContentLength(FetchUtils.getServerRequestFromRequest(request))) : -1L;
    }

    @Override
    @NotNull
    public Downloader.Response getServerResponse(@NotNull String url, @Nullable Map<String, String> header) {
        Downloader.Response copy;
        Downloader.Response response2;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Request request = new Request(url, "");
        Map<String, String> map = header;
        if (map != null) {
            Map<String, String> $receiver$iv;
            Map<String, String> map2 = $receiver$iv = map;
            Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                request.addHeader(it.getKey(), it.getValue());
            }
        }
        Downloader.ServerRequest serverRequest = FetchUtils.getServerRequestFromRequest(request);
        InterruptMonitor interruptMonitor2 = new InterruptMonitor(){

            public boolean isInterrupted() {
                return false;
            }
        };
        if (FetchCoreUtils.isFetchFileServerUrl((String)request.getUrl())) {
            response2 = this.fileServerDownloader.execute(serverRequest, interruptMonitor2);
            if (response2 != null) {
                copy = FetchCoreUtils.copyDownloadResponseNoStream((Downloader.Response)response2);
                this.fileServerDownloader.disconnect(response2);
                return copy;
            }
        } else {
            response2 = this.httpDownloader.execute(serverRequest, interruptMonitor2);
            if (response2 != null) {
                copy = FetchCoreUtils.copyDownloadResponseNoStream((Downloader.Response)response2);
                this.httpDownloader.disconnect(response2);
                return copy;
            }
        }
        throw (Throwable)new IOException("request_not_successful");
    }

    @Override
    @NotNull
    public List<FileResource> getFetchFileServerCatalog(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return this.fileServerDownloader.getFetchFileServerCatalog(FetchUtils.getCatalogServerRequestFromRequest(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isTerminating) {
            return;
        }
        this.isTerminating = true;
        Set<FetchListener> set = this.listenerSet;
        synchronized (set) {
            Unit $receiver$iv;
            Unit unit;
            Unit unit2 = unit = ($receiver$iv = this.listenerSet.iterator());
            while (unit2.hasNext()) {
                FetchListener element$iv;
                FetchListener it = element$iv = unit2.next();
                this.listenerCoordinator.removeListener(this.listenerId, it);
            }
            this.listenerSet.clear();
            unit = Unit.INSTANCE;
        }
        if (this.fetchNotificationManager != null) {
            this.listenerCoordinator.removeNotificationManager(this.fetchNotificationManager);
            this.listenerCoordinator.cancelOnGoingNotifications(this.fetchNotificationManager);
        }
        this.priorityListProcessor.stop();
        this.priorityListProcessor.close();
        this.downloadManager.close();
        FetchModulesBuilder.INSTANCE.removeNamespaceInstanceReference(this.namespace);
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        List downloads;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"networkType");
        this.priorityListProcessor.stop();
        this.priorityListProcessor.setGlobalNetworkType(networkType);
        List<Integer> ids = this.downloadManager.getActiveDownloadsIds();
        Collection collection2 = ids;
        if (!collection2.isEmpty() && !(collection = (Collection)(downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids)))).isEmpty()) {
            this.cancelDownloadsIfDownloading(downloads);
            downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids));
            Iterable $receiver$iv = downloads;
            for (Object element$iv : $receiver$iv) {
                DownloadInfo it = (DownloadInfo)element$iv;
                if (it.getStatus() != Status.DOWNLOADING) continue;
                it.setStatus(Status.QUEUED);
                it.setError(FetchDefaults.getDefaultNoError());
            }
            this.databaseManager.update(downloads);
        }
        this.priorityListProcessor.start();
    }

    @Override
    public void setDownloadConcurrentLimit(int downloadConcurrentLimit) {
        List downloads;
        Collection collection;
        this.priorityListProcessor.stop();
        List<Integer> ids = this.downloadManager.getActiveDownloadsIds();
        Collection collection2 = ids;
        if (!collection2.isEmpty() && !(collection = (Collection)(downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids)))).isEmpty()) {
            this.cancelDownloadsIfDownloading(downloads);
            downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids));
            this.downloadManager.setConcurrentLimit(downloadConcurrentLimit);
            this.priorityListProcessor.setDownloadConcurrentLimit(downloadConcurrentLimit);
            Iterable $receiver$iv = downloads;
            for (Object element$iv : $receiver$iv) {
                DownloadInfo it = (DownloadInfo)element$iv;
                if (it.getStatus() != Status.DOWNLOADING) continue;
                it.setStatus(Status.QUEUED);
                it.setError(FetchDefaults.getDefaultNoError());
            }
            this.databaseManager.update(downloads);
        }
        this.priorityListProcessor.start();
    }

    @Override
    public void enableLogging(boolean enabled) {
        this.logger.d("Enable logging - " + enabled);
        this.logger.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@NotNull FetchListener listener, boolean notify, boolean autoStart) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Set<FetchListener> set = this.listenerSet;
        synchronized (set) {
            boolean bl = this.listenerSet.add(listener);
        }
        this.listenerCoordinator.addListener(this.listenerId, listener);
        if (notify) {
            List<DownloadInfo> downloads = this.databaseManager.get();
            Iterable $receiver$iv = downloads;
            for (Object element$iv : $receiver$iv) {
                DownloadInfo it = (DownloadInfo)element$iv;
                this.uiHandler.post(new Runnable(it, this, listener){
                    final /* synthetic */ DownloadInfo $it;
                    final /* synthetic */ FetchHandlerImpl this$0;
                    final /* synthetic */ FetchListener $listener$inlined;
                    {
                        this.$it = downloadInfo;
                        this.this$0 = fetchHandlerImpl;
                        this.$listener$inlined = fetchListener;
                    }

                    public final void run() {
                        switch (FetchHandlerImpl$WhenMappings.$EnumSwitchMapping$1[this.$it.getStatus().ordinal()]) {
                            case 1: {
                                this.$listener$inlined.onCompleted(this.$it);
                                break;
                            }
                            case 2: {
                                this.$listener$inlined.onError(this.$it, this.$it.getError(), null);
                                break;
                            }
                            case 3: {
                                this.$listener$inlined.onCancelled(this.$it);
                                break;
                            }
                            case 4: {
                                this.$listener$inlined.onDeleted(this.$it);
                                break;
                            }
                            case 5: {
                                this.$listener$inlined.onPaused(this.$it);
                                break;
                            }
                            case 6: {
                                this.$listener$inlined.onQueued(this.$it, false);
                                break;
                            }
                            case 7: {
                                this.$listener$inlined.onRemoved(this.$it);
                                break;
                            }
                            case 8: {
                                break;
                            }
                            case 9: {
                                this.$listener$inlined.onAdded(this.$it);
                            }
                        }
                    }
                });
            }
        }
        this.logger.d("Added listener " + listener);
        if (autoStart) {
            this.startPriorityQueueIfNotStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(@NotNull FetchListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Set<FetchListener> set = this.listenerSet;
        synchronized (set) {
            Iterator<FetchListener> iterator = this.listenerSet.iterator();
            while (iterator.hasNext()) {
                FetchListener fetchListener = iterator.next();
                if (!Intrinsics.areEqual((Object)fetchListener, (Object)listener)) continue;
                iterator.remove();
                this.logger.d("Removed listener " + listener);
                break;
            }
            this.listenerCoordinator.removeListener(this.listenerId, listener);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<FetchListener> getListenerSet() {
        Set set;
        Set<FetchListener> set2 = this.listenerSet;
        synchronized (set2) {
            set = CollectionsKt.toSet((Iterable)this.listenerSet);
        }
        return set;
    }

    @Override
    public boolean hasActiveDownloads() {
        Thread thread = Thread.currentThread();
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"Looper.getMainLooper()");
        if (Intrinsics.areEqual((Object)thread, (Object)looper.getThread())) {
            throw (Throwable)new FetchException("blocking_call_on_ui_thread");
        }
        return this.databaseManager.getPendingCount() > 0L;
    }

    @Override
    public long getPendingCount() {
        return this.databaseManager.getPendingCount();
    }

    private final void cancelDownloadsIfDownloading(List<DownloadInfo> downloads) {
        for (DownloadInfo download : downloads) {
            if (!this.downloadManager.contains(download.getId())) continue;
            this.downloadManager.cancel(download.getId());
        }
    }

    private final void startPriorityQueueIfNotStarted() {
        this.priorityListProcessor.sendBackOffResetSignal();
        if (this.priorityListProcessor.isStopped() && !this.isTerminating) {
            this.priorityListProcessor.start();
        }
        if (this.priorityListProcessor.isPaused() && !this.isTerminating) {
            this.priorityListProcessor.resume();
        }
    }

    public FetchHandlerImpl(@NotNull String namespace, @NotNull DatabaseManager databaseManager, @NotNull DownloadManager downloadManager, @NotNull PriorityListProcessor<? extends Download> priorityListProcessor, @NotNull Logger logger, boolean autoStart, @NotNull Downloader<?, ?> httpDownloader, @NotNull FileServerDownloader fileServerDownloader, @NotNull ListenerCoordinator listenerCoordinator, @NotNull Handler uiHandler, @NotNull StorageResolver storageResolver, @Nullable FetchNotificationManager fetchNotificationManager) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
        Intrinsics.checkParameterIsNotNull((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkParameterIsNotNull(priorityListProcessor, (String)"priorityListProcessor");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull(httpDownloader, (String)"httpDownloader");
        Intrinsics.checkParameterIsNotNull((Object)fileServerDownloader, (String)"fileServerDownloader");
        Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkParameterIsNotNull((Object)storageResolver, (String)"storageResolver");
        this.namespace = namespace;
        this.databaseManager = databaseManager;
        this.downloadManager = downloadManager;
        this.priorityListProcessor = priorityListProcessor;
        this.logger = logger;
        this.autoStart = autoStart;
        this.httpDownloader = httpDownloader;
        this.fileServerDownloader = fileServerDownloader;
        this.listenerCoordinator = listenerCoordinator;
        this.uiHandler = uiHandler;
        this.storageResolver = storageResolver;
        this.fetchNotificationManager = fetchNotificationManager;
        this.listenerId = UUID.randomUUID().hashCode();
        FetchHandlerImpl fetchHandlerImpl = this;
        fetchHandlerImpl.listenerSet = set = (Set)new LinkedHashSet();
    }
}

