/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.downloader.DownloadManagerCoordinator;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.ParallelFileDownloaderImpl;
import com.tonyodev.fetch2.downloader.SequentialFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.StorageResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\r\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\b\u00101\u001a\u00020\rH\u0016J\u0010\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\u0005H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000205H\u0002J\u0010\u00107\u001a\u00020\r2\u0006\u00103\u001a\u00020\u0005H\u0002J\b\u00108\u001a\u000205H\u0016J\u0010\u00109\u001a\u00020\r2\u0006\u00103\u001a\u00020\u0005H\u0016J\b\u0010:\u001a\u00020\u0005H\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<H\u0016J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050<H\u0016J\u0010\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020=H\u0016J \u0010A\u001a\u00020(2\u0006\u0010@\u001a\u00020=2\u000e\u0010B\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0002J\b\u0010C\u001a\u00020DH\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010,2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010F\u001a\u00020(2\u0006\u0010@\u001a\u00020=H\u0016J\u0010\u0010G\u001a\u0002052\u0006\u0010@\u001a\u00020=H\u0002J\u0010\u0010H\u001a\u00020\r2\u0006\u0010@\u001a\u00020=H\u0016J\b\u0010I\u001a\u000205H\u0002J\b\u0010J\u001a\u000205H\u0002R\u000e\u0010 \u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010&\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010(0'j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010(`)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/tonyodev/fetch2/downloader/DownloadManagerImpl;", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "concurrentLimit", "", "progressReportingIntervalMillis", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "downloadManagerCoordinator", "Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "hashCheckingEnabled", "uiHandler", "Landroid/os/Handler;", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "context", "Landroid/content/Context;", "namespace", "", "(Lcom/tonyodev/fetch2core/Downloader;IJLcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZLcom/tonyodev/fetch2/helper/DownloadInfoUpdater;Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Lcom/tonyodev/fetch2core/FileServerDownloader;ZLandroid/os/Handler;Lcom/tonyodev/fetch2core/StorageResolver;Landroid/content/Context;Ljava/lang/String;)V", "closed", "value", "getConcurrentLimit", "()I", "setConcurrentLimit", "(I)V", "currentDownloadsMap", "Ljava/util/HashMap;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "Lkotlin/collections/HashMap;", "downloadCounter", "executor", "Ljava/util/concurrent/ExecutorService;", "isClosed", "()Z", "lock", "", "canAccommodateNewDownload", "cancel", "downloadId", "cancelAll", "", "cancelAllDownloads", "cancelDownloadNoLock", "close", "contains", "getActiveDownloadCount", "getActiveDownloads", "", "Lcom/tonyodev/fetch2/Download;", "getActiveDownloadsIds", "getDownloadFileTempDir", "download", "getFileDownloader", "downloader", "getFileDownloaderDelegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getNewDownloadExecutorService", "getNewFileDownloaderForDownload", "removeDownloadMappings", "start", "terminateAllDownloads", "throwExceptionIfClosed", "fetch2_release"})
public final class DownloadManagerImpl
implements DownloadManager {
    private final Object lock;
    private ExecutorService executor;
    private volatile int concurrentLimit;
    private final HashMap<Integer, FileDownloader> currentDownloadsMap;
    private volatile int downloadCounter;
    private volatile boolean closed;
    private final Downloader<?, ?> httpDownloader;
    private final long progressReportingIntervalMillis;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    private final DownloadInfoUpdater downloadInfoUpdater;
    private final DownloadManagerCoordinator downloadManagerCoordinator;
    private final ListenerCoordinator listenerCoordinator;
    private final FileServerDownloader fileServerDownloader;
    private final boolean hashCheckingEnabled;
    private final Handler uiHandler;
    private final StorageResolver storageResolver;
    private final Context context;
    private final String namespace;

    @Override
    public int getConcurrentLimit() {
        return this.concurrentLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConcurrentLimit(int value) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Iterable $receiver$iv = this.getActiveDownloadsIds();
                for (Object element$iv : $receiver$iv) {
                    int id = ((Number)element$iv).intValue();
                    this.cancelDownloadNoLock(id);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ExecutorService executorService = this.executor;
                if (executorService != null) {
                    executorService.shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.executor = this.getNewDownloadExecutorService(value);
            this.concurrentLimit = value;
            this.logger.d("DownloadManager concurrentLimit changed from " + this.concurrentLimit + " to " + value);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Object object = this.lock;
        synchronized (object) {
            block8: {
                block7: {
                    block6: {
                        this.throwExceptionIfClosed();
                        if (!this.currentDownloadsMap.containsKey(download.getId())) break block6;
                        this.logger.d("DownloadManager already running download " + download);
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (this.downloadCounter < this.getConcurrentLimit()) break block7;
                    this.logger.d("DownloadManager cannot init download " + download + " because " + "the download queue is full");
                    boolean bl3 = false;
                    return bl3;
                }
                ++this.downloadCounter;
                Map map = this.currentDownloadsMap;
                Integer n = download.getId();
                Object v = null;
                map.put(n, v);
                this.downloadManagerCoordinator.addFileDownloader(download.getId(), null);
                ExecutorService downloadExecutor = this.executor;
                if (downloadExecutor == null || downloadExecutor.isShutdown()) break block8;
                downloadExecutor.execute(new Runnable(this, download){
                    final /* synthetic */ DownloadManagerImpl this$0;
                    final /* synthetic */ Download $download$inlined;
                    {
                        this.this$0 = downloadManagerImpl;
                        this.$download$inlined = download;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        try {
                            Thread thread = Thread.currentThread();
                            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                            thread.setName(this.$download$inlined.getNamespace() + '-' + this.$download$inlined.getId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            boolean bl;
                            FileDownloader fileDownloader = this.this$0.getNewFileDownloaderForDownload(this.$download$inlined);
                            Object object = DownloadManagerImpl.access$getLock$p(this.this$0);
                            synchronized (object) {
                                boolean bl2;
                                if (DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0).containsKey(this.$download$inlined.getId())) {
                                    fileDownloader.setDelegate(this.this$0.getFileDownloaderDelegate());
                                    Map map = DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0);
                                    Integer n = this.$download$inlined.getId();
                                    FileDownloader fileDownloader2 = fileDownloader;
                                    map.put(n, fileDownloader2);
                                    DownloadManagerImpl.access$getDownloadManagerCoordinator$p(this.this$0).addFileDownloader(this.$download$inlined.getId(), fileDownloader);
                                    DownloadManagerImpl.access$getLogger$p(this.this$0).d("DownloadManager starting download " + this.$download$inlined);
                                    bl2 = true;
                                } else {
                                    bl2 = false;
                                }
                                bl = bl2;
                            }
                            boolean runDownload = bl;
                            if (runDownload) {
                                fileDownloader.run();
                            }
                            DownloadManagerImpl.access$removeDownloadMappings(this.this$0, this.$download$inlined);
                        }
                        catch (Exception intent) {
                        }
                        finally {
                            DownloadManagerImpl.access$removeDownloadMappings(this.this$0, this.$download$inlined);
                            Intent intent = new Intent("com.tonyodev.fetch2.action.QUEUE_BACKOFF_RESET");
                            intent.putExtra("com.tonyodev.fetch2.extra.NAMESPACE", DownloadManagerImpl.access$getNamespace$p(this.this$0));
                            DownloadManagerImpl.access$getContext$p(this.this$0).sendBroadcast(intent);
                        }
                    }
                });
                boolean bl4 = true;
                return bl4;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDownloadMappings(Download download) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentDownloadsMap.containsKey(download.getId())) {
                this.currentDownloadsMap.remove(download.getId());
                --this.downloadCounter;
            }
            this.downloadManagerCoordinator.removeFileDownloader(download.getId());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(int downloadId) {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            bl = this.cancelDownloadNoLock(downloadId);
        }
        return bl;
    }

    private final boolean cancelDownloadNoLock(int downloadId) {
        boolean bl;
        this.throwExceptionIfClosed();
        if (this.currentDownloadsMap.containsKey(downloadId)) {
            FileDownloader fileDownloader;
            FileDownloader fileDownloader2 = fileDownloader = this.currentDownloadsMap.get(downloadId);
            if (fileDownloader2 != null) {
                fileDownloader2.setInterrupted(true);
            }
            this.currentDownloadsMap.remove(downloadId);
            --this.downloadCounter;
            this.downloadManagerCoordinator.removeFileDownloader(downloadId);
            if (fileDownloader != null) {
                this.logger.d("DownloadManager cancelled download " + fileDownloader.getDownload());
            }
            bl = true;
        } else {
            this.downloadManagerCoordinator.interruptDownload(downloadId);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.cancelAllDownloads();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cancelAllDownloads() {
        if (this.getConcurrentLimit() > 0) {
            Iterator<FileDownloader> iterator;
            Iterator<FileDownloader> $receiver$iv = this.downloadManagerCoordinator.getFileDownloaderList().iterator();
            Iterator<FileDownloader> iterator2 = iterator = $receiver$iv;
            while (iterator2.hasNext()) {
                FileDownloader element$iv = iterator2.next();
                FileDownloader it = element$iv;
                FileDownloader fileDownloader = it;
                if (fileDownloader == null) continue;
                fileDownloader.setInterrupted(true);
                this.downloadManagerCoordinator.removeFileDownloader(fileDownloader.getDownload().getId());
                this.logger.d("DownloadManager cancelled download " + fileDownloader.getDownload());
            }
        }
        this.currentDownloadsMap.clear();
        this.downloadCounter = 0;
    }

    private final void terminateAllDownloads() {
        Iterator iterator;
        Map map = this.currentDownloadsMap;
        Iterator $receiver$iv = map.entrySet().iterator();
        Iterator iterator2 = iterator = $receiver$iv;
        while (iterator2.hasNext()) {
            Map.Entry element$iv = iterator2.next();
            Map.Entry it = element$iv;
            FileDownloader fileDownloader = (FileDownloader)it.getValue();
            if (fileDownloader == null) continue;
            fileDownloader.setTerminated(true);
            this.logger.d("DownloadManager terminated download " + fileDownloader.getDownload());
            this.downloadManagerCoordinator.removeFileDownloader(((Number)it.getKey()).intValue());
        }
        this.currentDownloadsMap.clear();
        this.downloadCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.getConcurrentLimit() > 0) {
                this.terminateAllDownloads();
            }
            this.logger.d("DownloadManager closing download manager");
            try {
                Unit unit2;
                ExecutorService executorService = this.executor;
                if (executorService != null) {
                    executorService.shutdown();
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                unit = unit2;
            }
            catch (Exception e) {
                unit = Unit.INSTANCE;
            }
            Unit unit3 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int downloadId) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = !this.isClosed() && this.downloadManagerCoordinator.containsFileDownloader(downloadId);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAccommodateNewDownload() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = !this.closed && this.downloadCounter < this.getConcurrentLimit();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveDownloadCount() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            int n = this.downloadCounter;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> getActiveDownloads() {
        Object object = this.lock;
        synchronized (object) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            this.throwExceptionIfClosed();
            Collection<FileDownloader> collection = this.currentDownloadsMap.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"currentDownloadsMap.values");
            Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.filterNotNull((Iterable)collection);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                FileDownloader fileDownloader = (FileDownloader)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                Download download = it.getDownload();
                collection2.add(download);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Integer> getActiveDownloadsIds() {
        Object object = this.lock;
        synchronized (object) {
            Map.Entry it;
            Map $receiver$iv$iv;
            Map $receiver$iv;
            this.throwExceptionIfClosed();
            Map map = $receiver$iv = (Map)this.currentDownloadsMap;
            Object destination$iv$iv = new LinkedHashMap();
            Map map2 = $receiver$iv$iv;
            for (Map.Entry element$iv$iv : map2.entrySet()) {
                it = element$iv$iv;
                if (!(it.getValue() != null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $receiver$iv = destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList($receiver$iv.size());
            map2 = $receiver$iv$iv;
            for (Map.Entry item$iv$iv : map2.entrySet()) {
                it = item$iv$iv;
                Object object2 = destination$iv$iv;
                Integer n = ((Number)it.getKey()).intValue();
                object2.add(n);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    private final void throwExceptionIfClosed() {
        if (this.closed) {
            throw (Throwable)new FetchException("DownloadManager is already shutdown.");
        }
    }

    @Override
    @NotNull
    public FileDownloader getNewFileDownloaderForDownload(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        return !FetchCoreUtils.isFetchFileServerUrl((String)download.getUrl()) ? this.getFileDownloader(download, this.httpDownloader) : this.getFileDownloader(download, (Downloader)this.fileServerDownloader);
    }

    private final FileDownloader getFileDownloader(Download download, Downloader<?, ?> downloader) {
        Set supportedDownloadTypes;
        Downloader.ServerRequest request = FetchUtils.getRequestForDownload$default(download, null, 2, null);
        return downloader.getRequestFileDownloaderType(request, supportedDownloadTypes = downloader.getRequestSupportedFileDownloaderTypes(request)) == Downloader.FileDownloaderType.SEQUENTIAL ? (FileDownloader)new SequentialFileDownloaderImpl(download, downloader, this.progressReportingIntervalMillis, this.logger, this.networkInfoProvider, this.retryOnNetworkGain, this.hashCheckingEnabled, this.storageResolver) : (FileDownloader)new ParallelFileDownloaderImpl(download, downloader, this.progressReportingIntervalMillis, this.logger, this.networkInfoProvider, this.retryOnNetworkGain, this.storageResolver.getDirectoryForFileDownloaderTypeParallel(request), this.hashCheckingEnabled, this.storageResolver);
    }

    @Override
    @NotNull
    public FileDownloader.Delegate getFileDownloaderDelegate() {
        return new FileDownloaderDelegate(this.downloadInfoUpdater, this.listenerCoordinator.getMainListener(), this.uiHandler, this.retryOnNetworkGain);
    }

    @Override
    @NotNull
    public String getDownloadFileTempDir(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Downloader.ServerRequest request = FetchUtils.getRequestForDownload$default(download, null, 2, null);
        return this.storageResolver.getDirectoryForFileDownloaderTypeParallel(request);
    }

    private final ExecutorService getNewDownloadExecutorService(int concurrentLimit) {
        return concurrentLimit > 0 ? Executors.newFixedThreadPool(concurrentLimit) : null;
    }

    public DownloadManagerImpl(@NotNull Downloader<?, ?> httpDownloader, int concurrentLimit, long progressReportingIntervalMillis, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, @NotNull DownloadInfoUpdater downloadInfoUpdater, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator, @NotNull FileServerDownloader fileServerDownloader, boolean hashCheckingEnabled, @NotNull Handler uiHandler, @NotNull StorageResolver storageResolver, @NotNull Context context, @NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull(httpDownloader, (String)"httpDownloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)downloadInfoUpdater, (String)"downloadInfoUpdater");
        Intrinsics.checkParameterIsNotNull((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)fileServerDownloader, (String)"fileServerDownloader");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkParameterIsNotNull((Object)storageResolver, (String)"storageResolver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        this.httpDownloader = httpDownloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.downloadInfoUpdater = downloadInfoUpdater;
        this.downloadManagerCoordinator = downloadManagerCoordinator;
        this.listenerCoordinator = listenerCoordinator;
        this.fileServerDownloader = fileServerDownloader;
        this.hashCheckingEnabled = hashCheckingEnabled;
        this.uiHandler = uiHandler;
        this.storageResolver = storageResolver;
        this.context = context;
        this.namespace = namespace;
        this.lock = new Object();
        this.executor = this.getNewDownloadExecutorService(concurrentLimit);
        this.concurrentLimit = concurrentLimit;
        DownloadManagerImpl downloadManagerImpl = this;
        HashMap hashMap = new HashMap();
        downloadManagerImpl.currentDownloadsMap = hashMap;
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(DownloadManagerImpl $this) {
        return $this.lock;
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getCurrentDownloadsMap$p(DownloadManagerImpl $this) {
        return $this.currentDownloadsMap;
    }

    @NotNull
    public static final /* synthetic */ DownloadManagerCoordinator access$getDownloadManagerCoordinator$p(DownloadManagerImpl $this) {
        return $this.downloadManagerCoordinator;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(DownloadManagerImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$removeDownloadMappings(DownloadManagerImpl $this, @NotNull Download download) {
        $this.removeDownloadMappings(download);
    }

    @NotNull
    public static final /* synthetic */ String access$getNamespace$p(DownloadManagerImpl $this) {
        return $this.namespace;
    }

    @NotNull
    public static final /* synthetic */ Context access$getContext$p(DownloadManagerImpl $this) {
        return $this.context;
    }
}

