/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2;

import android.content.Context;
import com.tonyodev.fetch2.Fetch;
import com.tonyodev.fetch2.FetchNotificationManager;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2core.DefaultStorageResolver;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FetchLogger;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.StorageResolver;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001=B\u0089\u0001\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u000b\u0012\u0006\u0010\u0013\u001a\u00020\u000b\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u000b\u0012\u0006\u0010\u0017\u001a\u00020\u000b\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0013\u00107\u001a\u00020\u000b2\b\u00108\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u00109\u001a\u00020:J\b\u0010;\u001a\u00020\u0007H\u0016J\b\u0010<\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0017\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010 R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010 R\u0019\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010 R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006>"}, d2={"Lcom/tonyodev/fetch2/FetchConfiguration;", "", "appContext", "Landroid/content/Context;", "namespace", "", "concurrentLimit", "", "progressReportingIntervalMillis", "", "loggingEnabled", "", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "globalNetworkType", "Lcom/tonyodev/fetch2/NetworkType;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "autoStart", "retryOnNetworkGain", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "hashCheckingEnabled", "fileExistChecksEnabled", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "fetchNotificationManager", "Lcom/tonyodev/fetch2/FetchNotificationManager;", "(Landroid/content/Context;Ljava/lang/String;IJZLcom/tonyodev/fetch2core/Downloader;Lcom/tonyodev/fetch2/NetworkType;Lcom/tonyodev/fetch2core/Logger;ZZLcom/tonyodev/fetch2core/FileServerDownloader;ZZLcom/tonyodev/fetch2core/StorageResolver;Lcom/tonyodev/fetch2/FetchNotificationManager;)V", "getAppContext", "()Landroid/content/Context;", "getAutoStart", "()Z", "getConcurrentLimit", "()I", "getFetchNotificationManager", "()Lcom/tonyodev/fetch2/FetchNotificationManager;", "getFileExistChecksEnabled", "getFileServerDownloader", "()Lcom/tonyodev/fetch2core/FileServerDownloader;", "getGlobalNetworkType", "()Lcom/tonyodev/fetch2/NetworkType;", "getHashCheckingEnabled", "getHttpDownloader", "()Lcom/tonyodev/fetch2core/Downloader;", "getLogger", "()Lcom/tonyodev/fetch2core/Logger;", "getLoggingEnabled", "getNamespace", "()Ljava/lang/String;", "getProgressReportingIntervalMillis", "()J", "getRetryOnNetworkGain", "getStorageResolver", "()Lcom/tonyodev/fetch2core/StorageResolver;", "equals", "other", "getNewFetchInstanceFromConfiguration", "Lcom/tonyodev/fetch2/Fetch;", "hashCode", "toString", "Builder", "fetch2_release"})
public final class FetchConfiguration {
    @NotNull
    private final Context appContext;
    @NotNull
    private final String namespace;
    private final int concurrentLimit;
    private final long progressReportingIntervalMillis;
    private final boolean loggingEnabled;
    @NotNull
    private final Downloader<?, ?> httpDownloader;
    @NotNull
    private final NetworkType globalNetworkType;
    @NotNull
    private final Logger logger;
    private final boolean autoStart;
    private final boolean retryOnNetworkGain;
    @NotNull
    private final FileServerDownloader fileServerDownloader;
    private final boolean hashCheckingEnabled;
    private final boolean fileExistChecksEnabled;
    @NotNull
    private final StorageResolver storageResolver;
    @Nullable
    private final FetchNotificationManager fetchNotificationManager;

    @NotNull
    public final Fetch getNewFetchInstanceFromConfiguration() {
        return Fetch.Impl.getInstance(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.tonyodev.fetch2.FetchConfiguration");
        }
        FetchConfiguration cfr_ignored_0 = (FetchConfiguration)object2;
        if (Intrinsics.areEqual((Object)this.appContext, (Object)((FetchConfiguration)other).appContext) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.namespace, (Object)((FetchConfiguration)other).namespace) ^ true) {
            return false;
        }
        if (this.concurrentLimit != ((FetchConfiguration)other).concurrentLimit) {
            return false;
        }
        if (this.progressReportingIntervalMillis != ((FetchConfiguration)other).progressReportingIntervalMillis) {
            return false;
        }
        if (this.loggingEnabled != ((FetchConfiguration)other).loggingEnabled) {
            return false;
        }
        if (Intrinsics.areEqual(this.httpDownloader, ((FetchConfiguration)other).httpDownloader) ^ true) {
            return false;
        }
        if (this.globalNetworkType != ((FetchConfiguration)other).globalNetworkType) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.logger, (Object)((FetchConfiguration)other).logger) ^ true) {
            return false;
        }
        if (this.autoStart != ((FetchConfiguration)other).autoStart) {
            return false;
        }
        if (this.retryOnNetworkGain != ((FetchConfiguration)other).retryOnNetworkGain) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.fileServerDownloader, (Object)((FetchConfiguration)other).fileServerDownloader) ^ true) {
            return false;
        }
        if (this.hashCheckingEnabled != ((FetchConfiguration)other).hashCheckingEnabled) {
            return false;
        }
        if (this.fileExistChecksEnabled != ((FetchConfiguration)other).fileExistChecksEnabled) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.storageResolver, (Object)((FetchConfiguration)other).storageResolver) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.fetchNotificationManager, (Object)((FetchConfiguration)other).fetchNotificationManager) ^ true);
    }

    public int hashCode() {
        int result = this.appContext.hashCode();
        result = 31 * result + this.namespace.hashCode();
        result = 31 * result + this.concurrentLimit;
        result = 31 * result + ((Object)this.progressReportingIntervalMillis).hashCode();
        result = 31 * result + ((Object)this.loggingEnabled).hashCode();
        result = 31 * result + this.httpDownloader.hashCode();
        result = 31 * result + this.globalNetworkType.hashCode();
        result = 31 * result + this.logger.hashCode();
        result = 31 * result + ((Object)this.autoStart).hashCode();
        result = 31 * result + ((Object)this.retryOnNetworkGain).hashCode();
        result = 31 * result + this.fileServerDownloader.hashCode();
        result = 31 * result + ((Object)this.hashCheckingEnabled).hashCode();
        result = 31 * result + ((Object)this.fileExistChecksEnabled).hashCode();
        result = 31 * result + this.storageResolver.hashCode();
        if (this.fetchNotificationManager != null) {
            result = 31 * result + this.fetchNotificationManager.hashCode();
        }
        return result;
    }

    @NotNull
    public String toString() {
        return "FetchConfiguration(appContext=" + this.appContext + ", namespace='" + this.namespace + "'," + " concurrentLimit=" + this.concurrentLimit + ", progressReportingIntervalMillis=" + this.progressReportingIntervalMillis + ", " + "loggingEnabled=" + this.loggingEnabled + ", httpDownloader=" + this.httpDownloader + ", " + "globalNetworkType=" + (Object)((Object)this.globalNetworkType) + ", logger=" + this.logger + ", " + "autoStart=" + this.autoStart + ", retryOnNetworkGain=" + this.retryOnNetworkGain + ", " + "fileServerDownloader=" + this.fileServerDownloader + ", hashCheckingEnabled=" + this.hashCheckingEnabled + ", " + "fileExistChecksEnabled=" + this.fileExistChecksEnabled + ", storageResolver=" + this.storageResolver + ", " + "fetchNotificationManager=" + this.fetchNotificationManager + ')';
    }

    @NotNull
    public final Context getAppContext() {
        return this.appContext;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    public final int getConcurrentLimit() {
        return this.concurrentLimit;
    }

    public final long getProgressReportingIntervalMillis() {
        return this.progressReportingIntervalMillis;
    }

    public final boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    @NotNull
    public final Downloader<?, ?> getHttpDownloader() {
        return this.httpDownloader;
    }

    @NotNull
    public final NetworkType getGlobalNetworkType() {
        return this.globalNetworkType;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final boolean getAutoStart() {
        return this.autoStart;
    }

    public final boolean getRetryOnNetworkGain() {
        return this.retryOnNetworkGain;
    }

    @NotNull
    public final FileServerDownloader getFileServerDownloader() {
        return this.fileServerDownloader;
    }

    public final boolean getHashCheckingEnabled() {
        return this.hashCheckingEnabled;
    }

    public final boolean getFileExistChecksEnabled() {
        return this.fileExistChecksEnabled;
    }

    @NotNull
    public final StorageResolver getStorageResolver() {
        return this.storageResolver;
    }

    @Nullable
    public final FetchNotificationManager getFetchNotificationManager() {
        return this.fetchNotificationManager;
    }

    private FetchConfiguration(Context appContext, String namespace, int concurrentLimit, long progressReportingIntervalMillis, boolean loggingEnabled, Downloader<?, ?> httpDownloader, NetworkType globalNetworkType, Logger logger, boolean autoStart, boolean retryOnNetworkGain, FileServerDownloader fileServerDownloader, boolean hashCheckingEnabled, boolean fileExistChecksEnabled, StorageResolver storageResolver, FetchNotificationManager fetchNotificationManager) {
        this.appContext = appContext;
        this.namespace = namespace;
        this.concurrentLimit = concurrentLimit;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.loggingEnabled = loggingEnabled;
        this.httpDownloader = httpDownloader;
        this.globalNetworkType = globalNetworkType;
        this.logger = logger;
        this.autoStart = autoStart;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.fileServerDownloader = fileServerDownloader;
        this.hashCheckingEnabled = hashCheckingEnabled;
        this.fileExistChecksEnabled = fileExistChecksEnabled;
        this.storageResolver = storageResolver;
        this.fetchNotificationManager = fetchNotificationManager;
    }

    public /* synthetic */ FetchConfiguration(@NotNull Context appContext, @NotNull String namespace, int concurrentLimit, long progressReportingIntervalMillis, boolean loggingEnabled, @NotNull Downloader httpDownloader, @NotNull NetworkType globalNetworkType, @NotNull Logger logger, boolean autoStart, boolean retryOnNetworkGain, @NotNull FileServerDownloader fileServerDownloader, boolean hashCheckingEnabled, boolean fileExistChecksEnabled, @NotNull StorageResolver storageResolver, @Nullable FetchNotificationManager fetchNotificationManager, DefaultConstructorMarker $constructor_marker) {
        this(appContext, namespace, concurrentLimit, progressReportingIntervalMillis, loggingEnabled, httpDownloader, globalNetworkType, logger, autoStart, retryOnNetworkGain, fileServerDownloader, hashCheckingEnabled, fileExistChecksEnabled, storageResolver, fetchNotificationManager);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\bJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\bJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\bJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\bJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\bJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\nJ\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0011J\u0016\u0010,\u001a\u00020\u00002\u000e\u0010-\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010/\u001a\u00020\u00002\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u00100\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u000e\u00101\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eR\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/tonyodev/fetch2/FetchConfiguration$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "appContext", "kotlin.jvm.PlatformType", "autoStart", "", "concurrentLimit", "", "fetchNotificationManager", "Lcom/tonyodev/fetch2/FetchNotificationManager;", "fileExistChecksEnabled", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "globalNetworkType", "Lcom/tonyodev/fetch2/NetworkType;", "hashCheckEnabled", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "loggingEnabled", "namespace", "", "progressReportingIntervalMillis", "", "retryOnNetworkGain", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "build", "Lcom/tonyodev/fetch2/FetchConfiguration;", "enableAutoStart", "enabled", "enableFileExistChecks", "enableHashCheck", "enableLogging", "enableRetryOnNetworkGain", "setDownloadConcurrentLimit", "downloadConcurrentLimit", "setFileServerDownloader", "setGlobalNetworkType", "networkType", "setHttpDownloader", "downloader", "setLogger", "setNamespace", "setNotificationManager", "setProgressReportingInterval", "setStorageResolver", "fetch2_release"})
    public static final class Builder {
        private final Context appContext;
        private String namespace;
        private int concurrentLimit;
        private long progressReportingIntervalMillis;
        private boolean loggingEnabled;
        private Downloader<?, ?> httpDownloader;
        private NetworkType globalNetworkType;
        private Logger logger;
        private boolean autoStart;
        private boolean retryOnNetworkGain;
        private FileServerDownloader fileServerDownloader;
        private boolean hashCheckEnabled;
        private boolean fileExistChecksEnabled;
        private StorageResolver storageResolver;
        private FetchNotificationManager fetchNotificationManager;

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Builder setNamespace(@Nullable String namespace) {
            v0 = this;
            if (namespace == null) ** GOTO lbl-1000
            var2_2 = namespace;
            var3_3 = v0;
            var4_4 = var2_2.length() == 0;
            v0 = var3_3;
            if (var4_4) lbl-1000:
            // 2 sources

            {
                v1 = "LibGlobalFetchLib";
            } else {
                v1 = namespace;
            }
            v0.namespace = v1;
            return this;
        }

        @NotNull
        public static /* synthetic */ Builder setNamespace$default(Builder builder, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            return builder.setNamespace(string2);
        }

        @NotNull
        public final Builder setHttpDownloader(@NotNull Downloader<?, ?> downloader) {
            Intrinsics.checkParameterIsNotNull(downloader, (String)"downloader");
            this.httpDownloader = downloader;
            return this;
        }

        @NotNull
        public final Builder setFileServerDownloader(@NotNull FileServerDownloader fileServerDownloader) {
            Intrinsics.checkParameterIsNotNull((Object)fileServerDownloader, (String)"fileServerDownloader");
            this.fileServerDownloader = fileServerDownloader;
            return this;
        }

        @NotNull
        public final Builder setProgressReportingInterval(long progressReportingIntervalMillis) {
            if (progressReportingIntervalMillis < 0L) {
                throw (Throwable)new FetchException("progressReportingIntervalMillis cannot be less than 0");
            }
            this.progressReportingIntervalMillis = progressReportingIntervalMillis;
            return this;
        }

        @NotNull
        public final Builder setDownloadConcurrentLimit(int downloadConcurrentLimit) {
            if (downloadConcurrentLimit < 0) {
                throw (Throwable)new FetchException("Concurrent limit cannot be less than 0");
            }
            this.concurrentLimit = downloadConcurrentLimit;
            return this;
        }

        @NotNull
        public final Builder setGlobalNetworkType(@NotNull NetworkType networkType) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"networkType");
            this.globalNetworkType = networkType;
            return this;
        }

        @NotNull
        public final Builder enableLogging(boolean enabled) {
            this.loggingEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setLogger(@NotNull Logger logger) {
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            this.logger = logger;
            return this;
        }

        @NotNull
        public final Builder enableAutoStart(boolean enabled) {
            this.autoStart = enabled;
            return this;
        }

        @NotNull
        public final Builder enableRetryOnNetworkGain(boolean enabled) {
            this.retryOnNetworkGain = enabled;
            return this;
        }

        @NotNull
        public final Builder enableHashCheck(boolean enabled) {
            this.hashCheckEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder enableFileExistChecks(boolean enabled) {
            this.fileExistChecksEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setStorageResolver(@NotNull StorageResolver storageResolver) {
            Intrinsics.checkParameterIsNotNull((Object)storageResolver, (String)"storageResolver");
            this.storageResolver = storageResolver;
            return this;
        }

        @NotNull
        public final Builder setNotificationManager(@Nullable FetchNotificationManager fetchNotificationManager) {
            this.fetchNotificationManager = fetchNotificationManager;
            return this;
        }

        @NotNull
        public final FetchConfiguration build() {
            Logger prefsLogger = this.logger;
            if (prefsLogger instanceof FetchLogger) {
                prefsLogger.setEnabled(this.loggingEnabled);
                if (Intrinsics.areEqual((Object)((FetchLogger)prefsLogger).getTag(), (Object)"fetch2")) {
                    ((FetchLogger)prefsLogger).setTag(this.namespace);
                }
            } else {
                this.logger.setEnabled(this.loggingEnabled);
            }
            Context context = this.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"appContext");
            return new FetchConfiguration(context, this.namespace, this.concurrentLimit, this.progressReportingIntervalMillis, this.loggingEnabled, this.httpDownloader, this.globalNetworkType, prefsLogger, this.autoStart, this.retryOnNetworkGain, this.fileServerDownloader, this.hashCheckEnabled, this.fileExistChecksEnabled, this.storageResolver, this.fetchNotificationManager, null);
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.appContext = context.getApplicationContext();
            this.namespace = "LibGlobalFetchLib";
            this.concurrentLimit = 1;
            this.progressReportingIntervalMillis = 2000L;
            this.loggingEnabled = true;
            this.httpDownloader = FetchDefaults.getDefaultDownloader();
            this.globalNetworkType = FetchDefaults.getDefaultGlobalNetworkType();
            this.logger = (Logger)new FetchLogger(true, "fetch2");
            this.autoStart = true;
            this.retryOnNetworkGain = true;
            this.fileServerDownloader = FetchDefaults.getDefaultFileServerDownloader();
            this.fileExistChecksEnabled = true;
            Context context2 = this.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"appContext");
            Context context3 = this.appContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"appContext");
            this.storageResolver = (StorageResolver)new DefaultStorageResolver(context2, FetchCoreUtils.getFileTempDir((Context)context3));
        }
    }
}

