/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.ParallelFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.AverageCalculator;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.DownloadBlockInfo;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileSlice;
import com.tonyodev.fetch2core.FileSliceInfo;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.OutputResourceWrapper;
import com.tonyodev.fetch2core.StorageResolver;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00af\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001/\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002J\b\u0010I\u001a\u00020\u0007H\u0002J\u0010\u0010J\u001a\u00020K2\u0006\u0010F\u001a\u00020GH\u0002J\u001e\u0010L\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010M\u001a\u00020\r2\u0006\u0010F\u001a\u00020GH\u0002J\b\u0010N\u001a\u00020EH\u0002J\b\u0010O\u001a\u00020\rH\u0002J\b\u0010P\u001a\u00020EH\u0016J\u0010\u0010Q\u001a\u00020E2\u0006\u0010R\u001a\u00020SH\u0002J\b\u0010T\u001a\u00020EH\u0002J\b\u0010U\u001a\u00020EH\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00100R$\u00102\u001a\u00020\r2\u0006\u00101\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001b\"\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010<\u001a\u00020\r2\u0006\u00101\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u001b\"\u0004\b>\u00105R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "initialDownload", "Lcom/tonyodev/fetch2/Download;", "downloader", "Lcom/tonyodev/fetch2core/Downloader;", "progressReportingIntervalMillis", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "fileTempDir", "", "hashCheckingEnabled", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "(Lcom/tonyodev/fetch2/Download;Lcom/tonyodev/fetch2core/Downloader;JLcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZLjava/lang/String;ZLcom/tonyodev/fetch2core/StorageResolver;)V", "actionsCounter", "", "actionsTotal", "averageDownloadedBytesPerSecond", "", "completedDownload", "getCompletedDownload", "()Z", "delegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;)V", "download", "getDownload", "()Lcom/tonyodev/fetch2/Download;", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "downloaded", "estimatedTimeRemainingInMilliseconds", "executorService", "Ljava/util/concurrent/ExecutorService;", "fileSlices", "", "Lcom/tonyodev/fetch2core/FileSlice;", "interruptMonitor", "com/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1", "Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1;", "value", "interrupted", "getInterrupted", "setInterrupted", "(Z)V", "lock", "Ljava/lang/Object;", "movingAverageCalculator", "Lcom/tonyodev/fetch2core/AverageCalculator;", "outputResourceWrapper", "Lcom/tonyodev/fetch2core/OutputResourceWrapper;", "terminated", "getTerminated", "setTerminated", "throwable", "", "total", "totalDownloadBlocks", "totalUnknown", "downloadSliceFiles", "", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "fileSlicesDownloadsList", "getAverageDownloadedBytesPerSecond", "getChuckInfo", "Lcom/tonyodev/fetch2core/FileSliceInfo;", "getFileSliceList", "acceptsRanges", "incrementActionCompletedCount", "isDownloadComplete", "run", "setIsTotalUnknown", "response", "Lcom/tonyodev/fetch2core/Downloader$Response;", "throwExceptionIfFound", "waitAndPerformProgressReporting", "fetch2_release"})
public final class ParallelFileDownloaderImpl
implements FileDownloader {
    private volatile boolean interrupted;
    private volatile boolean terminated;
    @Nullable
    private FileDownloader.Delegate delegate;
    private final DownloadInfo downloadInfo;
    private volatile long downloaded;
    private volatile long total;
    private volatile boolean totalUnknown;
    private double averageDownloadedBytesPerSecond;
    private final AverageCalculator movingAverageCalculator;
    private long estimatedTimeRemainingInMilliseconds;
    private ExecutorService executorService;
    private volatile int actionsCounter;
    private int actionsTotal;
    private final Object lock;
    private volatile Throwable throwable;
    private List<FileSlice> fileSlices;
    private OutputResourceWrapper outputResourceWrapper;
    private int totalDownloadBlocks;
    private final interruptMonitor.1 interruptMonitor;
    private final Download initialDownload;
    private final Downloader<?, ?> downloader;
    private final long progressReportingIntervalMillis;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    private final String fileTempDir;
    private final boolean hashCheckingEnabled;
    private final StorageResolver storageResolver;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        if (!(delegate instanceof FileDownloaderDelegate)) {
            delegate = null;
        }
        FileDownloaderDelegate fileDownloaderDelegate = (FileDownloaderDelegate)delegate;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.interrupted = value;
    }

    @Override
    public boolean getTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        if (!(delegate instanceof FileDownloaderDelegate)) {
            delegate = null;
        }
        FileDownloaderDelegate fileDownloaderDelegate = (FileDownloaderDelegate)delegate;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.terminated = value;
    }

    @Override
    public boolean getCompletedDownload() {
        return this.isDownloadComplete();
    }

    @Override
    @Nullable
    public FileDownloader.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FileDownloader.Delegate delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Download getDownload() {
        this.downloadInfo.setDownloaded(this.downloaded);
        this.downloadInfo.setTotal(this.total);
        return this.downloadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void run() {
        block88: {
            block85: {
                block86: {
                    block84: {
                        block89: {
                            openingResponse = null;
                            this.downloaded = this.initialDownload.getDownloaded();
                            this.total = this.initialDownload.getTotal();
                            this.downloadInfo.setDownloaded(this.downloaded);
                            this.downloadInfo.setTotal(this.total);
                            openingRequest = this.downloader.getHeadRequestMethodSupported(FetchUtils.getRequestForDownload$default(this.initialDownload, null, 2, null)) != false ? FetchUtils.getRequestForDownload(this.initialDownload, "HEAD") : FetchUtils.getRequestForDownload$default(this.initialDownload, null, 2, null);
                            openingResponse = this.downloader.execute(openingRequest, (InterruptMonitor)this.interruptMonitor);
                            if (openingResponse != null) {
                                this.setIsTotalUnknown(openingResponse);
                            }
                            if (this.getInterrupted() || this.getTerminated()) break block84;
                            v0 = openingResponse;
                            if (v0 == null) break block84;
                            if (!v0.isSuccessful()) break block84;
                            this.total = openingResponse.getContentLength();
                            if (!this.totalUnknown && this.total <= 0L) break block89;
                            this.downloaded = 0L;
                            this.downloadInfo.setDownloaded(this.downloaded);
                            this.downloadInfo.setTotal(this.total);
                            this.fileSlices = this.getFileSliceList(openingResponse.getAcceptsRanges(), openingRequest);
                            this.totalDownloadBlocks = this.fileSlices.size();
                            try {
                                this.downloader.disconnect(openingResponse);
                            }
                            catch (Exception e) {
                                this.logger.e("FileDownloader", (Throwable)e);
                            }
                            var5_19 = $receiver$iv = (Iterable)this.fileSlices;
                            destination$iv$iv = new ArrayList<E>();
                            for (T element$iv$iv : $receiver$iv$iv) {
                                it = (FileSlice)element$iv$iv /* !! */ ;
                                if (!(it.isDownloaded() == false)) continue;
                                destination$iv$iv.add(element$iv$iv /* !! */ );
                            }
                            sliceFileDownloadsList = (List)destination$iv$iv;
                            if (!this.getInterrupted() && !this.getTerminated()) {
                                this.downloadInfo.setDownloaded(this.downloaded);
                                this.downloadInfo.setTotal(this.total);
                                destination$iv$iv = $receiver$iv = (Iterable)this.fileSlices;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                element$iv$iv /* !! */  = $receiver$iv$iv.iterator();
                                while (element$iv$iv /* !! */ .hasNext()) {
                                    item$iv$iv = element$iv$iv /* !! */ .next();
                                    $i$a$1$filter = (FileSlice)item$iv$iv;
                                    var15_29 = destination$iv$iv;
                                    downloadBlock = new DownloadBlockInfo();
                                    downloadBlock.setDownloadId(it.getId());
                                    downloadBlock.setBlockPosition(it.getPosition());
                                    downloadBlock.setDownloadedBytes(it.getDownloaded());
                                    downloadBlock.setStartByte(it.getStartBytes());
                                    downloadBlock.setEndByte(it.getEndBytes());
                                    var16_30 = downloadBlock;
                                    var15_29.add(var16_30);
                                }
                                downloadBlocks = (List)destination$iv$iv;
                                if (!this.getInterrupted() && !this.getTerminated()) {
                                    v1 = this.getDelegate();
                                    if (v1 != null) {
                                        v1.onStarted(this.downloadInfo, downloadBlocks, this.totalDownloadBlocks);
                                        v2 = Unit.INSTANCE;
                                    } else {
                                        v2 = null;
                                    }
                                    $receiver$iv = downloadBlocks;
                                    $receiver$iv$iv = $receiver$iv.iterator();
                                    while ($receiver$iv$iv.hasNext()) {
                                        element$iv = $receiver$iv$iv.next();
                                        downloadBlock = (DownloadBlockInfo)element$iv;
                                        v3 = this.getDelegate();
                                        if (v3 != null) {
                                            v3.onDownloadBlockUpdated(this.downloadInfo, (DownloadBlock)downloadBlock, this.totalDownloadBlocks);
                                            v4 = Unit.INSTANCE;
                                            continue;
                                        }
                                        v4 = null;
                                    }
                                }
                                if (($receiver$iv = (Collection)sliceFileDownloadsList).isEmpty() == false) {
                                    this.executorService = Executors.newFixedThreadPool(sliceFileDownloadsList.size());
                                }
                                this.downloadSliceFiles(openingRequest, sliceFileDownloadsList);
                                this.waitAndPerformProgressReporting();
                                this.downloadInfo.setDownloaded(this.downloaded);
                                this.downloadInfo.setTotal(this.total);
                            }
                            ** GOTO lbl101
                        }
                        throw (Throwable)new FetchException("empty_response_body");
                    }
                    if (!(openingResponse != null || this.getInterrupted() || this.getTerminated() || this.isDownloadComplete())) {
                        throw (Throwable)new FetchException("empty_response_body");
                    }
                    v5 = openingResponse;
                    if (v5 != null) {
                        if (!v5.isSuccessful()) {
                            if (!(this.getInterrupted() || this.getTerminated() || this.isDownloadComplete())) {
                                throw (Throwable)new FetchException("request_not_successful");
                            }
                        }
                    }
                    if (!(this.getInterrupted() || this.getTerminated() || this.isDownloadComplete())) {
                        throw (Throwable)new FetchException("unknown");
                    }
lbl101:
                    // 3 sources

                    this.downloadInfo.setDownloaded(this.downloaded);
                    this.downloadInfo.setTotal(this.total);
                    this.throwExceptionIfFound();
                    if (!(this.isDownloadComplete() || this.getTerminated() || this.getInterrupted())) {
                        v6 = this.getDelegate();
                        if (v6 != null) {
                            v6.saveDownloadProgress(this.downloadInfo);
                            v7 = Unit.INSTANCE;
                        } else {
                            v7 = null;
                        }
                        v8 = this.getDelegate();
                        if (v8 != null) {
                            v8.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                            v9 = Unit.INSTANCE;
                        } else {
                            v9 = null;
                        }
                        break block85;
                    }
                    if (this.getInterrupted() || this.getTerminated() || !this.isDownloadComplete()) break block85;
                    if (!this.totalUnknown) {
                        fileSlicesTotal = 0L;
                        $receiver$iv = this.fileSlices;
                        for (T element$iv : $receiver$iv) {
                            it = (FileSlice)element$iv;
                            fileSlicesTotal += it.getDownloaded();
                        }
                        if (fileSlicesTotal != this.total) {
                            this.throwable = new FetchException("download_incomplete");
                            this.throwExceptionIfFound();
                        }
                    } else {
                        this.total = this.downloaded;
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                    }
                    if (!this.getTerminated() && !this.getInterrupted()) {
                        v10 = this.getDelegate();
                        if (v10 != null) {
                            v10.saveDownloadProgress(this.downloadInfo);
                            v11 = Unit.INSTANCE;
                        } else {
                            v11 = null;
                        }
                    }
                    if (!this.hashCheckingEnabled) break block86;
                    if (openingResponse != null && this.downloader.verifyContentHash(openingResponse.getRequest(), openingResponse.getHash())) {
                        FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
                        if (!this.getInterrupted() && !this.getTerminated()) {
                            v12 = this.getDelegate();
                            if (v12 != null) {
                                v12.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                                v13 = Unit.INSTANCE;
                            } else {
                                v13 = null;
                            }
                            v14 = this.getDelegate();
                            if (v14 != null) {
                                v14.onComplete(this.downloadInfo);
                                v15 = Unit.INSTANCE;
                            } else {
                                v15 = null;
                            }
                        }
                        break block85;
                    }
                    FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
                    throw (Throwable)new FetchException("invalid content hash");
                }
                FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
                if (this.getInterrupted() || this.getTerminated()) break block85;
                v16 = this.getDelegate();
                if (v16 != null) {
                    v16.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                    v17 = Unit.INSTANCE;
                } else {
                    v17 = null;
                }
                v18 = this.getDelegate();
                if (v18 != null) {
                    v18.onComplete(this.downloadInfo);
                    v19 = Unit.INSTANCE;
                    break block85;
                }
                v19 = null;
            }
            try {
                v20 = this.executorService;
                if (v20 != null) {
                    v20.shutdown();
                    v21 = Unit.INSTANCE;
                } else {
                    v21 = null;
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
            try {
                v22 = this.outputResourceWrapper;
                if (v22 != null) {
                    v22.close();
                    v23 = Unit.INSTANCE;
                } else {
                    v23 = null;
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
            if (openingResponse != null) {
                try {
                    this.downloader.disconnect(openingResponse);
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
            }
            this.setTerminated(true);
            break block88;
            catch (Exception e) {
                block87: {
                    try {
                        if (this.getInterrupted() || this.getTerminated()) break block87;
                        this.logger.e("FileDownloader download:" + this.getDownload(), (Throwable)e);
                        error = FetchErrorUtils.getErrorFromThrowable(e);
                        error.setThrowable(e);
                        if (this.retryOnNetworkGain) {
                            disconnectDetected = this.networkInfoProvider.isNetworkAvailable() == false;
                            $receiver$iv = 1;
                            var6_22 = 10;
                            while ($receiver$iv <= var6_22) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    this.logger.e("FileDownloader", (Throwable)e);
                                    break;
                                }
                                if (!this.networkInfoProvider.isNetworkAvailable()) {
                                    disconnectDetected = true;
                                    break;
                                }
                                ++i;
                            }
                            if (disconnectDetected) {
                                error = Error.NO_NETWORK_CONNECTION;
                            }
                        }
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        this.downloadInfo.setError(error);
                        if (this.getTerminated() || this.getInterrupted()) break block87;
                        v24 = this.getDelegate();
                        if (v24 != null) {
                            v24.onError(this.downloadInfo, error, e);
                            v25 = Unit.INSTANCE;
                            break block87;
                        }
                        v25 = null;
                    }
                    catch (Throwable var2_11) {
                        try {
                            v26 = this.executorService;
                            if (v26 != null) {
                                v26.shutdown();
                                v27 = Unit.INSTANCE;
                            } else {
                                v27 = null;
                            }
                        }
                        catch (Exception e) {
                            this.logger.e("FileDownloader", (Throwable)e);
                        }
                        try {
                            v28 = this.outputResourceWrapper;
                            if (v28 != null) {
                                v28.close();
                                v29 = Unit.INSTANCE;
                            } else {
                                v29 = null;
                            }
                        }
                        catch (Exception e) {
                            this.logger.e("FileDownloader", (Throwable)e);
                        }
                        if (openingResponse != null) {
                            try {
                                this.downloader.disconnect(openingResponse);
                            }
                            catch (Exception e) {
                                this.logger.e("FileDownloader", (Throwable)e);
                            }
                        }
                        this.setTerminated(true);
                        throw var2_11;
                    }
                }
                try {
                    v30 = this.executorService;
                    if (v30 != null) {
                        v30.shutdown();
                        v31 = Unit.INSTANCE;
                    } else {
                        v31 = null;
                    }
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
                try {
                    v32 = this.outputResourceWrapper;
                    if (v32 != null) {
                        v32.close();
                        v33 = Unit.INSTANCE;
                    } else {
                        v33 = null;
                    }
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
                if (openingResponse != null) {
                    try {
                        this.downloader.disconnect(openingResponse);
                    }
                    catch (Exception e) {
                        this.logger.e("FileDownloader", (Throwable)e);
                    }
                }
                this.setTerminated(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileSlice> getFileSliceList(boolean acceptsRanges, Downloader.ServerRequest request) {
        List list;
        if (!this.storageResolver.fileExists(this.downloadInfo.getFile())) {
            FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
        }
        int previousSliceSize = FetchUtils.getPreviousSliceCount(this.downloadInfo.getId(), this.fileTempDir);
        if (acceptsRanges && !this.totalUnknown) {
            FileSliceInfo fileSliceInfo = this.getChuckInfo(request);
            if (previousSliceSize != fileSliceInfo.getSlicingCount()) {
                FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
            }
            FetchUtils.saveCurrentSliceCount(this.downloadInfo.getId(), fileSliceInfo.getSlicingCount(), this.fileTempDir);
            long counterBytes = 0L;
            List fileSlices = new ArrayList();
            int n = 1;
            int n2 = fileSliceInfo.getSlicingCount();
            if (n <= n2) {
                while (!this.getInterrupted() && !this.getTerminated()) {
                    void position;
                    long endBytes;
                    long startBytes = counterBytes;
                    counterBytes = endBytes = fileSliceInfo.getSlicingCount() == position ? this.total : counterBytes + fileSliceInfo.getBytesPerFileSlice();
                    FileSlice fileSlice = new FileSlice(this.downloadInfo.getId(), (int)position, startBytes, endBytes, FetchUtils.getSavedDownloadedInfo(this.downloadInfo.getId(), (int)position, this.fileTempDir));
                    this.downloaded += fileSlice.getDownloaded();
                    fileSlices.add(fileSlice);
                    if (position == n2) break;
                    ++position;
                }
            }
            list = fileSlices;
        } else {
            if (previousSliceSize != 1) {
                FetchUtils.deleteAllInFolderForId(this.downloadInfo.getId(), this.fileTempDir);
            }
            FetchUtils.saveCurrentSliceCount(this.downloadInfo.getId(), 1, this.fileTempDir);
            FileSlice fileSlice = new FileSlice(this.downloadInfo.getId(), 1, 0L, this.total, FetchUtils.getSavedDownloadedInfo(this.downloadInfo.getId(), 1, this.fileTempDir));
            this.downloaded += fileSlice.getDownloaded();
            list = CollectionsKt.listOf((Object)fileSlice);
        }
        return list;
    }

    private final FileSliceInfo getChuckInfo(Downloader.ServerRequest request) {
        Integer n = this.downloader.getFileSlicingCount(request, this.total);
        int fileSliceSize = n != null ? n : -1;
        return FetchUtils.getFileSliceInfo(fileSliceSize, this.total);
    }

    private final long getAverageDownloadedBytesPerSecond() {
        if (this.averageDownloadedBytesPerSecond < 1.0) {
            return 0L;
        }
        double d = this.averageDownloadedBytesPerSecond;
        return (long)Math.ceil(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitAndPerformProgressReporting() {
        long downloadedBytesPerSecond = this.downloaded;
        long reportingStartTime = System.nanoTime();
        long downloadSpeedStartTime = System.nanoTime();
        while (this.actionsCounter != this.actionsTotal && !this.getInterrupted() && !this.getTerminated()) {
            long reportingStopTime;
            boolean hasReportingTimeElapsed;
            this.downloadInfo.setDownloaded(this.downloaded);
            this.downloadInfo.setTotal(this.total);
            long downloadSpeedStopTime = System.nanoTime();
            boolean downloadSpeedCheckTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)downloadSpeedStartTime, (long)downloadSpeedStopTime, (long)1000L);
            if (downloadSpeedCheckTimeElapsed) {
                downloadedBytesPerSecond = this.downloaded - downloadedBytesPerSecond;
                this.movingAverageCalculator.add((double)downloadedBytesPerSecond);
                this.averageDownloadedBytesPerSecond = AverageCalculator.getMovingAverageWithWeightOnRecentValues$default((AverageCalculator)this.movingAverageCalculator, (int)0, (int)1, null);
                this.estimatedTimeRemainingInMilliseconds = FetchCoreUtils.calculateEstimatedTimeRemainingInMilliseconds((long)this.downloaded, (long)this.total, (long)this.getAverageDownloadedBytesPerSecond());
                downloadedBytesPerSecond = this.downloaded;
            }
            if (hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)(reportingStopTime = System.nanoTime()), (long)this.progressReportingIntervalMillis)) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.getInterrupted() && !this.getTerminated()) {
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.saveDownloadProgress(this.downloadInfo);
                        }
                        FileDownloader.Delegate delegate2 = this.getDelegate();
                        if (delegate2 != null) {
                            delegate2.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                reportingStartTime = System.nanoTime();
            }
            if (!downloadSpeedCheckTimeElapsed) continue;
            downloadSpeedStartTime = System.nanoTime();
        }
    }

    private final void downloadSliceFiles(Downloader.ServerRequest request, List<FileSlice> fileSlicesDownloadsList) {
        this.actionsCounter = 0;
        this.actionsTotal = fileSlicesDownloadsList.size();
        OutputResourceWrapper outputResourceWrapper = this.outputResourceWrapper = this.storageResolver.getRequestOutputResourceWrapper(request);
        if (outputResourceWrapper != null) {
            outputResourceWrapper.setWriteOffset(0L);
        }
        for (FileSlice fileSlice : fileSlicesDownloadsList) {
            if (this.getInterrupted() || this.getTerminated()) break;
            ExecutorService executorService = this.executorService;
            if (executorService == null) continue;
            executorService.execute(new Runnable(this, fileSlice){
                final /* synthetic */ ParallelFileDownloaderImpl this$0;
                final /* synthetic */ FileSlice $fileSlice;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final void run() {
                    block43: {
                        try {
                            v0 = Thread.currentThread();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"Thread.currentThread()");
                            v0.setName(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0).getNamespace() + '-' + ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0).getId() + "-Slice-" + this.$fileSlice.getPosition());
                        }
                        catch (Exception var1_1) {
                            // empty catch block
                        }
                        downloadBlock = new DownloadBlockInfo();
                        downloadBlock.setDownloadId(this.$fileSlice.getId());
                        downloadBlock.setBlockPosition(this.$fileSlice.getPosition());
                        downloadBlock.setDownloadedBytes(this.$fileSlice.getDownloaded());
                        downloadBlock.setStartByte(this.$fileSlice.getStartBytes());
                        downloadBlock.setEndByte(this.$fileSlice.getEndBytes());
                        downloadRequest = FetchUtils.getRequestForDownload$default(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0), this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded(), 0L, null, 12, null);
                        downloadResponse = null;
                        saveRandomAccessFile = null;
                        file = FetchCoreUtils.getFile((String)FetchUtils.getDownloadedInfoFilePath(this.$fileSlice.getId(), this.$fileSlice.getPosition(), ParallelFileDownloaderImpl.access$getFileTempDir$p(this.this$0)));
                        saveRandomAccessFile = new RandomAccessFile(file, "rw");
                        downloadResponse = ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).execute(downloadRequest, (InterruptMonitor)ParallelFileDownloaderImpl.access$getInterruptMonitor$p(this.this$0));
                        if (this.this$0.getTerminated() || this.this$0.getInterrupted()) ** GOTO lbl-1000
                        v1 = downloadResponse;
                        if (v1 == null) ** GOTO lbl-1000
                        if (v1.isSuccessful()) {
                            var6_14 = new Ref.LongRef();
                            bufferSize = ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).getRequestBufferSize(downloadRequest);
                            buffer = new byte[bufferSize];
                            v2 = downloadResponse.getByteStream();
                            read = v2 != null ? v2.read(buffer, 0, bufferSize) : -1;
                            naturalEnd = this.$fileSlice.getEndBytes() < 1L ? 0L : this.$fileSlice.getEndBytes();
                            remainderBytes = naturalEnd - (this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded());
                            reportingStartTime = System.nanoTime();
                            streamBytes = new Ref.IntRef();
                            var15_24 = new Ref.LongRef();
                            while (!(!ParallelFileDownloaderImpl.access$getTotalUnknown$p(this.this$0) && remainderBytes <= 0L || read == -1 || this.this$0.getInterrupted() || this.this$0.getTerminated())) {
                                if (ParallelFileDownloaderImpl.access$getTotalUnknown$p(this.this$0) || (long)read <= remainderBytes) {
                                    v3 = read;
                                } else {
                                    read = -1;
                                    v3 = (int)remainderBytes;
                                }
                                streamBytes.element = v3;
                                var15_24.element = this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded();
                                var16_25 = ParallelFileDownloaderImpl.access$getLock$p(this.this$0);
                                synchronized (var16_25) {
                                    if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                        v4 = ParallelFileDownloaderImpl.access$getOutputResourceWrapper$p(this.this$0);
                                        if (v4 != null) {
                                            v4.setWriteOffset(var15_24.element);
                                        }
                                        v5 = ParallelFileDownloaderImpl.access$getOutputResourceWrapper$p(this.this$0);
                                        if (v5 != null) {
                                            v5.write(buffer, 0, streamBytes.element);
                                        }
                                        if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                            v6 = this.$fileSlice;
                                            v6.setDownloaded(v6.getDownloaded() + (long)streamBytes.element);
                                            saveRandomAccessFile.seek(0L);
                                            saveRandomAccessFile.setLength(0L);
                                            saveRandomAccessFile.writeLong(this.$fileSlice.getDownloaded());
                                            v7 = this.this$0;
                                            ParallelFileDownloaderImpl.access$setDownloaded$p(v7, ParallelFileDownloaderImpl.access$getDownloaded$p(v7) + (long)streamBytes.element);
                                        }
                                        var6_14.element = System.nanoTime();
                                        hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)var6_14.element, (long)ParallelFileDownloaderImpl.access$getProgressReportingIntervalMillis$p(this.this$0));
                                        if (hasReportingTimeElapsed) {
                                            if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                                downloadBlock.setDownloadedBytes(this.$fileSlice.getDownloaded());
                                                v8 = this.this$0.getDelegate();
                                                if (v8 != null) {
                                                    v8.onDownloadBlockUpdated(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0), (DownloadBlock)downloadBlock, ParallelFileDownloaderImpl.access$getTotalDownloadBlocks$p(this.this$0));
                                                }
                                            }
                                            reportingStartTime = System.nanoTime();
                                        }
                                    }
                                    var18_27 = Unit.INSTANCE;
                                }
                                if (this.this$0.getInterrupted() || this.this$0.getTerminated() || read == -1) continue;
                                v9 = downloadResponse.getByteStream();
                                v10 = read = v9 != null ? v9.read(buffer, 0, bufferSize) : -1;
                                if (ParallelFileDownloaderImpl.access$getTotalUnknown$p(this.this$0)) continue;
                                remainderBytes = naturalEnd - (this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded());
                            }
                        } else lbl-1000:
                        // 3 sources

                        {
                            if (downloadResponse == null && !this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                throw (Throwable)new FetchException("empty_response_body");
                            }
                            v11 = downloadResponse;
                            if (v11 != null) {
                                if (!v11.isSuccessful()) {
                                    if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                        throw (Throwable)new FetchException("request_not_successful");
                                    }
                                }
                            }
                            if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                throw (Throwable)new FetchException("unknown");
                            }
                        }
                        ** try [egrp 4[TRYBLOCK] [3 : 1006->1027)] { 
lbl-1000:
                        // 1 sources

                        {
                            if (downloadResponse != null) {
                                ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).disconnect(downloadResponse);
                            }
                        }
lbl99:
                        // 1 sources

                        catch (Exception e) {
                            ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader", (Throwable)e);
                        }
                        try {
                            saveRandomAccessFile.close();
                        }
                        catch (Exception e) {
                            ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader", (Throwable)e);
                        }
                        ParallelFileDownloaderImpl.access$incrementActionCompletedCount(this.this$0);
                        break block43;
                        catch (Exception e) {
                            ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader downloads slice " + this.$fileSlice, (Throwable)e);
                            ParallelFileDownloaderImpl.access$setThrowable$p(this.this$0, e);
                            break block43;
                        }
                        finally {
                            try {
                                if (downloadResponse != null) {
                                    ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).disconnect(downloadResponse);
                                }
                            }
                            catch (Exception e) {
                                ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader", (Throwable)e);
                            }
                            try {
                                v12 = saveRandomAccessFile;
                                if (v12 != null) {
                                    v12.close();
                                }
                            }
                            catch (Exception e) {
                                ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader", (Throwable)e);
                            }
                            ParallelFileDownloaderImpl.access$incrementActionCompletedCount(this.this$0);
                        }
                    }
                }
                {
                    this.this$0 = parallelFileDownloaderImpl;
                    this.$fileSlice = fileSlice;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void incrementActionCompletedCount() {
        Object object = this.lock;
        synchronized (object) {
            ++this.actionsCounter;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean isDownloadComplete() {
        return (this.downloaded > 0L && this.total > 0L || this.totalUnknown) && this.downloaded >= this.total;
    }

    private final void setIsTotalUnknown(Downloader.Response response2) {
        if (response2.isSuccessful() && response2.getContentLength() == -1L) {
            this.totalUnknown = true;
        }
    }

    private final void throwExceptionIfFound() {
        Throwable exception = this.throwable;
        if (exception != null) {
            throw exception;
        }
    }

    public ParallelFileDownloaderImpl(@NotNull Download initialDownload, @NotNull Downloader<?, ?> downloader, long progressReportingIntervalMillis, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, @NotNull String fileTempDir, boolean hashCheckingEnabled, @NotNull StorageResolver storageResolver) {
        Intrinsics.checkParameterIsNotNull((Object)initialDownload, (String)"initialDownload");
        Intrinsics.checkParameterIsNotNull(downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        Intrinsics.checkParameterIsNotNull((Object)storageResolver, (String)"storageResolver");
        this.initialDownload = initialDownload;
        this.downloader = downloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.fileTempDir = fileTempDir;
        this.hashCheckingEnabled = hashCheckingEnabled;
        this.storageResolver = storageResolver;
        this.downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(this.initialDownload);
        this.total = -1L;
        this.movingAverageCalculator = new AverageCalculator(5);
        this.estimatedTimeRemainingInMilliseconds = -1L;
        this.lock = new Object();
        this.fileSlices = CollectionsKt.emptyList();
        this.interruptMonitor = new InterruptMonitor(this){
            final /* synthetic */ ParallelFileDownloaderImpl this$0;

            public boolean isInterrupted() {
                return this.this$0.getInterrupted();
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ DownloadInfo access$getDownloadInfo$p(ParallelFileDownloaderImpl $this) {
        return $this.downloadInfo;
    }

    @NotNull
    public static final /* synthetic */ String access$getFileTempDir$p(ParallelFileDownloaderImpl $this) {
        return $this.fileTempDir;
    }

    @NotNull
    public static final /* synthetic */ Downloader access$getDownloader$p(ParallelFileDownloaderImpl $this) {
        return $this.downloader;
    }

    @NotNull
    public static final /* synthetic */ interruptMonitor.1 access$getInterruptMonitor$p(ParallelFileDownloaderImpl $this) {
        return $this.interruptMonitor;
    }

    public static final /* synthetic */ boolean access$getTotalUnknown$p(ParallelFileDownloaderImpl $this) {
        return $this.totalUnknown;
    }

    public static final /* synthetic */ void access$setTotalUnknown$p(ParallelFileDownloaderImpl $this, boolean bl) {
        $this.totalUnknown = bl;
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(ParallelFileDownloaderImpl $this) {
        return $this.lock;
    }

    @Nullable
    public static final /* synthetic */ OutputResourceWrapper access$getOutputResourceWrapper$p(ParallelFileDownloaderImpl $this) {
        return $this.outputResourceWrapper;
    }

    public static final /* synthetic */ void access$setOutputResourceWrapper$p(ParallelFileDownloaderImpl $this, @Nullable OutputResourceWrapper outputResourceWrapper) {
        $this.outputResourceWrapper = outputResourceWrapper;
    }

    public static final /* synthetic */ long access$getDownloaded$p(ParallelFileDownloaderImpl $this) {
        return $this.downloaded;
    }

    public static final /* synthetic */ void access$setDownloaded$p(ParallelFileDownloaderImpl $this, long l) {
        $this.downloaded = l;
    }

    public static final /* synthetic */ long access$getProgressReportingIntervalMillis$p(ParallelFileDownloaderImpl $this) {
        return $this.progressReportingIntervalMillis;
    }

    public static final /* synthetic */ int access$getTotalDownloadBlocks$p(ParallelFileDownloaderImpl $this) {
        return $this.totalDownloadBlocks;
    }

    public static final /* synthetic */ void access$setTotalDownloadBlocks$p(ParallelFileDownloaderImpl $this, int n) {
        $this.totalDownloadBlocks = n;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(ParallelFileDownloaderImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$incrementActionCompletedCount(ParallelFileDownloaderImpl $this) {
        $this.incrementActionCompletedCount();
    }

    @Nullable
    public static final /* synthetic */ Throwable access$getThrowable$p(ParallelFileDownloaderImpl $this) {
        return $this.throwable;
    }

    public static final /* synthetic */ void access$setThrowable$p(ParallelFileDownloaderImpl $this, @Nullable Throwable throwable) {
        $this.throwable = throwable;
    }
}

