/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.util;

import com.tonyodev.fetch2.CompletedDownload;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Priority;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2core.FetchCoreUtils;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0004\u00a8\u0006\u0005"}, d2={"toDownloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "Lcom/tonyodev/fetch2/CompletedDownload;", "Lcom/tonyodev/fetch2/Download;", "Lcom/tonyodev/fetch2/Request;", "fetch2_release"})
@JvmName(name="FetchTypeConverterExtensions")
public final class FetchTypeConverterExtensions {
    @NotNull
    public static final DownloadInfo toDownloadInfo(@NotNull Request $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DownloadInfo downloadInfo = new DownloadInfo();
        downloadInfo.setId($receiver.getId());
        downloadInfo.setUrl($receiver.getUrl());
        downloadInfo.setFile($receiver.getFile());
        downloadInfo.setPriority($receiver.getPriority());
        downloadInfo.setHeaders(MapsKt.toMap($receiver.getHeaders()));
        downloadInfo.setGroup($receiver.getGroupId());
        downloadInfo.setNetworkType($receiver.getNetworkType());
        downloadInfo.setStatus(FetchDefaults.getDefaultStatus());
        downloadInfo.setError(FetchDefaults.getDefaultNoError());
        downloadInfo.setDownloaded(0L);
        downloadInfo.setTag($receiver.getTag());
        downloadInfo.setEnqueueAction($receiver.getEnqueueAction());
        downloadInfo.setIdentifier($receiver.getIdentifier());
        downloadInfo.setDownloadOnEnqueue($receiver.getDownloadOnEnqueue());
        downloadInfo.setExtras($receiver.getExtras());
        return downloadInfo;
    }

    @NotNull
    public static final DownloadInfo toDownloadInfo(@NotNull Download $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DownloadInfo downloadInfo = new DownloadInfo();
        downloadInfo.setId($receiver.getId());
        downloadInfo.setNamespace($receiver.getNamespace());
        downloadInfo.setUrl($receiver.getUrl());
        downloadInfo.setFile($receiver.getFile());
        downloadInfo.setGroup($receiver.getGroup());
        downloadInfo.setPriority($receiver.getPriority());
        downloadInfo.setHeaders(MapsKt.toMap($receiver.getHeaders()));
        downloadInfo.setDownloaded($receiver.getDownloaded());
        downloadInfo.setTotal($receiver.getTotal());
        downloadInfo.setStatus($receiver.getStatus());
        downloadInfo.setNetworkType($receiver.getNetworkType());
        downloadInfo.setError($receiver.getError());
        downloadInfo.setCreated($receiver.getCreated());
        downloadInfo.setTag($receiver.getTag());
        downloadInfo.setEnqueueAction($receiver.getEnqueueAction());
        downloadInfo.setIdentifier($receiver.getIdentifier());
        downloadInfo.setDownloadOnEnqueue($receiver.getDownloadOnEnqueue());
        downloadInfo.setExtras($receiver.getExtras());
        return downloadInfo;
    }

    @NotNull
    public static final DownloadInfo toDownloadInfo(@NotNull CompletedDownload $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DownloadInfo downloadInfo = new DownloadInfo();
        downloadInfo.setId(FetchCoreUtils.getUniqueId((String)$receiver.getUrl(), (String)$receiver.getFile()));
        downloadInfo.setUrl($receiver.getUrl());
        downloadInfo.setFile($receiver.getFile());
        downloadInfo.setGroup($receiver.getGroup());
        downloadInfo.setPriority(Priority.NORMAL);
        downloadInfo.setHeaders(MapsKt.toMap($receiver.getHeaders()));
        downloadInfo.setDownloaded($receiver.getFileByteSize());
        downloadInfo.setTotal($receiver.getFileByteSize());
        downloadInfo.setStatus(Status.COMPLETED);
        downloadInfo.setNetworkType(NetworkType.ALL);
        downloadInfo.setError(Error.NONE);
        downloadInfo.setCreated($receiver.getCreated());
        downloadInfo.setTag($receiver.getTag());
        downloadInfo.setEnqueueAction(EnqueueAction.REPLACE_EXISTING);
        downloadInfo.setIdentifier($receiver.getIdentifier());
        downloadInfo.setDownloadOnEnqueue(true);
        downloadInfo.setExtras($receiver.getExtras());
        return downloadInfo;
    }
}

