/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.util;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.FetchConfiguration;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.util.FetchUtils$WhenMappings;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileSliceInfo;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b\u001a\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b\u001a\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u001e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b\u001a\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 \u001a\u0016\u0010!\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b\u001a\u0016\u0010\"\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b\u001a,\u0010#\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010$\u001a\u00020 2\b\b\u0002\u0010%\u001a\u00020 2\b\b\u0002\u0010&\u001a\u00020\u000b\u001a\u0018\u0010#\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010&\u001a\u00020\u000b\u001a\u001e\u0010'\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b\u001a\u000e\u0010(\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u001e\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b\u001a&\u0010+\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u000b\u00a8\u0006-"}, d2={"canCancelDownload", "", "download", "Lcom/tonyodev/fetch2/Download;", "canPauseDownload", "canResumeDownload", "canRetryDownload", "createConfigWithNewNamespace", "Lcom/tonyodev/fetch2/FetchConfiguration;", "fetchConfiguration", "namespace", "", "deleteMetaFile", "", "id", "", "fileTempDir", "deleteRequestTempFiles", "defaultTempFilesDir", "downloader", "Lcom/tonyodev/fetch2core/Downloader;", "deleteTempFile", "position", "getCatalogServerRequestFromRequest", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "request", "Lcom/tonyodev/fetch2/Request;", "getDownloadedInfoFilePath", "getFileSliceInfo", "Lcom/tonyodev/fetch2core/FileSliceInfo;", "fileSliceSize", "totalBytes", "", "getMetaFilePath", "getPreviousSliceCount", "getRequestForDownload", "rangeStart", "rangeEnd", "requestMethod", "getSavedDownloadedInfo", "getServerRequestFromRequest", "saveCurrentSliceCount", "SliceCount", "saveDownloadedInfo", "downloaded", "fetch2_release"})
@JvmName(name="FetchUtils")
public final class FetchUtils {
    public static final boolean canPauseDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$0[download.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canResumeDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$1[download.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canRetryDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$2[download.getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canCancelDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$3[download.getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public static final Downloader.ServerRequest getRequestForDownload(@NotNull Download download, @NotNull String requestMethod) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Intrinsics.checkParameterIsNotNull((Object)requestMethod, (String)"requestMethod");
        return FetchUtils.getRequestForDownload(download, -1L, -1L, requestMethod);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Downloader.ServerRequest getRequestForDownload$default(Download download, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "GET";
        }
        return FetchUtils.getRequestForDownload(download, string);
    }

    @NotNull
    public static final Downloader.ServerRequest getRequestForDownload(@NotNull Download download, long rangeStart, long rangeEnd, @NotNull String requestMethod) {
        Map headers;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Intrinsics.checkParameterIsNotNull((Object)requestMethod, (String)"requestMethod");
        long start = rangeStart == -1L ? 0L : rangeStart;
        String end = rangeEnd == -1L ? "" : String.valueOf(rangeEnd);
        Map map = headers = MapsKt.toMutableMap(download.getHeaders());
        String string = "Range";
        String string2 = "bytes=" + start + '-' + end;
        map.put(string, string2);
        return new Downloader.ServerRequest(download.getId(), download.getUrl(), headers, download.getFile(), download.getTag(), download.getIdentifier(), requestMethod);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Downloader.ServerRequest getRequestForDownload$default(Download download, long l, long l2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            l = -1L;
        }
        if ((n & 4) != 0) {
            l2 = -1L;
        }
        if ((n & 8) != 0) {
            string = "GET";
        }
        return FetchUtils.getRequestForDownload(download, l, l2, string);
    }

    @NotNull
    public static final Downloader.ServerRequest getServerRequestFromRequest(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        String string = request.getFile();
        String string2 = "GET";
        long l = request.getIdentifier();
        String string3 = request.getTag();
        return new Downloader.ServerRequest(request.getId(), request.getUrl(), request.getHeaders(), string, string3, l, string2);
    }

    @NotNull
    public static final Downloader.ServerRequest getCatalogServerRequestFromRequest(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Map headers = MapsKt.toMutableMap(request.getHeaders());
        Object object = headers;
        String string = "Range";
        String string2 = "bytes=0-";
        object.put(string, string2);
        object = headers;
        string = "Page";
        string2 = "-1";
        object.put(string, string2);
        object = headers;
        string = "Size";
        string2 = "-1";
        object.put(string, string2);
        object = headers;
        string = "Type";
        string2 = String.valueOf(1);
        object.put(string, string2);
        object = request.getFile();
        string = "GET";
        long l = request.getIdentifier();
        String string3 = request.getTag();
        return new Downloader.ServerRequest(request.getId(), request.getUrl(), headers, (String)object, string3, l, string);
    }

    public static final void deleteRequestTempFiles(@NotNull String defaultTempFilesDir, @NotNull Downloader downloader, @NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)defaultTempFilesDir, (String)"defaultTempFilesDir");
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        try {
            Downloader.ServerRequest request = FetchUtils.getRequestForDownload$default(download, null, 2, null);
            String string = downloader.getDirectoryForFileDownloaderTypeParallel(request);
            if (string == null) {
                string = defaultTempFilesDir;
            }
            String tempDirPath = string;
            File tempDir = FetchCoreUtils.getFile((String)tempDirPath);
            if (tempDir.exists()) {
                File[] tempFiles = tempDir.listFiles();
                int n = tempFiles.length;
                for (int i = 0; i < n; ++i) {
                    File tempFile;
                    File file = tempFile = tempFiles[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"tempFile");
                    String string2 = file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tempFile.name");
                    boolean match = StringsKt.startsWith$default((String)string2, (String)("" + download.getId() + '.'), (boolean)false, (int)2, null);
                    if (!match || !tempFile.exists()) continue;
                    try {
                        tempFile.delete();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final int getPreviousSliceCount(int id, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        int sliceCount = -1;
        try {
            int n;
            String string = FetchCoreUtils.getSingleLineTextFromFile((String)FetchUtils.getMetaFilePath(id, fileTempDir));
            if (string != null) {
                String string2 = string;
                n = Integer.parseInt(string2);
            } else {
                n = -1;
            }
            sliceCount = n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sliceCount;
    }

    @NotNull
    public static final String getMetaFilePath(int id, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        return fileTempDir + '/' + id + ".meta.txt";
    }

    public static final void saveCurrentSliceCount(int id, int SliceCount, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        try {
            FetchCoreUtils.writeTextToFile((String)FetchUtils.getMetaFilePath(id, fileTempDir), (String)String.valueOf(SliceCount));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static final String getDownloadedInfoFilePath(int id, int position, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        return fileTempDir + '/' + id + '.' + position + ".txt";
    }

    public static final void deleteTempFile(int id, int position, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        try {
            File textFile = FetchCoreUtils.getFile((String)FetchUtils.getDownloadedInfoFilePath(id, position, fileTempDir));
            if (textFile.exists()) {
                textFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void deleteMetaFile(int id, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        try {
            File textFile = FetchCoreUtils.getFile((String)FetchUtils.getMetaFilePath(id, fileTempDir));
            if (textFile.exists()) {
                textFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final long getSavedDownloadedInfo(int id, int position, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        long downloaded = 0L;
        try {
            long l;
            String string = FetchCoreUtils.getSingleLineTextFromFile((String)FetchUtils.getDownloadedInfoFilePath(id, position, fileTempDir));
            if (string != null) {
                String string2 = string;
                l = Long.parseLong(string2);
            } else {
                l = 0L;
            }
            downloaded = l;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return downloaded;
    }

    public static final void saveDownloadedInfo(int id, int position, long downloaded, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        try {
            FetchCoreUtils.writeTextToFile((String)FetchUtils.getDownloadedInfoFilePath(id, position, fileTempDir), (String)String.valueOf(downloaded));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static final FileSliceInfo getFileSliceInfo(int fileSliceSize, long totalBytes) {
        FileSliceInfo fileSliceInfo;
        if (fileSliceSize == -1) {
            float fileSizeInMb = (float)totalBytes / 1024.0f * 1024.0f;
            float fileSizeInGb = (float)totalBytes / 1024.0f * 1024.0f * 1024.0f;
            if (fileSizeInGb >= 1.0f) {
                int slices = 6;
                float f = (float)totalBytes / (float)slices;
                long bytesPerSlice = (long)Math.ceil(f);
                fileSliceInfo = new FileSliceInfo(slices, bytesPerSlice);
            } else if (fileSizeInMb >= 1.0f) {
                int slices = 4;
                float f = (float)totalBytes / (float)slices;
                long bytesPerSlice = (long)Math.ceil(f);
                fileSliceInfo = new FileSliceInfo(slices, bytesPerSlice);
            } else {
                fileSliceInfo = new FileSliceInfo(2, totalBytes);
            }
        } else {
            float f = (float)totalBytes / (float)fileSliceSize;
            long bytesPerSlice = (long)Math.ceil(f);
            return new FileSliceInfo(fileSliceSize, bytesPerSlice);
        }
        return fileSliceInfo;
    }

    @NotNull
    public static final FetchConfiguration createConfigWithNewNamespace(@NotNull FetchConfiguration fetchConfiguration, @NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)fetchConfiguration, (String)"fetchConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        return new FetchConfiguration.Builder(fetchConfiguration.getAppContext()).setNamespace(namespace).enableAutoStart(fetchConfiguration.getAutoStart()).enableLogging(fetchConfiguration.getLoggingEnabled()).enableRetryOnNetworkGain(fetchConfiguration.getRetryOnNetworkGain()).setHttpDownloader(fetchConfiguration.getHttpDownloader()).setFileServerDownloader(fetchConfiguration.getFileServerDownloader()).setDownloadConcurrentLimit(fetchConfiguration.getConcurrentLimit()).setProgressReportingInterval(fetchConfiguration.getProgressReportingIntervalMillis()).setGlobalNetworkType(fetchConfiguration.getGlobalNetworkType()).setLogger(fetchConfiguration.getLogger()).build();
    }
}

