/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.database;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DownloadDatabase;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.database.migration.Migration;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.exception.FetchImplementationException;
import com.tonyodev.fetch2.util.FetchDatabaseExtensions;
import com.tonyodev.fetch2core.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0006\u0010#\u001a\u00020$H\u0016J\u001e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0 H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\u001e2\u0006\u0010'\u001a\u00020\u0005H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010)\u001a\u00020$H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010+\u001a\u00020,H\u0016J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010.\u001a\u00020$2\u0006\u0010+\u001a\u00020,H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016J\u001c\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\r012\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\r010 2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016J\b\u00102\u001a\u00020\u001bH\u0002J\u0010\u00103\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u00103\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u00105\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016R\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/tonyodev/fetch2/database/DatabaseManagerImpl;", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "context", "Landroid/content/Context;", "namespace", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "migrations", "", "Lcom/tonyodev/fetch2/database/migration/Migration;", "(Landroid/content/Context;Ljava/lang/String;Lcom/tonyodev/fetch2core/Logger;[Lcom/tonyodev/fetch2/database/migration/Migration;)V", "closed", "", "database", "Landroid/arch/persistence/db/SupportSQLiteDatabase;", "getDatabase", "()Landroid/arch/persistence/db/SupportSQLiteDatabase;", "isClosed", "()Z", "lock", "Ljava/lang/Object;", "getLogger", "()Lcom/tonyodev/fetch2core/Logger;", "requestDatabase", "Lcom/tonyodev/fetch2/database/DownloadDatabase;", "close", "", "delete", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "downloadInfoList", "", "deleteAll", "get", "id", "", "ids", "getByFile", "file", "getByGroup", "group", "getByStatus", "status", "Lcom/tonyodev/fetch2/Status;", "getDownloadsInGroupWithStatus", "groupId", "getPendingDownloadsSorted", "insert", "Lkotlin/Pair;", "throwExceptionIfClosed", "update", "updateFileBytesInfoAndStatusOnly", "updateNoLock", "fetch2_release"})
public final class DatabaseManagerImpl
implements DatabaseManager {
    private final Object lock;
    private volatile boolean closed;
    private final DownloadDatabase requestDatabase;
    @NotNull
    private final SupportSQLiteDatabase database;
    private final String namespace;
    @NotNull
    private final Logger logger;

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @NotNull
    public final SupportSQLiteDatabase getDatabase() {
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Pair<DownloadInfo, Boolean> insert(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            long row = this.requestDatabase.requestDao().insert(downloadInfo);
            Pair pair = new Pair((Object)downloadInfo, (Object)this.requestDatabase.wasRowInserted(row));
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<DownloadInfo, Boolean>> insert(@NotNull List<DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        Object object = this.lock;
        synchronized (object) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            this.throwExceptionIfClosed();
            List<Long> rowsList = this.requestDatabase.requestDao().insert(downloadInfoList);
            Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.getIndices((Collection)rowsList);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                Pair pair = new Pair((Object)downloadInfoList.get((int)it), (Object)this.requestDatabase.wasRowInserted(((Number)rowsList.get((int)it)).longValue()));
                Pair pair2 = pair;
                collection.add(pair2);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.requestDatabase.requestDao().delete(downloadInfo);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull List<DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.requestDatabase.requestDao().delete(downloadInfoList);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.requestDatabase.requestDao().deleteAll();
            this.getLogger().d("Cleared Database " + this.namespace + ".db");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.requestDatabase.requestDao().update(downloadInfo);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@NotNull List<DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        Object object = this.lock;
        synchronized (object) {
            this.updateNoLock(downloadInfoList);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void updateNoLock(@NotNull List<DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().update(downloadInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFileBytesInfoAndStatusOnly(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            try {
                this.database.beginTransaction();
                this.database.execSQL("UPDATE requests SET " + "_written_bytes = " + downloadInfo.getDownloaded() + ", " + "_total_bytes = " + downloadInfo.getTotal() + ", " + "_status = " + downloadInfo.getStatus().getValue() + ' ' + "WHERE _id = " + downloadInfo.getId());
                this.database.setTransactionSuccessful();
            }
            catch (SQLiteException e) {
                this.getLogger().e("DatabaseManager exception", (Throwable)e);
            }
            try {
                this.database.endTransaction();
            }
            catch (SQLiteException e) {
                this.getLogger().e("DatabaseManager exception", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> get() {
        Object object = this.lock;
        synchronized (object) {
            void var2_2;
            this.throwExceptionIfClosed();
            List<DownloadInfo> downloads = this.requestDatabase.requestDao().get();
            FetchDatabaseExtensions.sanitize$default((DatabaseManager)this, downloads, false, 2, null);
            void var4_3 = var2_2;
            return var4_3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DownloadInfo get(int id) {
        Object object = this.lock;
        synchronized (object) {
            void var3_3;
            this.throwExceptionIfClosed();
            DownloadInfo download = this.requestDatabase.requestDao().get(id);
            FetchDatabaseExtensions.sanitize$default((DatabaseManager)this, download, false, 2, null);
            void var5_4 = var3_3;
            return var5_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> get(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        Object object = this.lock;
        synchronized (object) {
            void var3_3;
            this.throwExceptionIfClosed();
            List<DownloadInfo> downloads = this.requestDatabase.requestDao().get(ids);
            FetchDatabaseExtensions.sanitize$default((DatabaseManager)this, downloads, false, 2, null);
            void var5_4 = var3_3;
            return var5_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DownloadInfo getByFile(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object object = this.lock;
        synchronized (object) {
            void var3_3;
            this.throwExceptionIfClosed();
            DownloadInfo download = this.requestDatabase.requestDao().getByFile(file);
            FetchDatabaseExtensions.sanitize$default((DatabaseManager)this, download, false, 2, null);
            void var5_4 = var3_3;
            return var5_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getByStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        Object object = this.lock;
        synchronized (object) {
            void var3_3;
            this.throwExceptionIfClosed();
            List downloads = this.requestDatabase.requestDao().getByStatus(status);
            if (FetchDatabaseExtensions.sanitize$default((DatabaseManager)this, downloads, false, 2, null)) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)downloads;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    DownloadInfo it = (DownloadInfo)element$iv$iv;
                    if (!(it.getStatus() == status)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                downloads = (List)destination$iv$iv;
            }
            void var14_11 = var3_3;
            return var14_11;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getByGroup(int group) {
        Object object = this.lock;
        synchronized (object) {
            void var3_3;
            this.throwExceptionIfClosed();
            List<DownloadInfo> downloads = this.requestDatabase.requestDao().getByGroup(group);
            FetchDatabaseExtensions.sanitize$default((DatabaseManager)this, downloads, false, 2, null);
            void var5_4 = var3_3;
            return var5_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getDownloadsInGroupWithStatus(int groupId, @NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            List downloads = this.requestDatabase.requestDao().getByGroupWithStatus(groupId, status);
            if (FetchDatabaseExtensions.sanitize$default((DatabaseManager)this, downloads, false, 2, null)) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)downloads;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    DownloadInfo it = (DownloadInfo)element$iv$iv;
                    if (!(it.getStatus() == status)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                downloads = (List)destination$iv$iv;
            }
            List list = downloads;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getPendingDownloadsSorted() {
        Object object = this.lock;
        synchronized (object) {
            void var2_2;
            this.throwExceptionIfClosed();
            List downloads = this.requestDatabase.requestDao().getPendingDownloadsSorted(Status.QUEUED);
            if (FetchDatabaseExtensions.sanitize$default((DatabaseManager)this, downloads, false, 2, null)) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)downloads;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    DownloadInfo it = (DownloadInfo)element$iv$iv;
                    if (!(it.getStatus() == Status.QUEUED)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                downloads = (List)destination$iv$iv;
            }
            void var13_10 = var2_2;
            return var13_10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.requestDatabase.close();
            this.getLogger().d("Database closed");
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void throwExceptionIfClosed() {
        if (this.closed) {
            throw (Throwable)new FetchImplementationException("" + this.namespace + " database is closed", FetchException.Code.CLOSED);
        }
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    public DatabaseManagerImpl(@NotNull Context context, @NotNull String namespace, @NotNull Logger logger, @NotNull Migration[] migrations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)migrations, (String)"migrations");
        this.namespace = namespace;
        this.logger = logger;
        this.lock = new Object();
        DownloadDatabase downloadDatabase = this.requestDatabase = (DownloadDatabase)((Object)((Function0)new Function0<DownloadDatabase>(this, context, migrations){
            final /* synthetic */ DatabaseManagerImpl this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ Migration[] $migrations;

            @NotNull
            public final DownloadDatabase invoke() {
                RoomDatabase.Builder builder = Room.databaseBuilder((Context)this.$context, DownloadDatabase.class, (String)("" + DatabaseManagerImpl.access$getNamespace$p(this.this$0) + ".db"));
                android.arch.persistence.room.migration.Migration[] migrationArray = this.$migrations;
                builder.addMigrations(Arrays.copyOf(migrationArray, migrationArray.length));
                return (DownloadDatabase)builder.build();
            }
            {
                this.this$0 = databaseManagerImpl;
                this.$context = context;
                this.$migrations = migrationArray;
                super(0);
            }
        }).invoke());
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)downloadDatabase), (String)"requestDatabase");
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = downloadDatabase.getOpenHelper();
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteOpenHelper, (String)"requestDatabase.openHelper");
        SupportSQLiteDatabase supportSQLiteDatabase = supportSQLiteOpenHelper.getWritableDatabase();
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteDatabase, (String)"requestDatabase.openHelper.writableDatabase");
        this.database = supportSQLiteDatabase;
    }

    @NotNull
    public static final /* synthetic */ String access$getNamespace$p(DatabaseManagerImpl $this) {
        return $this.namespace;
    }
}

