/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.FetchConfiguration;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DatabaseManagerImpl;
import com.tonyodev.fetch2.database.DownloadDatabase;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.downloader.DownloadManagerImpl;
import com.tonyodev.fetch2.fetch.DownloadManagerCoordinator;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.fetch.FetchHandlerImpl;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.helper.PriorityListProcessorImpl;
import com.tonyodev.fetch2.provider.DownloadProvider;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.HandlerWrapper;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder;", "", "()V", "holderMap", "", "", "Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Holder;", "lock", "buildModulesFromPrefs", "Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Modules;", "fetchConfiguration", "Lcom/tonyodev/fetch2/FetchConfiguration;", "removeNamespaceInstanceReference", "", "namespace", "Holder", "Modules", "fetch2_release"})
public final class FetchModulesBuilder {
    private static final Object lock;
    private static final Map<String, Holder> holderMap;
    public static final FetchModulesBuilder INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Modules buildModulesFromPrefs(@NotNull FetchConfiguration fetchConfiguration) {
        Modules modules;
        Intrinsics.checkParameterIsNotNull((Object)fetchConfiguration, (String)"fetchConfiguration");
        Object object = lock;
        synchronized (object) {
            Modules modules2;
            Holder holder = holderMap.get(fetchConfiguration.getNamespace());
            if (holder != null) {
                modules2 = new Modules(fetchConfiguration, holder.getHandlerWrapper(), holder.getDownloadBlockHandlerWrapper(), holder.getDatabaseManager(), holder.getDownloadManagerCoordinator(), holder.getListenerCoordinator());
            } else {
                HandlerWrapper newHandlerWrapper = new HandlerWrapper(fetchConfiguration.getNamespace());
                HandlerWrapper newDownloadBlockHandlerWrapper = new HandlerWrapper(fetchConfiguration.getNamespace() + "-DownloadBlockHandler");
                DatabaseManagerImpl newDatabaseManager = new DatabaseManagerImpl(fetchConfiguration.getAppContext(), fetchConfiguration.getNamespace(), fetchConfiguration.getLogger(), DownloadDatabase.Companion.getMigrations());
                DownloadManagerCoordinator downloadManagerCoordinator = new DownloadManagerCoordinator(fetchConfiguration.getNamespace());
                ListenerCoordinator listenerCoordinator = new ListenerCoordinator(fetchConfiguration.getNamespace());
                Modules newModules = new Modules(fetchConfiguration, newHandlerWrapper, newDownloadBlockHandlerWrapper, newDatabaseManager, downloadManagerCoordinator, listenerCoordinator);
                Map<String, Holder> map = holderMap;
                String string = fetchConfiguration.getNamespace();
                Holder holder2 = new Holder(newHandlerWrapper, newDatabaseManager, downloadManagerCoordinator, listenerCoordinator, newDownloadBlockHandlerWrapper);
                map.put(string, holder2);
                modules2 = newModules;
            }
            Modules modules3 = modules2;
            modules3.getHandlerWrapper().incrementUsageCounter();
            modules = modules3;
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNamespaceInstanceReference(@NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Object object = lock;
        synchronized (object) {
            Holder holder = holderMap.get(namespace);
            if (holder != null) {
                holder.getHandlerWrapper().decrementUsageCounter();
                if (holder.getHandlerWrapper().usageCount() == 0) {
                    holder.getHandlerWrapper().close();
                    holder.getDownloadBlockHandlerWrapper().close();
                    holder.getListenerCoordinator().clearAll();
                    holder.getDatabaseManager().close();
                    holder.getDownloadManagerCoordinator().clearAll();
                    holderMap.remove(namespace);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private FetchModulesBuilder() {
    }

    static {
        FetchModulesBuilder fetchModulesBuilder;
        INSTANCE = fetchModulesBuilder = new FetchModulesBuilder();
        lock = new Object();
        holderMap = new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Holder;", "", "handlerWrapper", "Lcom/tonyodev/fetch2core/HandlerWrapper;", "databaseManager", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "downloadManagerCoordinator", "Lcom/tonyodev/fetch2/fetch/DownloadManagerCoordinator;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "downloadBlockHandlerWrapper", "(Lcom/tonyodev/fetch2core/HandlerWrapper;Lcom/tonyodev/fetch2/database/DatabaseManager;Lcom/tonyodev/fetch2/fetch/DownloadManagerCoordinator;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Lcom/tonyodev/fetch2core/HandlerWrapper;)V", "getDatabaseManager", "()Lcom/tonyodev/fetch2/database/DatabaseManager;", "getDownloadBlockHandlerWrapper", "()Lcom/tonyodev/fetch2core/HandlerWrapper;", "getDownloadManagerCoordinator", "()Lcom/tonyodev/fetch2/fetch/DownloadManagerCoordinator;", "getHandlerWrapper", "getListenerCoordinator", "()Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "fetch2_release"})
    public static final class Holder {
        @NotNull
        private final HandlerWrapper handlerWrapper;
        @NotNull
        private final DatabaseManager databaseManager;
        @NotNull
        private final DownloadManagerCoordinator downloadManagerCoordinator;
        @NotNull
        private final ListenerCoordinator listenerCoordinator;
        @NotNull
        private final HandlerWrapper downloadBlockHandlerWrapper;

        @NotNull
        public final HandlerWrapper getHandlerWrapper() {
            return this.handlerWrapper;
        }

        @NotNull
        public final DatabaseManager getDatabaseManager() {
            return this.databaseManager;
        }

        @NotNull
        public final DownloadManagerCoordinator getDownloadManagerCoordinator() {
            return this.downloadManagerCoordinator;
        }

        @NotNull
        public final ListenerCoordinator getListenerCoordinator() {
            return this.listenerCoordinator;
        }

        @NotNull
        public final HandlerWrapper getDownloadBlockHandlerWrapper() {
            return this.downloadBlockHandlerWrapper;
        }

        public Holder(@NotNull HandlerWrapper handlerWrapper, @NotNull DatabaseManager databaseManager, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator, @NotNull HandlerWrapper downloadBlockHandlerWrapper) {
            Intrinsics.checkParameterIsNotNull((Object)handlerWrapper, (String)"handlerWrapper");
            Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
            Intrinsics.checkParameterIsNotNull((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
            Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
            Intrinsics.checkParameterIsNotNull((Object)downloadBlockHandlerWrapper, (String)"downloadBlockHandlerWrapper");
            this.handlerWrapper = handlerWrapper;
            this.databaseManager = databaseManager;
            this.downloadManagerCoordinator = downloadManagerCoordinator;
            this.listenerCoordinator = listenerCoordinator;
            this.downloadBlockHandlerWrapper = downloadBlockHandlerWrapper;
        }

        @NotNull
        public final HandlerWrapper component1() {
            return this.handlerWrapper;
        }

        @NotNull
        public final DatabaseManager component2() {
            return this.databaseManager;
        }

        @NotNull
        public final DownloadManagerCoordinator component3() {
            return this.downloadManagerCoordinator;
        }

        @NotNull
        public final ListenerCoordinator component4() {
            return this.listenerCoordinator;
        }

        @NotNull
        public final HandlerWrapper component5() {
            return this.downloadBlockHandlerWrapper;
        }

        @NotNull
        public final Holder copy(@NotNull HandlerWrapper handlerWrapper, @NotNull DatabaseManager databaseManager, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator, @NotNull HandlerWrapper downloadBlockHandlerWrapper) {
            Intrinsics.checkParameterIsNotNull((Object)handlerWrapper, (String)"handlerWrapper");
            Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
            Intrinsics.checkParameterIsNotNull((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
            Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
            Intrinsics.checkParameterIsNotNull((Object)downloadBlockHandlerWrapper, (String)"downloadBlockHandlerWrapper");
            return new Holder(handlerWrapper, databaseManager, downloadManagerCoordinator, listenerCoordinator, downloadBlockHandlerWrapper);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Holder copy$default(Holder holder, HandlerWrapper handlerWrapper, DatabaseManager databaseManager, DownloadManagerCoordinator downloadManagerCoordinator, ListenerCoordinator listenerCoordinator, HandlerWrapper handlerWrapper2, int n, Object object) {
            if ((n & 1) != 0) {
                handlerWrapper = holder.handlerWrapper;
            }
            if ((n & 2) != 0) {
                databaseManager = holder.databaseManager;
            }
            if ((n & 4) != 0) {
                downloadManagerCoordinator = holder.downloadManagerCoordinator;
            }
            if ((n & 8) != 0) {
                listenerCoordinator = holder.listenerCoordinator;
            }
            if ((n & 0x10) != 0) {
                handlerWrapper2 = holder.downloadBlockHandlerWrapper;
            }
            return holder.copy(handlerWrapper, databaseManager, downloadManagerCoordinator, listenerCoordinator, handlerWrapper2);
        }

        public String toString() {
            return "Holder(handlerWrapper=" + this.handlerWrapper + ", databaseManager=" + this.databaseManager + ", downloadManagerCoordinator=" + this.downloadManagerCoordinator + ", listenerCoordinator=" + this.listenerCoordinator + ", downloadBlockHandlerWrapper=" + this.downloadBlockHandlerWrapper + ")";
        }

        public int hashCode() {
            HandlerWrapper handlerWrapper = this.handlerWrapper;
            DatabaseManager databaseManager = this.databaseManager;
            DownloadManagerCoordinator downloadManagerCoordinator = this.downloadManagerCoordinator;
            ListenerCoordinator listenerCoordinator = this.listenerCoordinator;
            HandlerWrapper handlerWrapper2 = this.downloadBlockHandlerWrapper;
            return ((((handlerWrapper != null ? handlerWrapper.hashCode() : 0) * 31 + (databaseManager != null ? databaseManager.hashCode() : 0)) * 31 + (downloadManagerCoordinator != null ? downloadManagerCoordinator.hashCode() : 0)) * 31 + (listenerCoordinator != null ? listenerCoordinator.hashCode() : 0)) * 31 + (handlerWrapper2 != null ? handlerWrapper2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Holder)) break block3;
                    Holder holder = (Holder)object;
                    if (!Intrinsics.areEqual((Object)this.handlerWrapper, (Object)holder.handlerWrapper) || !Intrinsics.areEqual((Object)this.databaseManager, (Object)holder.databaseManager) || !Intrinsics.areEqual((Object)this.downloadManagerCoordinator, (Object)holder.downloadManagerCoordinator) || !Intrinsics.areEqual((Object)this.listenerCoordinator, (Object)holder.listenerCoordinator) || !Intrinsics.areEqual((Object)this.downloadBlockHandlerWrapper, (Object)holder.downloadBlockHandlerWrapper)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Modules;", "", "fetchConfiguration", "Lcom/tonyodev/fetch2/FetchConfiguration;", "handlerWrapper", "Lcom/tonyodev/fetch2core/HandlerWrapper;", "downloadBlockHandlerWrapper", "databaseManager", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "downloadManagerCoordinator", "Lcom/tonyodev/fetch2/fetch/DownloadManagerCoordinator;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "(Lcom/tonyodev/fetch2/FetchConfiguration;Lcom/tonyodev/fetch2core/HandlerWrapper;Lcom/tonyodev/fetch2core/HandlerWrapper;Lcom/tonyodev/fetch2/database/DatabaseManager;Lcom/tonyodev/fetch2/fetch/DownloadManagerCoordinator;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;)V", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "downloadProvider", "Lcom/tonyodev/fetch2/provider/DownloadProvider;", "getFetchConfiguration", "()Lcom/tonyodev/fetch2/FetchConfiguration;", "fetchHandler", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "getFetchHandler", "()Lcom/tonyodev/fetch2/fetch/FetchHandler;", "getHandlerWrapper", "()Lcom/tonyodev/fetch2core/HandlerWrapper;", "getListenerCoordinator", "()Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "priorityListProcessor", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "uiHandler", "Landroid/os/Handler;", "getUiHandler", "()Landroid/os/Handler;", "fetch2_release"})
    public static final class Modules {
        private final DownloadManager downloadManager;
        private final PriorityListProcessor<Download> priorityListProcessor;
        private final DownloadProvider downloadProvider;
        private final DownloadInfoUpdater downloadInfoUpdater;
        private final NetworkInfoProvider networkInfoProvider;
        @NotNull
        private final FetchHandler fetchHandler;
        @NotNull
        private final Handler uiHandler;
        @NotNull
        private final FetchConfiguration fetchConfiguration;
        @NotNull
        private final HandlerWrapper handlerWrapper;
        @NotNull
        private final ListenerCoordinator listenerCoordinator;

        @NotNull
        public final FetchHandler getFetchHandler() {
            return this.fetchHandler;
        }

        @NotNull
        public final Handler getUiHandler() {
            return this.uiHandler;
        }

        @NotNull
        public final FetchConfiguration getFetchConfiguration() {
            return this.fetchConfiguration;
        }

        @NotNull
        public final HandlerWrapper getHandlerWrapper() {
            return this.handlerWrapper;
        }

        @NotNull
        public final ListenerCoordinator getListenerCoordinator() {
            return this.listenerCoordinator;
        }

        public Modules(@NotNull FetchConfiguration fetchConfiguration, @NotNull HandlerWrapper handlerWrapper, @NotNull HandlerWrapper downloadBlockHandlerWrapper, @NotNull DatabaseManager databaseManager, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator) {
            Intrinsics.checkParameterIsNotNull((Object)fetchConfiguration, (String)"fetchConfiguration");
            Intrinsics.checkParameterIsNotNull((Object)handlerWrapper, (String)"handlerWrapper");
            Intrinsics.checkParameterIsNotNull((Object)downloadBlockHandlerWrapper, (String)"downloadBlockHandlerWrapper");
            Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
            Intrinsics.checkParameterIsNotNull((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
            Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
            this.fetchConfiguration = fetchConfiguration;
            this.handlerWrapper = handlerWrapper;
            this.listenerCoordinator = listenerCoordinator;
            this.downloadProvider = new DownloadProvider(databaseManager);
            this.downloadInfoUpdater = new DownloadInfoUpdater(databaseManager);
            this.networkInfoProvider = new NetworkInfoProvider(this.fetchConfiguration.getAppContext());
            this.uiHandler = new Handler(Looper.getMainLooper());
            this.downloadManager = new DownloadManagerImpl(this.fetchConfiguration.getHttpDownloader(), this.fetchConfiguration.getConcurrentLimit(), this.fetchConfiguration.getProgressReportingIntervalMillis(), this.fetchConfiguration.getDownloadBufferSizeBytes(), this.fetchConfiguration.getLogger(), this.networkInfoProvider, this.fetchConfiguration.getRetryOnNetworkGain(), this.uiHandler, this.downloadInfoUpdater, FetchCoreUtils.getFileTempDir((Context)this.fetchConfiguration.getAppContext()), downloadManagerCoordinator, this.listenerCoordinator, this.fetchConfiguration.getFileServerDownloader(), this.fetchConfiguration.getMd5CheckingEnabled(), downloadBlockHandlerWrapper);
            this.priorityListProcessor = new PriorityListProcessorImpl(this.handlerWrapper, this.downloadProvider, this.downloadManager, this.networkInfoProvider, this.fetchConfiguration.getLogger(), this.uiHandler, this.listenerCoordinator);
            this.priorityListProcessor.setGlobalNetworkType(this.fetchConfiguration.getGlobalNetworkType());
            this.fetchHandler = new FetchHandlerImpl(this.fetchConfiguration.getNamespace(), databaseManager, this.downloadManager, this.priorityListProcessor, this.fetchConfiguration.getLogger(), this.fetchConfiguration.getAutoStart(), this.fetchConfiguration.getHttpDownloader(), FetchCoreUtils.getFileTempDir((Context)this.fetchConfiguration.getAppContext()), this.listenerCoordinator, this.uiHandler);
        }
    }
}

