/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Priority;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.helper.PriorityIteratorProcessor;
import com.tonyodev.fetch2.provider.DownloadProvider;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020!H\u0016J\b\u0010$\u001a\u00020!H\u0016J\b\u0010%\u001a\u00020!H\u0016J\b\u0010&\u001a\u00020!H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/tonyodev/fetch2/helper/PriorityIteratorProcessorImpl;", "Lcom/tonyodev/fetch2/helper/PriorityIteratorProcessor;", "Lcom/tonyodev/fetch2/Download;", "handler", "Landroid/os/Handler;", "downloadProvider", "Lcom/tonyodev/fetch2/provider/DownloadProvider;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "logger", "Lcom/tonyodev/fetch2/Logger;", "(Landroid/os/Handler;Lcom/tonyodev/fetch2/provider/DownloadProvider;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;Lcom/tonyodev/fetch2/Logger;)V", "globalNetworkType", "Lcom/tonyodev/fetch2/NetworkType;", "getGlobalNetworkType", "()Lcom/tonyodev/fetch2/NetworkType;", "setGlobalNetworkType", "(Lcom/tonyodev/fetch2/NetworkType;)V", "isPaused", "", "()Z", "isStopped", "lock", "Ljava/lang/Object;", "paused", "priorityIteratorRunnable", "Ljava/lang/Runnable;", "stopped", "getPriorityIterator", "", "pause", "", "registerPriorityIterator", "resume", "start", "stop", "unregisterPriorityIterator", "fetch2_release"})
public final class PriorityIteratorProcessorImpl
implements PriorityIteratorProcessor<Download> {
    private final Object lock;
    @NotNull
    private volatile NetworkType globalNetworkType;
    private volatile boolean paused;
    private volatile boolean stopped;
    private final Runnable priorityIteratorRunnable;
    private final Handler handler;
    private final DownloadProvider downloadProvider;
    private final DownloadManager downloadManager;
    private final NetworkInfoProvider networkInfoProvider;
    private final Logger logger;

    @Override
    @NotNull
    public NetworkType getGlobalNetworkType() {
        return this.globalNetworkType;
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"<set-?>");
        this.globalNetworkType = networkType;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.stopped = false;
            this.paused = false;
            this.registerPriorityIterator();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.unregisterPriorityIterator();
            this.paused = false;
            this.stopped = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.unregisterPriorityIterator();
            this.paused = true;
            this.stopped = false;
            this.downloadManager.cancelAll();
            this.logger.d("PriorityIterator paused");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.stopped = false;
            this.registerPriorityIterator();
            this.logger.d("PriorityIterator resumed");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<Download> getPriorityIterator() {
        Object object = this.lock;
        synchronized (object) {
            List lowPriorityList;
            Comparator comparator;
            List normalPriorityList;
            List list;
            List list2;
            Object element$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            List<Download> queuedStatusList = this.downloadProvider.getByStatus(Status.QUEUED);
            Iterable iterable = $receiver$iv = (Iterable)queuedStatusList;
            Object destination$iv$iv = new LinkedHashMap();
            Object object2 = $receiver$iv$iv.iterator();
            while (object2.hasNext()) {
                Object object3;
                Object $receiver$iv$iv$iv = destination$iv$iv;
                element$iv$iv = object2.next();
                Download it = (Download)element$iv$iv;
                Priority key$iv$iv = it.getPriority();
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get((Object)key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            Map mapper = destination$iv$iv;
            List queue = new ArrayList();
            List highPriorityList = (List)mapper.get((Object)Priority.HIGH);
            if (highPriorityList != null) {
                void $receiver$iv2;
                destination$iv$iv = highPriorityList;
                list2 = queue;
                object2 = $receiver$iv2;
                element$iv$iv = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        Download it = (Download)a;
                        Comparable comparable = Long.valueOf(it.getCreated());
                        it = (Download)b;
                        Comparable comparable2 = comparable;
                        Long l = it.getCreated();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                };
                list = CollectionsKt.sortedWith((Iterable)object2, element$iv$iv);
                list2.addAll(list);
            }
            if ((normalPriorityList = (List)mapper.get((Object)Priority.NORMAL)) != null) {
                void $receiver$iv3;
                object2 = normalPriorityList;
                list2 = queue;
                element$iv$iv = $receiver$iv3;
                comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        Download it = (Download)a;
                        Comparable comparable = Long.valueOf(it.getCreated());
                        it = (Download)b;
                        Comparable comparable2 = comparable;
                        Long l = it.getCreated();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                };
                list = CollectionsKt.sortedWith(element$iv$iv, (Comparator)comparator);
                list2.addAll(list);
            }
            if ((lowPriorityList = (List)mapper.get((Object)Priority.LOW)) != null) {
                void $receiver$iv4;
                element$iv$iv = lowPriorityList;
                list2 = queue;
                comparator = $receiver$iv4;
                Comparator comparator2 = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        Download it = (Download)a;
                        Comparable comparable = Long.valueOf(it.getCreated());
                        it = (Download)b;
                        Comparable comparable2 = comparable;
                        Long l = it.getCreated();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                };
                list = CollectionsKt.sortedWith((Iterable)((Object)comparator), (Comparator)comparator2);
                list2.addAll(list);
            }
            Iterator<Download> iterator = queue.iterator();
            return iterator;
        }
    }

    private final void registerPriorityIterator() {
        this.handler.postDelayed(this.priorityIteratorRunnable, 500L);
    }

    private final void unregisterPriorityIterator() {
        this.handler.removeCallbacks(this.priorityIteratorRunnable);
    }

    public PriorityIteratorProcessorImpl(@NotNull Handler handler, @NotNull DownloadProvider downloadProvider, @NotNull DownloadManager downloadManager, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)downloadProvider, (String)"downloadProvider");
        Intrinsics.checkParameterIsNotNull((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.handler = handler;
        this.downloadProvider = downloadProvider;
        this.downloadManager = downloadManager;
        this.networkInfoProvider = networkInfoProvider;
        this.logger = logger;
        this.lock = new Object();
        this.globalNetworkType = NetworkType.GLOBAL_OFF;
        this.priorityIteratorRunnable = new Runnable(this){
            final /* synthetic */ PriorityIteratorProcessorImpl this$0;

            public final void run() {
                if (PriorityIteratorProcessorImpl.access$getNetworkInfoProvider$p(this.this$0).isNetworkAvailable()) {
                    Iterator<Download> iterator = this.this$0.getPriorityIterator();
                    while (iterator.hasNext() && PriorityIteratorProcessorImpl.access$getDownloadManager$p(this.this$0).canAccommodateNewDownload()) {
                        NetworkType networkType;
                        Download download = iterator.next();
                        NetworkType networkType2 = Intrinsics.areEqual((Object)((Object)this.this$0.getGlobalNetworkType()), (Object)((Object)NetworkType.GLOBAL_OFF)) ^ true ? this.this$0.getGlobalNetworkType() : (networkType = Intrinsics.areEqual((Object)((Object)download.getNetworkType()), (Object)((Object)NetworkType.GLOBAL_OFF)) ? NetworkType.ALL : download.getNetworkType());
                        if (!PriorityIteratorProcessorImpl.access$getNetworkInfoProvider$p(this.this$0).isOnAllowedNetwork(networkType)) continue;
                        PriorityIteratorProcessorImpl.access$getDownloadManager$p(this.this$0).start(download);
                    }
                }
                PriorityIteratorProcessorImpl.access$registerPriorityIterator(this.this$0);
            }
            {
                this.this$0 = priorityIteratorProcessorImpl;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ NetworkInfoProvider access$getNetworkInfoProvider$p(PriorityIteratorProcessorImpl $this) {
        return $this.networkInfoProvider;
    }

    @NotNull
    public static final /* synthetic */ DownloadManager access$getDownloadManager$p(PriorityIteratorProcessorImpl $this) {
        return $this.downloadManager;
    }

    public static final /* synthetic */ void access$registerPriorityIterator(PriorityIteratorProcessorImpl $this) {
        $this.registerPriorityIterator();
    }
}

