/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Downloader;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.AverageCalculator;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010.\u001a\u00020\u0007H\u0002J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u0002042\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0015\"\u0004\b'\u0010\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0015\"\u0004\b,\u0010\u0017R\u000e\u0010-\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/tonyodev/fetch2/downloader/FileDownloaderImpl;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "initialDownload", "Lcom/tonyodev/fetch2/Download;", "downloader", "Lcom/tonyodev/fetch2/Downloader;", "progressReportingIntervalMillis", "", "downloadBufferSizeBytes", "", "logger", "Lcom/tonyodev/fetch2/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "(Lcom/tonyodev/fetch2/Download;Lcom/tonyodev/fetch2/Downloader;JILcom/tonyodev/fetch2/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;Z)V", "averageDownloadedBytesPerSecond", "", "completedDownload", "getCompletedDownload", "()Z", "setCompletedDownload", "(Z)V", "delegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;)V", "download", "getDownload", "()Lcom/tonyodev/fetch2/Download;", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "downloaded", "estimatedTimeRemainingInMilliseconds", "interrupted", "getInterrupted", "setInterrupted", "movingAverageCalculator", "Lcom/tonyodev/fetch2/util/AverageCalculator;", "terminated", "getTerminated", "setTerminated", "total", "getAverageDownloadedBytesPerSecond", "getFile", "Ljava/io/File;", "getRequest", "Lcom/tonyodev/fetch2/Downloader$Request;", "run", "", "writeToOutput", "input", "Ljava/io/BufferedInputStream;", "output", "Ljava/io/RandomAccessFile;", "fetch2_release"})
public final class FileDownloaderImpl
implements FileDownloader {
    private volatile boolean interrupted;
    private volatile boolean terminated;
    private volatile boolean completedDownload;
    @Nullable
    private FileDownloader.Delegate delegate;
    private long total;
    private long downloaded;
    private long estimatedTimeRemainingInMilliseconds;
    private DownloadInfo downloadInfo;
    private double averageDownloadedBytesPerSecond;
    private final AverageCalculator movingAverageCalculator;
    private final Download initialDownload;
    private final Downloader downloader;
    private final long progressReportingIntervalMillis;
    private final int downloadBufferSizeBytes;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    @Override
    public boolean getTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated(boolean bl) {
        this.terminated = bl;
    }

    @Override
    public boolean getCompletedDownload() {
        return this.completedDownload;
    }

    @Override
    public void setCompletedDownload(boolean bl) {
        this.completedDownload = bl;
    }

    @Override
    @Nullable
    public FileDownloader.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FileDownloader.Delegate delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Download getDownload() {
        this.downloadInfo.setDownloaded(this.downloaded);
        this.downloadInfo.setTotal(this.total);
        return this.downloadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block42: {
            RandomAccessFile output = null;
            BufferedInputStream input = null;
            Downloader.Response response = null;
            try {
                File file = this.getFile();
                this.downloaded = file.length();
                if (!this.getInterrupted()) {
                    boolean isResponseSuccessful;
                    Downloader.Response response2 = response = this.downloader.execute(this.getRequest());
                    boolean bl = isResponseSuccessful = response2 != null ? response2.isSuccessful() : false;
                    if (!this.getInterrupted() && response != null && isResponseSuccessful) {
                        this.total = response.getContentLength() == (long)-1 ? -1L : this.downloaded + response.getContentLength();
                        output = new RandomAccessFile(file, "rw");
                        if (response.getCode() == 206) {
                            output.seek(this.downloaded);
                            this.logger.d("FileDownloader resuming Download " + this.getDownload());
                        } else {
                            output.seek(0L);
                            this.logger.d("FileDownloader starting Download " + this.getDownload());
                        }
                        if (!this.getInterrupted()) {
                            input = new BufferedInputStream(response.getByteStream(), this.downloadBufferSizeBytes);
                            this.downloadInfo.setDownloaded(this.downloaded);
                            this.downloadInfo.setTotal(this.total);
                            FileDownloader.Delegate delegate = this.getDelegate();
                            if (delegate != null) {
                                delegate.onStarted(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                            }
                            this.writeToOutput(input, output);
                        }
                    } else {
                        if (response == null) {
                            throw (Throwable)new FetchException("empty_response_body", FetchException.Code.EMPTY_RESPONSE_BODY);
                        }
                        if (!isResponseSuccessful) {
                            throw (Throwable)new FetchException("request_not_successful", FetchException.Code.REQUEST_NOT_SUCCESSFUL);
                        }
                        throw (Throwable)new FetchException("unknown", FetchException.Code.UNKNOWN);
                    }
                }
                if (!this.getCompletedDownload()) {
                    this.downloadInfo.setDownloaded(this.downloaded);
                    this.downloadInfo.setTotal(this.total);
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                    }
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", e);
                if (this.getInterrupted()) break block42;
                Error error = FetchErrorUtils.getErrorFromMessage(e.getMessage());
                if (this.retryOnNetworkGain) {
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException e2) {
                        this.logger.e("FileDownloader", e2);
                    }
                    if (!this.networkInfoProvider.isNetworkAvailable()) {
                        error = Error.NO_NETWORK_CONNECTION;
                    }
                }
                this.downloadInfo.setDownloaded(this.downloaded);
                this.downloadInfo.setTotal(this.total);
                this.downloadInfo.setError(error);
                FileDownloader.Delegate delegate = this.getDelegate();
                if (delegate != null) {
                    delegate.onError(this.downloadInfo);
                }
            }
            finally {
                try {
                    RandomAccessFile randomAccessFile = output;
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", e);
                }
                try {
                    BufferedInputStream bufferedInputStream = input;
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", e);
                }
                if (response != null) {
                    try {
                        this.downloader.disconnect(response);
                    }
                    catch (Exception e) {
                        this.logger.e("FileDownloader", e);
                    }
                }
                this.setTerminated(true);
            }
        }
    }

    private final void writeToOutput(BufferedInputStream input, RandomAccessFile output) {
        block6: {
            long downloadedBytesPerSecond = this.downloaded;
            byte[] buffer = new byte[this.downloadBufferSizeBytes];
            long reportingStartTime = System.nanoTime();
            long downloadSpeedStartTime = System.nanoTime();
            int read = input.read(buffer, 0, this.downloadBufferSizeBytes);
            while (!this.getInterrupted() && read != -1) {
                long reportingStopTime;
                boolean hasReportingTimeElapsed;
                output.write(buffer, 0, read);
                this.downloaded += (long)read;
                long downloadSpeedStopTime = System.nanoTime();
                boolean downloadSpeedCheckTimeElapsed = FetchUtils.hasIntervalTimeElapsed(downloadSpeedStartTime, downloadSpeedStopTime, 1000L);
                if (downloadSpeedCheckTimeElapsed) {
                    downloadedBytesPerSecond = this.downloaded - downloadedBytesPerSecond;
                    this.movingAverageCalculator.add(downloadedBytesPerSecond);
                    this.averageDownloadedBytesPerSecond = AverageCalculator.getMovingAverageWithWeightOnRecentValues$default(this.movingAverageCalculator, 0, 1, null);
                    this.estimatedTimeRemainingInMilliseconds = FetchUtils.calculateEstimatedTimeRemainingInMilliseconds(this.downloaded, this.total, this.getAverageDownloadedBytesPerSecond());
                    downloadedBytesPerSecond = this.downloaded;
                }
                if (hasReportingTimeElapsed = FetchUtils.hasIntervalTimeElapsed(reportingStartTime, reportingStopTime = System.nanoTime(), this.progressReportingIntervalMillis)) {
                    this.downloadInfo.setDownloaded(this.downloaded);
                    this.downloadInfo.setTotal(this.total);
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                    }
                    reportingStartTime = System.nanoTime();
                }
                if (downloadSpeedCheckTimeElapsed) {
                    downloadSpeedStartTime = System.nanoTime();
                }
                read = input.read(buffer, 0, this.downloadBufferSizeBytes);
            }
            if (read != -1 || this.getInterrupted()) break block6;
            this.total = this.downloaded;
            this.setCompletedDownload(true);
            this.downloadInfo.setDownloaded(this.downloaded);
            this.downloadInfo.setTotal(this.total);
            FileDownloader.Delegate delegate = this.getDelegate();
            if (delegate != null) {
                delegate.onComplete(this.downloadInfo);
            }
        }
    }

    private final File getFile() {
        File file = new File(this.initialDownload.getFile());
        if (!file.exists()) {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                if (file.getParentFile().mkdirs()) {
                    file.createNewFile();
                    this.logger.d("FileDownloader download file " + file.getAbsolutePath() + " created");
                }
            } else {
                file.createNewFile();
                this.logger.d("FileDownloader download file " + file.getAbsolutePath() + " created");
            }
        }
        return file;
    }

    private final Downloader.Request getRequest() {
        Map headers;
        Map map = headers = MapsKt.toMutableMap(this.initialDownload.getHeaders());
        String string = "Range";
        String string2 = "bytes=" + this.downloaded + '-';
        map.put(string, string2);
        return new Downloader.Request(this.initialDownload.getUrl(), headers);
    }

    private final long getAverageDownloadedBytesPerSecond() {
        if (this.averageDownloadedBytesPerSecond < 1.0) {
            return 0L;
        }
        double d = this.averageDownloadedBytesPerSecond;
        return (long)Math.ceil(d);
    }

    public FileDownloaderImpl(@NotNull Download initialDownload, @NotNull Downloader downloader, long progressReportingIntervalMillis, int downloadBufferSizeBytes, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain) {
        Intrinsics.checkParameterIsNotNull((Object)initialDownload, (String)"initialDownload");
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        this.initialDownload = initialDownload;
        this.downloader = downloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.downloadBufferSizeBytes = downloadBufferSizeBytes;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.estimatedTimeRemainingInMilliseconds = -1L;
        this.downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(this.initialDownload);
        this.movingAverageCalculator = new AverageCalculator(5);
    }
}

