/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.database;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Priority;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010K\u001a\u00020\u0001H\u0016J\u0013\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010OH\u0096\u0002J\b\u0010P\u001a\u00020\u0019H\u0016J\b\u0010Q\u001a\u00020\u0013H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\r8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00138\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00198\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR*\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u001f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001e\u0010$\u001a\u00020\u00198\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001b\"\u0004\b&\u0010\u001dR\u001e\u0010'\u001a\u00020\u00138\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0015\"\u0004\b)\u0010\u0017R\u001e\u0010*\u001a\u00020+8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001e\u00100\u001a\u0002018\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u00106\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u001bR\u0014\u00108\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u001e\u0010<\u001a\u00020=8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR \u0010B\u001a\u0004\u0018\u00010\u00138\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0015\"\u0004\bD\u0010\u0017R\u001e\u0010E\u001a\u00020\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\u0006\"\u0004\bG\u0010\bR\u001e\u0010H\u001a\u00020\u00138\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\u0015\"\u0004\bJ\u0010\u0017\u00a8\u0006R"}, d2={"Lcom/tonyodev/fetch2/database/DownloadInfo;", "Lcom/tonyodev/fetch2/Download;", "()V", "created", "", "getCreated", "()J", "setCreated", "(J)V", "downloaded", "getDownloaded", "setDownloaded", "error", "Lcom/tonyodev/fetch2/Error;", "getError", "()Lcom/tonyodev/fetch2/Error;", "setError", "(Lcom/tonyodev/fetch2/Error;)V", "file", "", "getFile", "()Ljava/lang/String;", "setFile", "(Ljava/lang/String;)V", "group", "", "getGroup", "()I", "setGroup", "(I)V", "headers", "", "getHeaders", "()Ljava/util/Map;", "setHeaders", "(Ljava/util/Map;)V", "id", "getId", "setId", "namespace", "getNamespace", "setNamespace", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "getNetworkType", "()Lcom/tonyodev/fetch2/NetworkType;", "setNetworkType", "(Lcom/tonyodev/fetch2/NetworkType;)V", "priority", "Lcom/tonyodev/fetch2/Priority;", "getPriority", "()Lcom/tonyodev/fetch2/Priority;", "setPriority", "(Lcom/tonyodev/fetch2/Priority;)V", "progress", "getProgress", "request", "Lcom/tonyodev/fetch2/Request;", "getRequest", "()Lcom/tonyodev/fetch2/Request;", "status", "Lcom/tonyodev/fetch2/Status;", "getStatus", "()Lcom/tonyodev/fetch2/Status;", "setStatus", "(Lcom/tonyodev/fetch2/Status;)V", "tag", "getTag", "setTag", "total", "getTotal", "setTotal", "url", "getUrl", "setUrl", "copy", "equals", "", "other", "", "hashCode", "toString", "fetch2_release"})
@Entity(tableName="requests", indices={@Index(unique=true, value={"_file"}), @Index(unique=false, value={"_group", "_status"})})
public final class DownloadInfo
implements Download {
    @PrimaryKey
    @ColumnInfo(name="_id")
    private int id;
    @ColumnInfo(name="_namespace")
    @NotNull
    private String namespace = "";
    @ColumnInfo(name="_url")
    @NotNull
    private String url = "";
    @ColumnInfo(name="_file")
    @NotNull
    private String file = "";
    @ColumnInfo(name="_group")
    private int group;
    @ColumnInfo(name="_priority")
    @NotNull
    private Priority priority = FetchDefaults.getDefaultPriority();
    @ColumnInfo(name="_headers")
    @NotNull
    private Map<String, String> headers = FetchDefaults.getDefaultEmptyHeaderMap();
    @ColumnInfo(name="_written_bytes")
    private long downloaded;
    @ColumnInfo(name="_total_bytes")
    private long total = -1L;
    @ColumnInfo(name="_status")
    @NotNull
    private Status status = FetchDefaults.getDefaultStatus();
    @ColumnInfo(name="_error")
    @NotNull
    private Error error = FetchDefaults.getDefaultNoError();
    @ColumnInfo(name="_network_type")
    @NotNull
    private NetworkType networkType = FetchDefaults.getDefaultNetworkType();
    @ColumnInfo(name="_created")
    private long created = System.nanoTime();
    @ColumnInfo(name="_tag")
    @Nullable
    private String tag;

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.namespace = string;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @Override
    @NotNull
    public String getFile() {
        return this.file;
    }

    public void setFile(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.file = string;
    }

    @Override
    public int getGroup() {
        return this.group;
    }

    public void setGroup(int n) {
        this.group = n;
    }

    @Override
    @NotNull
    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(@NotNull Priority priority) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)priority), (String)"<set-?>");
        this.priority = priority;
    }

    @Override
    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(@NotNull Map<String, String> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.headers = map;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    public void setDownloaded(long l) {
        this.downloaded = l;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    public void setTotal(long l) {
        this.total = l;
    }

    @Override
    @NotNull
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"<set-?>");
        this.status = status;
    }

    @Override
    @NotNull
    public Error getError() {
        return this.error;
    }

    public void setError(@NotNull Error error) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)error), (String)"<set-?>");
        this.error = error;
    }

    @Override
    @NotNull
    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"<set-?>");
        this.networkType = networkType;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public void setCreated(long l) {
        this.created = l;
    }

    @Override
    @Nullable
    public String getTag() {
        return this.tag;
    }

    public void setTag(@Nullable String string) {
        this.tag = string;
    }

    @Override
    public int getProgress() {
        return FetchUtils.calculateProgress(this.getDownloaded(), this.getTotal());
    }

    @Override
    @NotNull
    public Request getRequest() {
        Request request = new Request(this.getId(), this.getUrl(), this.getFile());
        request.setGroupId(this.getGroup());
        request.getHeaders().putAll(this.getHeaders());
        request.setNetworkType(this.getNetworkType());
        request.setPriority(this.getPriority());
        return request;
    }

    @Override
    @NotNull
    public Download copy() {
        return FetchTypeConverterExtensions.toDownloadInfo(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.tonyodev.fetch2.database.DownloadInfo");
        }
        DownloadInfo cfr_ignored_0 = (DownloadInfo)object2;
        if (this.getId() != ((DownloadInfo)other).getId()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getNamespace(), (Object)((DownloadInfo)other).getNamespace()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getUrl(), (Object)((DownloadInfo)other).getUrl()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getFile(), (Object)((DownloadInfo)other).getFile()) ^ true) {
            return false;
        }
        if (this.getGroup() != ((DownloadInfo)other).getGroup()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((Object)this.getPriority()), (Object)((Object)((DownloadInfo)other).getPriority())) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.getHeaders(), ((DownloadInfo)other).getHeaders()) ^ true) {
            return false;
        }
        if (this.getDownloaded() != ((DownloadInfo)other).getDownloaded()) {
            return false;
        }
        if (this.getTotal() != ((DownloadInfo)other).getTotal()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((Object)this.getStatus()), (Object)((Object)((DownloadInfo)other).getStatus())) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((Object)this.getError()), (Object)((Object)((DownloadInfo)other).getError())) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((Object)this.getNetworkType()), (Object)((Object)((DownloadInfo)other).getNetworkType())) ^ true) {
            return false;
        }
        if (this.getCreated() != ((DownloadInfo)other).getCreated()) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.getTag(), (Object)((DownloadInfo)other).getTag()) ^ true);
    }

    public int hashCode() {
        int result = this.getId();
        result = 31 * result + this.getNamespace().hashCode();
        result = 31 * result + this.getUrl().hashCode();
        result = 31 * result + this.getFile().hashCode();
        result = 31 * result + this.getGroup();
        result = 31 * result + this.getPriority().hashCode();
        result = 31 * result + ((Object)this.getHeaders()).hashCode();
        result = 31 * result + ((Object)this.getDownloaded()).hashCode();
        result = 31 * result + ((Object)this.getTotal()).hashCode();
        result = 31 * result + this.getStatus().hashCode();
        result = 31 * result + this.getError().hashCode();
        result = 31 * result + this.getNetworkType().hashCode();
        result = 31 * result + ((Object)this.getCreated()).hashCode();
        String string = this.getTag();
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return "Download(id=" + this.getId() + ", namespace='" + this.getNamespace() + "', url='" + this.getUrl() + "', file='" + this.getFile() + "', group=" + this.getGroup() + ',' + " priority=" + (Object)((Object)this.getPriority()) + ", headers=" + this.getHeaders() + ", downloaded=" + this.getDownloaded() + ", total=" + this.getTotal() + ", status=" + (Object)((Object)this.getStatus()) + ',' + " error=" + (Object)((Object)this.getError()) + ", networkType=" + (Object)((Object)this.getNetworkType()) + ", created=" + this.getCreated() + ", tag=" + this.getTag() + ')';
    }
}

