/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.os.Build;
import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.RequestInfo;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.fetch.FetchModulesBuilder;
import com.tonyodev.fetch2.helper.PriorityIteratorProcessor;
import com.tonyodev.fetch2.provider.ListenerProvider;
import com.tonyodev.fetch2.util.FetchDatabaseExtensions;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0)H\u0016J\u0010\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/H\u0016J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00101\u001a\u00020%H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\n0)H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020\u0013H\u0016J\u0010\u00107\u001a\u00020\n2\u0006\u00108\u001a\u000209H\u0016J\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\n0)2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002090)H\u0016J\b\u0010;\u001a\u00020%H\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010\n2\u0006\u0010.\u001a\u00020/H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0)H\u0016J\u001c\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0)2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020/0)H\u0016J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010.\u001a\u00020/H\u0016J\u001e\u0010@\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010A\u001a\u00020/2\u0006\u0010B\u001a\u00020CH\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010E\u001a\u00020%H\u0016J\u0010\u0010F\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/H\u0016J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010*\u001a\u00020+H\u0016J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010.\u001a\u00020/H\u0016J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010J\u001a\b\u0012\u0004\u0012\u00020\n0)H\u0016J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u0010L\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010*\u001a\u00020+H\u0016J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010.\u001a\u00020/H\u0016J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010P\u001a\u00020%2\u0006\u0010Q\u001a\u00020RH\u0016J\b\u0010S\u001a\u00020%H\u0016J\b\u0010T\u001a\u00020%H\u0016J\u001a\u0010U\u001a\u0004\u0018\u00010\n2\u0006\u0010.\u001a\u00020/2\u0006\u0010V\u001a\u00020WH\u0016R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006X"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchHandlerImpl;", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "namespace", "", "databaseManager", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "priorityIteratorProcessor", "Lcom/tonyodev/fetch2/helper/PriorityIteratorProcessor;", "Lcom/tonyodev/fetch2/Download;", "fetchListenerProvider", "Lcom/tonyodev/fetch2/provider/ListenerProvider;", "handler", "Landroid/os/Handler;", "logger", "Lcom/tonyodev/fetch2/Logger;", "(Ljava/lang/String;Lcom/tonyodev/fetch2/database/DatabaseManager;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/helper/PriorityIteratorProcessor;Lcom/tonyodev/fetch2/provider/ListenerProvider;Landroid/os/Handler;Lcom/tonyodev/fetch2/Logger;)V", "closed", "", "getDatabaseManager", "()Lcom/tonyodev/fetch2/database/DatabaseManager;", "getDownloadManager", "()Lcom/tonyodev/fetch2/downloader/DownloadManager;", "getFetchListenerProvider", "()Lcom/tonyodev/fetch2/provider/ListenerProvider;", "getHandler", "()Landroid/os/Handler;", "isClosed", "()Z", "getLogger", "()Lcom/tonyodev/fetch2/Logger;", "getNamespace", "()Ljava/lang/String;", "getPriorityIteratorProcessor", "()Lcom/tonyodev/fetch2/helper/PriorityIteratorProcessor;", "addListener", "", "listener", "Lcom/tonyodev/fetch2/FetchListener;", "cancel", "", "ids", "", "cancelAll", "cancelDownload", "id", "", "cancelGroup", "close", "delete", "deleteAll", "deleteGroup", "enableLogging", "enabled", "enqueue", "request", "Lcom/tonyodev/fetch2/Request;", "requests", "freeze", "getDownload", "getDownloads", "idList", "getDownloadsInGroup", "getDownloadsInGroupWithStatus", "groupId", "status", "Lcom/tonyodev/fetch2/Status;", "getDownloadsWithStatus", "init", "isDownloading", "pause", "pausedGroup", "remove", "removeAll", "removeGroup", "removeListener", "resume", "resumeGroup", "retry", "setGlobalNetworkType", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "throwExceptionIfClosed", "unfreeze", "updateRequest", "requestInfo", "Lcom/tonyodev/fetch2/RequestInfo;", "fetch2_release"})
public class FetchHandlerImpl
implements FetchHandler {
    private volatile boolean closed;
    @NotNull
    private final String namespace;
    @NotNull
    private final DatabaseManager databaseManager;
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final PriorityIteratorProcessor<Download> priorityIteratorProcessor;
    @NotNull
    private final ListenerProvider fetchListenerProvider;
    @NotNull
    private final Handler handler;
    @NotNull
    private final Logger logger;

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void init() {
        FetchDatabaseExtensions.verifyDatabase(this.databaseManager);
        this.priorityIteratorProcessor.start();
    }

    @Override
    @NotNull
    public Download enqueue(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        this.throwExceptionIfClosed();
        DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(request);
        downloadInfo.setNamespace(this.namespace);
        downloadInfo.setStatus(Status.QUEUED);
        this.databaseManager.insert(downloadInfo);
        return downloadInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> enqueue(@NotNull List<? extends Request> requests) {
        Pair it;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(requests, (String)"requests");
        this.throwExceptionIfClosed();
        Iterable iterable = $receiver$iv = (Iterable)requests;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Request request = (Request)item$iv$iv;
            Collection collection = destination$iv$iv;
            DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo((Request)it);
            downloadInfo.setNamespace(this.namespace);
            downloadInfo.setStatus(Status.QUEUED);
            DownloadInfo downloadInfo2 = downloadInfo;
            collection.add(downloadInfo2);
        }
        List downloadInfoList = (List)destination$iv$iv;
        List results = new ArrayList();
        List<Pair<DownloadInfo, Boolean>> insertedList = this.databaseManager.insert(downloadInfoList);
        Iterable $receiver$iv2 = insertedList;
        for (Object element$iv : $receiver$iv2) {
            it = (Pair)element$iv;
            if (!((Boolean)it.getSecond()).booleanValue()) continue;
            this.logger.d("Enqueued download " + (DownloadInfo)it.getFirst());
            results.add(it.getFirst());
        }
        return results;
    }

    @Override
    @NotNull
    public List<Download> pause(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.throwExceptionIfClosed();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadsInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canPauseDownload(it)) continue;
            it.setStatus(Status.PAUSED);
        }
        try {
            this.databaseManager.update(downloadsInfoList);
            list = downloadsInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> pausedGroup(int id) {
        List list;
        DownloadInfo it;
        this.throwExceptionIfClosed();
        List downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        downloadInfoList = this.databaseManager.getByGroup(id);
        $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!FetchUtils.canPauseDownload(it)) continue;
            it.setStatus(Status.PAUSED);
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public void freeze() {
        this.throwExceptionIfClosed();
        this.downloadManager.cancelAll();
        this.priorityIteratorProcessor.pause();
        FetchDatabaseExtensions.verifyDatabase(this.databaseManager);
    }

    @Override
    public void unfreeze() {
        this.throwExceptionIfClosed();
        FetchDatabaseExtensions.verifyDatabase(this.databaseManager);
        this.priorityIteratorProcessor.resume();
    }

    @Override
    @NotNull
    public List<Download> resume(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.throwExceptionIfClosed();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadsInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (this.isDownloading(it.getId()) || !FetchUtils.canResumeDownload(it)) continue;
            it.setStatus(Status.QUEUED);
        }
        try {
            this.databaseManager.update(downloadsInfoList);
            list = downloadsInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> resumeGroup(int id) {
        List list;
        Iterator $receiver$iv$iv;
        this.throwExceptionIfClosed();
        Iterable $receiver$iv = this.databaseManager.getByGroup(id);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            DownloadInfo it = (DownloadInfo)element$iv$iv;
            if (!(!this.isDownloading(it.getId()) && FetchUtils.canResumeDownload(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List downloadsInfoList = (List)destination$iv$iv;
        $receiver$iv = downloadsInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(Status.QUEUED);
        }
        try {
            this.databaseManager.update(downloadsInfoList);
            list = downloadsInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> remove(@NotNull int[] ids) {
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.throwExceptionIfClosed();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        this.databaseManager.delete(downloadsList);
        Status removedStatus = Status.REMOVED;
        Iterable $receiver$iv = downloadsList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(removedStatus);
        }
        return downloadsList;
    }

    @Override
    @NotNull
    public List<Download> removeGroup(int id) {
        this.throwExceptionIfClosed();
        List<Download> downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        this.databaseManager.delete(downloadInfoList);
        Status removedStatus = Status.REMOVED;
        Iterable $receiver$iv2 = downloadInfoList;
        for (Object element$iv : $receiver$iv2) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(removedStatus);
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> removeAll() {
        this.throwExceptionIfClosed();
        this.downloadManager.cancelAll();
        List<Download> downloadInfoList = this.databaseManager.get();
        this.databaseManager.deleteAll();
        Status removedStatus = Status.REMOVED;
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(removedStatus);
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> delete(@NotNull int[] ids) {
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.throwExceptionIfClosed();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        this.databaseManager.delete(downloadsList);
        Status deletedStatus = Status.DELETED;
        Iterable $receiver$iv = downloadsList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(deletedStatus);
            try {
                File file = new File(it.getFile());
                if (!file.exists()) continue;
                file.delete();
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), e);
            }
        }
        return downloadsList;
    }

    @Override
    @NotNull
    public List<Download> deleteGroup(int id) {
        this.throwExceptionIfClosed();
        List<Download> downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        this.databaseManager.delete(downloadInfoList);
        Status deletedStatus = Status.DELETED;
        Iterable $receiver$iv2 = downloadInfoList;
        for (Object element$iv : $receiver$iv2) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(deletedStatus);
            try {
                File file = new File(it.getFile());
                if (!file.exists()) continue;
                file.delete();
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), e);
            }
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> deleteAll() {
        this.throwExceptionIfClosed();
        this.downloadManager.cancelAll();
        List<Download> downloadInfoList = this.databaseManager.get();
        this.databaseManager.deleteAll();
        Status deletedStatus = Status.DELETED;
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(deletedStatus);
            try {
                File file = new File(it.getFile());
                if (!file.exists()) continue;
                file.delete();
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), e);
            }
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> cancel(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.throwExceptionIfClosed();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> cancelGroup(int id) {
        List list;
        DownloadInfo it;
        this.throwExceptionIfClosed();
        List downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.downloadManager.cancel(it.getId());
        }
        downloadInfoList = this.databaseManager.getByGroup(id);
        $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> cancelAll() {
        List list;
        DownloadInfo it;
        this.throwExceptionIfClosed();
        List downloadInfoList = this.databaseManager.get();
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.downloadManager.cancel(it.getId());
        }
        downloadInfoList = this.databaseManager.get();
        $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> retry(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.throwExceptionIfClosed();
        List downloadInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canRetryDownload(it)) continue;
            it.setStatus(Status.QUEUED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Download updateRequest(int id, @NotNull RequestInfo requestInfo) {
        Intrinsics.checkParameterIsNotNull((Object)requestInfo, (String)"requestInfo");
        this.throwExceptionIfClosed();
        DownloadInfo downloadInfo = this.databaseManager.get(id);
        if (downloadInfo != null) {
            if (this.isDownloading(id)) {
                this.cancelDownload(id);
            }
            if ((downloadInfo = this.databaseManager.get(id)) != null) {
                downloadInfo.setGroup(requestInfo.getGroupId());
                downloadInfo.setHeaders(requestInfo.getHeaders());
                downloadInfo.setPriority(requestInfo.getPriority());
                downloadInfo.setNetworkType(requestInfo.getNetworkType());
                this.databaseManager.update(downloadInfo);
                return downloadInfo;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<Download> getDownloads() {
        this.throwExceptionIfClosed();
        return this.databaseManager.get();
    }

    @Override
    @Nullable
    public Download getDownload(int id) {
        this.throwExceptionIfClosed();
        return this.databaseManager.get(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloads(@NotNull List<Integer> idList) {
        Intrinsics.checkParameterIsNotNull(idList, (String)"idList");
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.databaseManager.get(idList);
        List results = new ArrayList();
        Iterable $receiver$iv = CollectionsKt.filterNotNull((Iterable)downloads);
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            results.add(it);
        }
        return results;
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroup(int id) {
        this.throwExceptionIfClosed();
        return this.databaseManager.getByGroup(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.throwExceptionIfClosed();
        return this.databaseManager.getByStatus(status);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroupWithStatus(int groupId, @NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.throwExceptionIfClosed();
        return this.databaseManager.getDownloadsInGroupWithStatus(groupId, status);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.getFetchListenerProvider().getListeners().clear();
        this.priorityIteratorProcessor.stop();
        this.downloadManager.close();
        this.databaseManager.close();
        if (Build.VERSION.SDK_INT >= 18) {
            this.handler.getLooper().quitSafely();
        } else {
            this.handler.getLooper().quit();
        }
        FetchModulesBuilder.INSTANCE.removeActiveFetchHandlerNamespaceInstance(this.namespace);
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"networkType");
        this.throwExceptionIfClosed();
        this.priorityIteratorProcessor.setGlobalNetworkType(networkType);
        this.downloadManager.cancelAll();
        FetchDatabaseExtensions.verifyDatabase(this.databaseManager);
    }

    @Override
    public void enableLogging(boolean enabled) {
        this.throwExceptionIfClosed();
        this.logger.d("Enable logging - " + enabled);
        this.logger.setEnabled(enabled);
    }

    @Override
    public void addListener(@NotNull FetchListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.throwExceptionIfClosed();
        this.getFetchListenerProvider().getListeners().add(listener);
        this.logger.d("Added listener " + listener);
    }

    @Override
    public void removeListener(@NotNull FetchListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.throwExceptionIfClosed();
        Iterator<FetchListener> iterator = this.getFetchListenerProvider().getListeners().iterator();
        while (iterator.hasNext()) {
            if (!Intrinsics.areEqual((Object)iterator.next(), (Object)listener)) continue;
            this.logger.d("Removed listener " + listener);
            iterator.remove();
            break;
        }
    }

    @Override
    public boolean isDownloading(int id) {
        this.throwExceptionIfClosed();
        return this.downloadManager.contains(id);
    }

    @Override
    public boolean cancelDownload(int id) {
        this.throwExceptionIfClosed();
        return this.downloadManager.cancel(id);
    }

    @Override
    public void throwExceptionIfClosed() {
        if (this.closed) {
            throw (Throwable)new FetchException("This fetch instance has been closed. Create a new instance using the builder.", FetchException.Code.CLOSED);
        }
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    @NotNull
    public final DownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    @NotNull
    public final PriorityIteratorProcessor<Download> getPriorityIteratorProcessor() {
        return this.priorityIteratorProcessor;
    }

    @Override
    @NotNull
    public ListenerProvider getFetchListenerProvider() {
        return this.fetchListenerProvider;
    }

    @NotNull
    public final Handler getHandler() {
        return this.handler;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public FetchHandlerImpl(@NotNull String namespace, @NotNull DatabaseManager databaseManager, @NotNull DownloadManager downloadManager, @NotNull PriorityIteratorProcessor<? extends Download> priorityIteratorProcessor, @NotNull ListenerProvider fetchListenerProvider, @NotNull Handler handler, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
        Intrinsics.checkParameterIsNotNull((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkParameterIsNotNull(priorityIteratorProcessor, (String)"priorityIteratorProcessor");
        Intrinsics.checkParameterIsNotNull((Object)fetchListenerProvider, (String)"fetchListenerProvider");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.namespace = namespace;
        this.databaseManager = databaseManager;
        this.downloadManager = downloadManager;
        this.priorityIteratorProcessor = priorityIteratorProcessor;
        this.fetchListenerProvider = fetchListenerProvider;
        this.handler = handler;
        this.logger = logger;
    }
}

