/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Downloader;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.FileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchImplementationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010/\u001a\u00020\rH\u0016J\u0010\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\u0005H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000203H\u0016J\b\u00105\u001a\u000203H\u0016J\u0010\u00106\u001a\u00020\r2\u0006\u00101\u001a\u00020\u0005H\u0016J\b\u00107\u001a\u00020\u0005H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020:09H\u0016J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020:H\u0016J\u0010\u0010=\u001a\u00020\r2\u0006\u0010<\u001a\u00020:H\u0016J\b\u0010>\u001a\u000203H\u0016R\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR0\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0012`\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR\u0012\u0010\u001d\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006?"}, d2={"Lcom/tonyodev/fetch2/downloader/DownloadManagerImpl;", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "downloader", "Lcom/tonyodev/fetch2/Downloader;", "concurrentLimit", "", "progressReportingIntervalMillis", "", "downloadBufferSizeBytes", "logger", "Lcom/tonyodev/fetch2/Logger;", "(Lcom/tonyodev/fetch2/Downloader;IJILcom/tonyodev/fetch2/Logger;)V", "closed", "", "getConcurrentLimit", "()I", "currentDownloadsMapInternal", "Ljava/util/HashMap;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "Lkotlin/collections/HashMap;", "getCurrentDownloadsMapInternal", "()Ljava/util/HashMap;", "delegate", "Lcom/tonyodev/fetch2/downloader/DownloadManager$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/DownloadManager$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/DownloadManager$Delegate;)V", "getDownloadBufferSizeBytes", "downloadCounter", "getDownloader", "()Lcom/tonyodev/fetch2/Downloader;", "executorInternal", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getExecutorInternal", "()Ljava/util/concurrent/ExecutorService;", "isClosed", "()Z", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "getLogger", "()Lcom/tonyodev/fetch2/Logger;", "getProgressReportingIntervalMillis", "()J", "canAccommodateNewDownload", "cancel", "id", "cancelAll", "", "cancelAllDownloadsInternal", "close", "contains", "getActiveDownloadCount", "getDownloads", "", "Lcom/tonyodev/fetch2/Download;", "getNewFileDownloaderForDownload", "download", "start", "throwExceptionIfClosed", "fetch2_release"})
public class DownloadManagerImpl
implements DownloadManager {
    @NotNull
    private final Object lock;
    private final ExecutorService executorInternal;
    @NotNull
    private final HashMap<Integer, FileDownloader> currentDownloadsMapInternal;
    @Nullable
    private DownloadManager.Delegate delegate;
    private volatile int downloadCounter;
    private volatile boolean closed;
    @NotNull
    private final Downloader downloader;
    private final int concurrentLimit;
    private final long progressReportingIntervalMillis;
    private final int downloadBufferSizeBytes;
    @NotNull
    private final Logger logger;

    @NotNull
    public final Object getLock() {
        return this.lock;
    }

    public ExecutorService getExecutorInternal() {
        return this.executorInternal;
    }

    @NotNull
    public HashMap<Integer, FileDownloader> getCurrentDownloadsMapInternal() {
        return this.currentDownloadsMapInternal;
    }

    @Override
    @Nullable
    public DownloadManager.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable DownloadManager.Delegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            block8: {
                block7: {
                    this.throwExceptionIfClosed();
                    if (!this.getCurrentDownloadsMapInternal().containsKey(download.getId())) break block7;
                    this.logger.d("DownloadManager already running download " + download);
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.downloadCounter < this.concurrentLimit) break block8;
                this.logger.d("DownloadManager cannot init download " + download + " because " + "the download queue is full");
                boolean bl3 = false;
                return bl3;
            }
            FileDownloader fileDownloader = this.getNewFileDownloaderForDownload(download);
            fileDownloader.setDelegate(this.getDelegate());
            ++this.downloadCounter;
            Map map = this.getCurrentDownloadsMapInternal();
            Integer n = download.getId();
            FileDownloader fileDownloader2 = fileDownloader;
            map.put(n, fileDownloader2);
            try {
                this.getExecutorInternal().execute(new Runnable(fileDownloader, this, download){
                    final /* synthetic */ FileDownloader $fileDownloader;
                    final /* synthetic */ DownloadManagerImpl this$0;
                    final /* synthetic */ Download $download$inlined;
                    {
                        this.$fileDownloader = fileDownloader;
                        this.this$0 = downloadManagerImpl;
                        this.$download$inlined = download;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        this.this$0.getLogger().d("DownloadManager starting download " + this.$download$inlined);
                        this.$fileDownloader.run();
                        Object object = this.this$0.getLock();
                        synchronized (object) {
                            if (this.this$0.getCurrentDownloadsMapInternal().containsKey(this.$download$inlined.getId())) {
                                this.this$0.getCurrentDownloadsMapInternal().remove(this.$download$inlined.getId());
                                DownloadManagerImpl downloadManagerImpl = this.this$0;
                                DownloadManagerImpl.access$setDownloadCounter$p(downloadManagerImpl, DownloadManagerImpl.access$getDownloadCounter$p(downloadManagerImpl) - 1);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
                bl = true;
            }
            catch (Exception e) {
                this.logger.e("DownloadManager failed to start download " + download, e);
                bl = false;
            }
            boolean bl4 = bl;
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(int id) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            this.throwExceptionIfClosed();
            if (this.getCurrentDownloadsMapInternal().containsKey(id)) {
                FileDownloader fileDownloader = this.getCurrentDownloadsMapInternal().get(id);
                if (fileDownloader == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.tonyodev.fetch2.downloader.FileDownloader");
                }
                FileDownloader fileDownloader2 = fileDownloader;
                fileDownloader2.setInterrupted(true);
                while (!fileDownloader2.getTerminated()) {
                }
                this.getCurrentDownloadsMapInternal().remove(id);
                --this.downloadCounter;
                this.logger.d("DownloadManager cancelled download " + fileDownloader2.getDownload());
                bl = true;
            } else {
                bl = false;
            }
            boolean bl2 = bl;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.cancelAllDownloadsInternal();
            Unit unit = Unit.INSTANCE;
        }
    }

    public void cancelAllDownloadsInternal() {
        Iterator iterator;
        Map map = this.getCurrentDownloadsMapInternal();
        Iterator $receiver$iv = map.entrySet().iterator();
        Iterator iterator2 = iterator = $receiver$iv;
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            ((FileDownloader)it.getValue()).setInterrupted(true);
            while (!((FileDownloader)it.getValue()).getTerminated()) {
            }
            this.logger.d("DownloadManager cancelled download " + ((FileDownloader)it.getValue()).getDownload());
        }
        this.getCurrentDownloadsMapInternal().clear();
        this.downloadCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.logger.d("DownloadManager closing download manager");
            this.cancelAllDownloadsInternal();
            this.getExecutorInternal().shutdown();
            this.downloader.close();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int id) {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            boolean bl = this.getCurrentDownloadsMapInternal().containsKey(id);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAccommodateNewDownload() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            boolean bl = this.downloadCounter < this.concurrentLimit;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveDownloadCount() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            int n = this.downloadCounter;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> getDownloads() {
        Object object = this.lock;
        synchronized (object) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            this.throwExceptionIfClosed();
            Collection<FileDownloader> collection = this.getCurrentDownloadsMapInternal().values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"currentDownloadsMapInternal.values");
            Iterable iterable = $receiver$iv = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                FileDownloader fileDownloader = (FileDownloader)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                Download download = it.getDownload();
                collection2.add(download);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    public void throwExceptionIfClosed() {
        if (this.closed) {
            throw (Throwable)new FetchImplementationException("DownloadManager is already shutdown.", FetchImplementationException.Code.CLOSED);
        }
    }

    @Override
    @NotNull
    public FileDownloader getNewFileDownloaderForDownload(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        return new FileDownloaderImpl(download, this.downloader, this.progressReportingIntervalMillis, this.downloadBufferSizeBytes, this.logger);
    }

    @NotNull
    public final Downloader getDownloader() {
        return this.downloader;
    }

    public final int getConcurrentLimit() {
        return this.concurrentLimit;
    }

    public final long getProgressReportingIntervalMillis() {
        return this.progressReportingIntervalMillis;
    }

    public final int getDownloadBufferSizeBytes() {
        return this.downloadBufferSizeBytes;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public DownloadManagerImpl(@NotNull Downloader downloader, int concurrentLimit, long progressReportingIntervalMillis, int downloadBufferSizeBytes, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.downloader = downloader;
        this.concurrentLimit = concurrentLimit;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.downloadBufferSizeBytes = downloadBufferSizeBytes;
        this.logger = logger;
        this.lock = new Object();
        this.executorInternal = Executors.newFixedThreadPool(this.concurrentLimit);
        DownloadManagerImpl downloadManagerImpl = this;
        HashMap hashMap = new HashMap();
        downloadManagerImpl.currentDownloadsMapInternal = hashMap;
    }

    public static final /* synthetic */ int access$getDownloadCounter$p(DownloadManagerImpl $this) {
        return $this.downloadCounter;
    }

    public static final /* synthetic */ void access$setDownloadCounter$p(DownloadManagerImpl $this, int n) {
        $this.downloadCounter = n;
    }
}

