/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.helper.DownloadPriorityComparator;
import com.tonyodev.fetch2.helper.PriorityQueueProcessor;
import com.tonyodev.fetch2.provider.DownloadProvider;
import com.tonyodev.fetch2.provider.NetworkProvider;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\u000205H\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000207H\u0016J\b\u00109\u001a\u000207H\u0016J\b\u0010:\u001a\u000207H\u0016J\b\u0010;\u001a\u000207H\u0016J\b\u0010<\u001a\u000207H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00138\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0012\u0010&\u001a\u00020\u001b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0012\u00103\u001a\u00020\u001b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/tonyodev/fetch2/helper/PriorityQueueProcessorImpl;", "Lcom/tonyodev/fetch2/helper/PriorityQueueProcessor;", "Lcom/tonyodev/fetch2/Download;", "handler", "Landroid/os/Handler;", "downloadProvider", "Lcom/tonyodev/fetch2/provider/DownloadProvider;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "networkProvider", "Lcom/tonyodev/fetch2/provider/NetworkProvider;", "logger", "Lcom/tonyodev/fetch2/Logger;", "(Landroid/os/Handler;Lcom/tonyodev/fetch2/provider/DownloadProvider;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/provider/NetworkProvider;Lcom/tonyodev/fetch2/Logger;)V", "getDownloadManager", "()Lcom/tonyodev/fetch2/downloader/DownloadManager;", "getDownloadProvider", "()Lcom/tonyodev/fetch2/provider/DownloadProvider;", "globalNetworkType", "Lcom/tonyodev/fetch2/NetworkType;", "getGlobalNetworkType", "()Lcom/tonyodev/fetch2/NetworkType;", "setGlobalNetworkType", "(Lcom/tonyodev/fetch2/NetworkType;)V", "getHandler", "()Landroid/os/Handler;", "isPaused", "", "()Z", "isStopped", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "getLogger", "()Lcom/tonyodev/fetch2/Logger;", "getNetworkProvider", "()Lcom/tonyodev/fetch2/provider/NetworkProvider;", "paused", "priorityComparatorInternal", "Lcom/tonyodev/fetch2/helper/DownloadPriorityComparator;", "getPriorityComparatorInternal", "()Lcom/tonyodev/fetch2/helper/DownloadPriorityComparator;", "priorityQueueInternal", "Ljava/util/PriorityQueue;", "getPriorityQueueInternal", "()Ljava/util/PriorityQueue;", "priorityQueueRunnableInternal", "Ljava/lang/Runnable;", "getPriorityQueueRunnableInternal", "()Ljava/lang/Runnable;", "stopped", "getPriorityQueue", "Ljava/util/Queue;", "pause", "", "registerPriorityQueueInternal", "resume", "start", "stop", "unregisterPriorityQueueInternal", "fetch2_release"})
public class PriorityQueueProcessorImpl
implements PriorityQueueProcessor<Download> {
    @NotNull
    private final Object lock;
    @NotNull
    private volatile NetworkType globalNetworkType;
    private volatile boolean paused;
    private volatile boolean stopped;
    @NotNull
    private final DownloadPriorityComparator priorityComparatorInternal;
    @NotNull
    private final PriorityQueue<Download> priorityQueueInternal;
    @NotNull
    private final Runnable priorityQueueRunnableInternal;
    @NotNull
    private final Handler handler;
    @NotNull
    private final DownloadProvider downloadProvider;
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final NetworkProvider networkProvider;
    @NotNull
    private final Logger logger;

    @NotNull
    public final Object getLock() {
        return this.lock;
    }

    @Override
    @NotNull
    public NetworkType getGlobalNetworkType() {
        return this.globalNetworkType;
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"<set-?>");
        this.globalNetworkType = networkType;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @NotNull
    public final DownloadPriorityComparator getPriorityComparatorInternal() {
        return this.priorityComparatorInternal;
    }

    @NotNull
    public final PriorityQueue<Download> getPriorityQueueInternal() {
        return this.priorityQueueInternal;
    }

    @NotNull
    public final Runnable getPriorityQueueRunnableInternal() {
        return this.priorityQueueRunnableInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.stopped = false;
            this.paused = false;
            this.registerPriorityQueueInternal();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.unregisterPriorityQueueInternal();
            this.priorityQueueInternal.clear();
            this.paused = false;
            this.stopped = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.unregisterPriorityQueueInternal();
            this.paused = true;
            this.stopped = false;
            this.downloadManager.cancelAll();
            this.logger.d("PriorityQueue paused");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.stopped = false;
            this.registerPriorityQueueInternal();
            this.logger.d("PriorityQueue resumed");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Queue<Download> getPriorityQueue() {
        Object object = this.lock;
        synchronized (object) {
            List<Download> queuedStatusList = this.downloadProvider.getByStatus(Status.QUEUED);
            this.priorityQueueInternal.clear();
            this.priorityQueueInternal.addAll((Collection<Download>)queuedStatusList);
            Queue queue = this.priorityQueueInternal;
            return queue;
        }
    }

    public void registerPriorityQueueInternal() {
        this.handler.postDelayed(this.priorityQueueRunnableInternal, 500L);
    }

    public void unregisterPriorityQueueInternal() {
        this.handler.removeCallbacks(this.priorityQueueRunnableInternal);
    }

    @NotNull
    public final Handler getHandler() {
        return this.handler;
    }

    @NotNull
    public final DownloadProvider getDownloadProvider() {
        return this.downloadProvider;
    }

    @NotNull
    public final DownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    @NotNull
    public final NetworkProvider getNetworkProvider() {
        return this.networkProvider;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public PriorityQueueProcessorImpl(@NotNull Handler handler, @NotNull DownloadProvider downloadProvider, @NotNull DownloadManager downloadManager, @NotNull NetworkProvider networkProvider, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)downloadProvider, (String)"downloadProvider");
        Intrinsics.checkParameterIsNotNull((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkParameterIsNotNull((Object)networkProvider, (String)"networkProvider");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.handler = handler;
        this.downloadProvider = downloadProvider;
        this.downloadManager = downloadManager;
        this.networkProvider = networkProvider;
        this.logger = logger;
        this.lock = new Object();
        this.globalNetworkType = NetworkType.GLOBAL_OFF;
        this.priorityComparatorInternal = new DownloadPriorityComparator();
        this.priorityQueueInternal = new PriorityQueue(16, this.priorityComparatorInternal);
        this.priorityQueueRunnableInternal = new Runnable(this){
            final /* synthetic */ PriorityQueueProcessorImpl this$0;

            public final void run() {
                Collection collection;
                Queue<Download> queue = this.this$0.getPriorityQueue();
                while (!(collection = (Collection)queue).isEmpty() && this.this$0.getDownloadManager().canAccommodateNewDownload()) {
                    NetworkType networkType;
                    Download download = queue.poll();
                    if (download == null) continue;
                    NetworkType networkType2 = Intrinsics.areEqual((Object)((Object)this.this$0.getGlobalNetworkType()), (Object)((Object)NetworkType.GLOBAL_OFF)) ^ true ? this.this$0.getGlobalNetworkType() : (networkType = Intrinsics.areEqual((Object)((Object)download.getNetworkType()), (Object)((Object)NetworkType.GLOBAL_OFF)) ? NetworkType.ALL : download.getNetworkType());
                    if (!this.this$0.getNetworkProvider().isOnAllowedNetwork(networkType)) continue;
                    this.this$0.getDownloadManager().start(download);
                }
                this.this$0.getPriorityQueueInternal().clear();
                this.this$0.registerPriorityQueueInternal();
            }
            {
                this.this$0 = priorityQueueProcessorImpl;
            }
        };
    }
}

