/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DatabaseManagerImpl;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.downloader.DownloadManagerImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.FetchBuilderPrefs;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.fetch.FetchHandlerImpl;
import com.tonyodev.fetch2.helper.DownloadInfoManagerDelegate;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.helper.PriorityQueueProcessor;
import com.tonyodev.fetch2.helper.PriorityQueueProcessorImpl;
import com.tonyodev.fetch2.provider.DownloadProvider;
import com.tonyodev.fetch2.provider.ListenerProvider;
import com.tonyodev.fetch2.provider.NetworkProvider;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder;", "", "()V", "activeFetchHandlerPool", "", "", "Ljava/lang/ref/WeakReference;", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "lock", "Ljava/lang/Object;", "buildModulesFromPrefs", "Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Modules;", "prefs", "Lcom/tonyodev/fetch2/fetch/FetchBuilderPrefs;", "removeActiveFetchHandlerNamespaceInstance", "", "namespace", "Modules", "fetch2_release"})
public final class FetchModulesBuilder {
    private static final Object lock;
    private static final Map<String, WeakReference<FetchHandler>> activeFetchHandlerPool;
    public static final FetchModulesBuilder INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Modules buildModulesFromPrefs(@NotNull FetchBuilderPrefs prefs) {
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        Object object = lock;
        synchronized (object) {
            FetchHandler ref;
            WeakReference<FetchHandler> weakReference = activeFetchHandlerPool.get(prefs.getNamespace());
            FetchHandler fetchHandler = ref = weakReference != null ? (FetchHandler)weakReference.get() : null;
            if (ref != null) {
                throw (Throwable)new FetchException("Namespace:" + prefs.getNamespace() + " already exists. You cannot have more than one active instance of Fetch with the same namespace. Did your forget to call close the old instance?", FetchException.Code.FETCH_INSTANCE_WITH_NAMESPACE_ALREADY_EXIST);
            }
            Modules modules = new Modules(prefs);
            Map<String, WeakReference<FetchHandler>> map = activeFetchHandlerPool;
            String string = prefs.getNamespace();
            WeakReference<FetchHandler> weakReference2 = new WeakReference<FetchHandler>(modules.getFetchHandler());
            map.put(string, weakReference2);
            Modules modules2 = modules;
            return modules2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeActiveFetchHandlerNamespaceInstance(@NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Object object = lock;
        synchronized (object) {
            WeakReference<FetchHandler> weakReference = activeFetchHandlerPool.remove(namespace);
        }
    }

    private FetchModulesBuilder() {
    }

    static {
        FetchModulesBuilder fetchModulesBuilder;
        INSTANCE = fetchModulesBuilder = new FetchModulesBuilder();
        lock = new Object();
        activeFetchHandlerPool = new HashMap();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001c\u00a8\u0006&"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Modules;", "", "prefs", "Lcom/tonyodev/fetch2/fetch/FetchBuilderPrefs;", "(Lcom/tonyodev/fetch2/fetch/FetchBuilderPrefs;)V", "databaseManager", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "getDatabaseManager", "()Lcom/tonyodev/fetch2/database/DatabaseManager;", "downloadInfoManagerDelegate", "Lcom/tonyodev/fetch2/helper/DownloadInfoManagerDelegate;", "getDownloadInfoManagerDelegate", "()Lcom/tonyodev/fetch2/helper/DownloadInfoManagerDelegate;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "getDownloadManager", "()Lcom/tonyodev/fetch2/downloader/DownloadManager;", "fetchHandler", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "getFetchHandler", "()Lcom/tonyodev/fetch2/fetch/FetchHandler;", "fetchListenerProvider", "Lcom/tonyodev/fetch2/provider/ListenerProvider;", "getFetchListenerProvider", "()Lcom/tonyodev/fetch2/provider/ListenerProvider;", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "getPrefs", "()Lcom/tonyodev/fetch2/fetch/FetchBuilderPrefs;", "priorityQueueProcessor", "Lcom/tonyodev/fetch2/helper/PriorityQueueProcessor;", "Lcom/tonyodev/fetch2/Download;", "getPriorityQueueProcessor", "()Lcom/tonyodev/fetch2/helper/PriorityQueueProcessor;", "uiHandler", "getUiHandler", "fetch2_release"})
    public static class Modules {
        @NotNull
        private final Handler uiHandler;
        @NotNull
        private final Handler handler;
        @NotNull
        private final ListenerProvider fetchListenerProvider;
        @NotNull
        private final DownloadManager downloadManager;
        @NotNull
        private final DatabaseManager databaseManager;
        @NotNull
        private final DownloadInfoManagerDelegate downloadInfoManagerDelegate;
        @NotNull
        private final PriorityQueueProcessor<Download> priorityQueueProcessor;
        @NotNull
        private final FetchHandler fetchHandler;
        @NotNull
        private final FetchBuilderPrefs prefs;

        @NotNull
        public final Handler getUiHandler() {
            return this.uiHandler;
        }

        @NotNull
        public final Handler getHandler() {
            return this.handler;
        }

        @NotNull
        public final ListenerProvider getFetchListenerProvider() {
            return this.fetchListenerProvider;
        }

        @NotNull
        public final DownloadManager getDownloadManager() {
            return this.downloadManager;
        }

        @NotNull
        public final DatabaseManager getDatabaseManager() {
            return this.databaseManager;
        }

        @NotNull
        public final DownloadInfoManagerDelegate getDownloadInfoManagerDelegate() {
            return this.downloadInfoManagerDelegate;
        }

        @NotNull
        public final PriorityQueueProcessor<Download> getPriorityQueueProcessor() {
            return this.priorityQueueProcessor;
        }

        @NotNull
        public final FetchHandler getFetchHandler() {
            return this.fetchHandler;
        }

        @NotNull
        public final FetchBuilderPrefs getPrefs() {
            return this.prefs;
        }

        public Modules(@NotNull FetchBuilderPrefs prefs) {
            Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
            this.prefs = prefs;
            this.uiHandler = new Handler(Looper.getMainLooper());
            HandlerThread handlerThread = new HandlerThread("fetch_" + this.prefs.getNamespace());
            handlerThread.start();
            this.handler = new Handler(handlerThread.getLooper());
            this.fetchListenerProvider = new ListenerProvider();
            this.databaseManager = new DatabaseManagerImpl(this.prefs.getAppContext(), this.prefs.getNamespace(), this.prefs.getInMemoryDatabaseEnabled(), this.prefs.getLogger());
            this.downloadManager = new DownloadManagerImpl(this.prefs.getDownloader(), this.prefs.getConcurrentLimit(), this.prefs.getProgressReportingIntervalMillis(), this.prefs.getDownloadBufferSizeBytes(), this.prefs.getLogger());
            this.downloadInfoManagerDelegate = new DownloadInfoManagerDelegate(new DownloadInfoUpdater(this.databaseManager), this.uiHandler, this.fetchListenerProvider.getMainListener(), this.prefs.getLogger());
            this.downloadManager.setDelegate(this.downloadInfoManagerDelegate);
            this.priorityQueueProcessor = new PriorityQueueProcessorImpl(this.handler, new DownloadProvider(this.databaseManager), this.downloadManager, new NetworkProvider(this.prefs.getAppContext()), this.prefs.getLogger());
            this.priorityQueueProcessor.setGlobalNetworkType(this.prefs.getGlobalNetworkType());
            this.fetchHandler = new FetchHandlerImpl(this.prefs.getNamespace(), this.databaseManager, this.downloadManager, this.priorityQueueProcessor, this.fetchListenerProvider, this.handler, this.prefs.getLogger());
        }
    }
}

