/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Downloader;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.util.AverageCalculator;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010E\u001a\u00020\u0007J\b\u0010F\u001a\u00020GH\u0016J\b\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020KH\u0016J\u0018\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020PH\u0016R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00148\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010,\"\u0004\b3\u0010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010!R\u001e\u00105\u001a\u00020\u00148\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0016\"\u0004\b7\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010:\u001a\u00020;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010,R\u001e\u0010?\u001a\u00020\u00148\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u0016\"\u0004\bA\u0010\u0018R\u001a\u0010B\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010,\"\u0004\bD\u0010.\u00a8\u0006Q"}, d2={"Lcom/tonyodev/fetch2/downloader/FileDownloaderImpl;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "initialDownload", "Lcom/tonyodev/fetch2/Download;", "downloader", "Lcom/tonyodev/fetch2/Downloader;", "progressReportingIntervalMillis", "", "downloadBufferSizeBytes", "", "logger", "Lcom/tonyodev/fetch2/Logger;", "(Lcom/tonyodev/fetch2/Download;Lcom/tonyodev/fetch2/Downloader;JILcom/tonyodev/fetch2/Logger;)V", "averageDownloadedBytesPerSecondInternal", "", "getAverageDownloadedBytesPerSecondInternal", "()D", "setAverageDownloadedBytesPerSecondInternal", "(D)V", "completedDownload", "", "getCompletedDownload", "()Z", "setCompletedDownload", "(Z)V", "delegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;)V", "download", "getDownload", "()Lcom/tonyodev/fetch2/Download;", "getDownloadBufferSizeBytes", "()I", "downloadInfoInternal", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "getDownloadInfoInternal", "()Lcom/tonyodev/fetch2/database/DownloadInfo;", "setDownloadInfoInternal", "(Lcom/tonyodev/fetch2/database/DownloadInfo;)V", "downloadedInternal", "getDownloadedInternal", "()J", "setDownloadedInternal", "(J)V", "getDownloader", "()Lcom/tonyodev/fetch2/Downloader;", "estimatedTimeRemainingInMillisecondsInternal", "getEstimatedTimeRemainingInMillisecondsInternal", "setEstimatedTimeRemainingInMillisecondsInternal", "getInitialDownload", "interrupted", "getInterrupted", "setInterrupted", "getLogger", "()Lcom/tonyodev/fetch2/Logger;", "movingAverageCalculatorInternal", "Lcom/tonyodev/fetch2/util/AverageCalculator;", "getMovingAverageCalculatorInternal", "()Lcom/tonyodev/fetch2/util/AverageCalculator;", "getProgressReportingIntervalMillis", "terminated", "getTerminated", "setTerminated", "totalInternal", "getTotalInternal", "setTotalInternal", "getAverageDownloadedBytesPerSecond", "getFileInternal", "Ljava/io/File;", "getRequestInternal", "Lcom/tonyodev/fetch2/Downloader$Request;", "run", "", "writeToOutputInternal", "input", "Ljava/io/BufferedInputStream;", "output", "Ljava/io/RandomAccessFile;", "fetch2_release"})
public class FileDownloaderImpl
implements FileDownloader {
    private volatile boolean interrupted;
    private volatile boolean terminated;
    private volatile boolean completedDownload;
    @Nullable
    private FileDownloader.Delegate delegate;
    private long totalInternal;
    private long downloadedInternal;
    private long estimatedTimeRemainingInMillisecondsInternal;
    @NotNull
    private DownloadInfo downloadInfoInternal;
    private double averageDownloadedBytesPerSecondInternal;
    @NotNull
    private final AverageCalculator movingAverageCalculatorInternal;
    @NotNull
    private final Download initialDownload;
    @NotNull
    private final Downloader downloader;
    private final long progressReportingIntervalMillis;
    private final int downloadBufferSizeBytes;
    @NotNull
    private final Logger logger;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    @Override
    public boolean getTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated(boolean bl) {
        this.terminated = bl;
    }

    @Override
    public boolean getCompletedDownload() {
        return this.completedDownload;
    }

    @Override
    public void setCompletedDownload(boolean bl) {
        this.completedDownload = bl;
    }

    @Override
    @Nullable
    public FileDownloader.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FileDownloader.Delegate delegate) {
        this.delegate = delegate;
    }

    public final long getTotalInternal() {
        return this.totalInternal;
    }

    public final void setTotalInternal(long l) {
        this.totalInternal = l;
    }

    public final long getDownloadedInternal() {
        return this.downloadedInternal;
    }

    public final void setDownloadedInternal(long l) {
        this.downloadedInternal = l;
    }

    public final long getEstimatedTimeRemainingInMillisecondsInternal() {
        return this.estimatedTimeRemainingInMillisecondsInternal;
    }

    public final void setEstimatedTimeRemainingInMillisecondsInternal(long l) {
        this.estimatedTimeRemainingInMillisecondsInternal = l;
    }

    @NotNull
    public final DownloadInfo getDownloadInfoInternal() {
        return this.downloadInfoInternal;
    }

    public final void setDownloadInfoInternal(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"<set-?>");
        this.downloadInfoInternal = downloadInfo;
    }

    public final double getAverageDownloadedBytesPerSecondInternal() {
        return this.averageDownloadedBytesPerSecondInternal;
    }

    public final void setAverageDownloadedBytesPerSecondInternal(double d) {
        this.averageDownloadedBytesPerSecondInternal = d;
    }

    @NotNull
    public final AverageCalculator getMovingAverageCalculatorInternal() {
        return this.movingAverageCalculatorInternal;
    }

    @Override
    @NotNull
    public Download getDownload() {
        this.downloadInfoInternal.setDownloaded(this.downloadedInternal);
        this.downloadInfoInternal.setTotal(this.totalInternal);
        return this.downloadInfoInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RandomAccessFile output = null;
        BufferedInputStream input = null;
        Downloader.Response response = null;
        try {
            File file = this.getFileInternal();
            this.downloadedInternal = file.length();
            if (!this.getInterrupted()) {
                boolean isResponseSuccessful;
                Downloader.Response response2 = response = this.downloader.execute(this.getRequestInternal());
                boolean bl = isResponseSuccessful = response2 != null ? response2.isSuccessful() : false;
                if (!this.getInterrupted() && response != null && isResponseSuccessful) {
                    this.totalInternal = response.getContentLength() == (long)-1 ? -1L : this.downloadedInternal + response.getContentLength();
                    output = new RandomAccessFile(file, "rw");
                    if (response.getCode() == 206) {
                        output.seek(this.downloadedInternal);
                        this.logger.d("FileDownloader resuming Download " + this.getDownload());
                    } else {
                        output.seek(0L);
                        this.logger.d("FileDownloader starting Download " + this.getDownload());
                    }
                    if (!this.getInterrupted()) {
                        input = new BufferedInputStream(response.getByteStream(), this.downloadBufferSizeBytes);
                        this.downloadInfoInternal.setDownloaded(this.downloadedInternal);
                        this.downloadInfoInternal.setTotal(this.totalInternal);
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.onStarted(this.downloadInfoInternal, this.estimatedTimeRemainingInMillisecondsInternal, this.getAverageDownloadedBytesPerSecond());
                        }
                        this.writeToOutputInternal(input, output);
                    }
                } else {
                    if (response == null) {
                        throw (Throwable)new FetchException("empty_response_body", FetchException.Code.EMPTY_RESPONSE_BODY);
                    }
                    if (!isResponseSuccessful) {
                        throw (Throwable)new FetchException("request_not_successful", FetchException.Code.REQUEST_NOT_SUCCESSFUL);
                    }
                    throw (Throwable)new FetchException("unknown", FetchException.Code.UNKNOWN);
                }
            }
            if (!this.getCompletedDownload()) {
                this.downloadInfoInternal.setDownloaded(this.downloadedInternal);
                this.downloadInfoInternal.setTotal(this.totalInternal);
                FileDownloader.Delegate delegate = this.getDelegate();
                if (delegate != null) {
                    delegate.onProgress(this.downloadInfoInternal, this.estimatedTimeRemainingInMillisecondsInternal, this.getAverageDownloadedBytesPerSecond());
                }
            }
        }
        catch (Exception e) {
            if (!this.getInterrupted()) {
                this.logger.e("FileDownloader", e);
                Error error = FetchErrorUtils.getErrorFromMessage(e.getMessage());
                this.downloadInfoInternal.setDownloaded(this.downloadedInternal);
                this.downloadInfoInternal.setTotal(this.totalInternal);
                this.downloadInfoInternal.setError(error);
                FileDownloader.Delegate delegate = this.getDelegate();
                if (delegate != null) {
                    delegate.onError(this.downloadInfoInternal);
                }
            }
        }
        finally {
            try {
                RandomAccessFile randomAccessFile = output;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", e);
            }
            try {
                BufferedInputStream bufferedInputStream = input;
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", e);
            }
            if (response != null) {
                try {
                    this.downloader.disconnect(response);
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", e);
                }
            }
            this.setTerminated(true);
        }
    }

    public void writeToOutputInternal(@NotNull BufferedInputStream input, @NotNull RandomAccessFile output) {
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            long downloadedBytesPerSecond = this.downloadedInternal;
            byte[] buffer = new byte[this.downloadBufferSizeBytes];
            long reportingStartTime = System.nanoTime();
            long downloadSpeedStartTime = System.nanoTime();
            int read = input.read(buffer, 0, this.downloadBufferSizeBytes);
            while (!this.getInterrupted() && read != -1) {
                long reportingStopTime;
                boolean hasReportingTimeElapsed;
                output.write(buffer, 0, read);
                this.downloadedInternal += (long)read;
                long downloadSpeedStopTime = System.nanoTime();
                boolean downloadSpeedCheckTimeElapsed = FetchUtils.hasIntervalTimeElapsed(downloadSpeedStartTime, downloadSpeedStopTime, 1000L);
                if (downloadSpeedCheckTimeElapsed) {
                    downloadedBytesPerSecond = this.downloadedInternal - downloadedBytesPerSecond;
                    this.movingAverageCalculatorInternal.add(downloadedBytesPerSecond);
                    this.averageDownloadedBytesPerSecondInternal = AverageCalculator.getMovingAverageWithWeightOnRecentValues$default(this.movingAverageCalculatorInternal, 0, 1, null);
                    this.estimatedTimeRemainingInMillisecondsInternal = FetchUtils.calculateEstimatedTimeRemainingInMilliseconds(this.downloadedInternal, this.totalInternal, this.getAverageDownloadedBytesPerSecond());
                    downloadedBytesPerSecond = this.downloadedInternal;
                }
                if (hasReportingTimeElapsed = FetchUtils.hasIntervalTimeElapsed(reportingStartTime, reportingStopTime = System.nanoTime(), this.progressReportingIntervalMillis)) {
                    this.downloadInfoInternal.setDownloaded(this.downloadedInternal);
                    this.downloadInfoInternal.setTotal(this.totalInternal);
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.onProgress(this.downloadInfoInternal, this.estimatedTimeRemainingInMillisecondsInternal, this.getAverageDownloadedBytesPerSecond());
                    }
                    reportingStartTime = System.nanoTime();
                }
                if (downloadSpeedCheckTimeElapsed) {
                    downloadSpeedStartTime = System.nanoTime();
                }
                read = input.read(buffer, 0, this.downloadBufferSizeBytes);
            }
            if (read != -1 || this.getInterrupted()) break block6;
            this.totalInternal = this.downloadedInternal;
            this.setCompletedDownload(true);
            this.downloadInfoInternal.setDownloaded(this.downloadedInternal);
            this.downloadInfoInternal.setTotal(this.totalInternal);
            FileDownloader.Delegate delegate = this.getDelegate();
            if (delegate != null) {
                delegate.onComplete(this.downloadInfoInternal);
            }
        }
    }

    @NotNull
    public File getFileInternal() {
        File file = new File(this.initialDownload.getFile());
        if (!file.exists()) {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                if (file.getParentFile().mkdirs()) {
                    file.createNewFile();
                    this.logger.d("FileDownloader download file " + file.getAbsolutePath() + " created");
                }
            } else {
                file.createNewFile();
                this.logger.d("FileDownloader download file " + file.getAbsolutePath() + " created");
            }
        }
        return file;
    }

    @NotNull
    public Downloader.Request getRequestInternal() {
        Map headers = MapsKt.toMutableMap(this.initialDownload.getHeaders());
        headers.put("Range", "bytes=" + this.downloadedInternal + '-');
        return new Downloader.Request(this.initialDownload.getUrl(), headers);
    }

    public final long getAverageDownloadedBytesPerSecond() {
        if (this.averageDownloadedBytesPerSecondInternal < 1.0) {
            return 0L;
        }
        double d = this.averageDownloadedBytesPerSecondInternal;
        return (long)Math.ceil(d);
    }

    @NotNull
    public final Download getInitialDownload() {
        return this.initialDownload;
    }

    @NotNull
    public final Downloader getDownloader() {
        return this.downloader;
    }

    public final long getProgressReportingIntervalMillis() {
        return this.progressReportingIntervalMillis;
    }

    public final int getDownloadBufferSizeBytes() {
        return this.downloadBufferSizeBytes;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public FileDownloaderImpl(@NotNull Download initialDownload, @NotNull Downloader downloader, long progressReportingIntervalMillis, int downloadBufferSizeBytes, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)initialDownload, (String)"initialDownload");
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.initialDownload = initialDownload;
        this.downloader = downloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.downloadBufferSizeBytes = downloadBufferSizeBytes;
        this.logger = logger;
        this.estimatedTimeRemainingInMillisecondsInternal = -1L;
        this.downloadInfoInternal = FetchTypeConverterExtensions.toDownloadInfo(this.initialDownload);
        this.movingAverageCalculatorInternal = new AverageCalculator(5);
    }
}

