/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.util;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.util.FetchUtils$WhenMappings;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\u00a8\u0006\u0017"}, d2={"calculateEstimatedTimeRemainingInMilliseconds", "", "downloadedBytes", "totalBytes", "downloadedBytesPerSecond", "calculateProgress", "", "downloaded", "total", "canCancelDownload", "", "download", "Lcom/tonyodev/fetch2/Download;", "canPauseDownload", "canResumeDownload", "canRetryDownload", "getFileLength", "file", "", "hasIntervalTimeElapsed", "nanoStartTime", "nanoStopTime", "progressIntervalMilliseconds", "fetch2_release"})
@JvmName(name="FetchUtils")
public final class FetchUtils {
    public static final boolean canPauseDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$0[download.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canResumeDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$1[download.getStatus().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canRetryDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$2[download.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canCancelDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$3[download.getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public static final int calculateProgress(long downloaded, long total) {
        return total < 1L ? -1 : (downloaded < 1L ? 0 : (downloaded >= total ? 100 : (int)((double)downloaded / (double)total * (double)100)));
    }

    public static final long getFileLength(@NotNull String file) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            l = new File(file).length();
        }
        catch (IOException e) {
            l = 0L;
        }
        return l;
    }

    public static final long calculateEstimatedTimeRemainingInMilliseconds(long downloadedBytes, long totalBytes, long downloadedBytesPerSecond) {
        long l;
        if (totalBytes < 1L) {
            l = -1L;
        } else if (downloadedBytes < 1L) {
            l = -1L;
        } else if (downloadedBytesPerSecond < 1L) {
            l = -1L;
        } else {
            double seconds = (double)(totalBytes - downloadedBytes) / (double)downloadedBytesPerSecond;
            return (long)Math.abs(Math.ceil(seconds)) * (long)1000;
        }
        return l;
    }

    public static final boolean hasIntervalTimeElapsed(long nanoStartTime, long nanoStopTime, long progressIntervalMilliseconds) {
        return TimeUnit.NANOSECONDS.toMillis(nanoStopTime - nanoStartTime) >= progressIntervalMilliseconds;
    }
}

