/*
 * Decompiled with CFR 0.152.
 */
package com.github.tony19;

import com.github.tony19.ILogglyClient;
import com.github.tony19.ILogglyRestApi;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import retrofit.RestAdapter;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogglyClient
implements ILogglyClient {
    private static final String API_URL = "http://logs-01.loggly.com/";
    private final ILogglyRestApi loggly;
    private final String token;

    public LogglyClient(@NotNull String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("token cannot be empty");
        }
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(API_URL).build();
        this.token = string;
        this.loggly = (ILogglyRestApi)restAdapter.create(ILogglyRestApi.class);
    }

    LogglyClient(@NotNull String string, ILogglyRestApi iLogglyRestApi) {
        this.token = string;
        this.loggly = iLogglyRestApi;
    }

    @Override
    public boolean log(@NotNull String string) {
        boolean bl;
        if (string == null) {
            return false;
        }
        try {
            bl = this.loggly.log(this.token, (TypedInput)new TypedString(string)).isOk();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean logBulk(String ... stringArray) {
        if (stringArray == null) {
            return false;
        }
        return this.logBulk(Arrays.asList(stringArray));
    }

    public boolean logBulk(@NotNull Collection<String> collection) {
        boolean bl;
        if (collection == null) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : collection) {
            stringBuilder.append(string.replaceAll("[\r\n]", "\r")).append('\n');
        }
        try {
            bl = this.loggly.logBulk(this.token, (TypedInput)new TypedString(stringBuilder.toString())).isOk();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }
}

