/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.FilenameParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DateParser
implements FilenameParser<Date> {
    private final SimpleDateFormat dateFormatter;
    private final Pattern pathPattern;

    DateParser(FileNamePattern fileNamePattern) {
        this.dateFormatter = this.getDateFormatter(fileNamePattern);
        String pathRegexString = fileNamePattern.toRegex(true, false);
        this.pathPattern = Pattern.compile(pathRegexString);
    }

    Date parseDate(String dateString) throws ParseException {
        return this.dateFormatter.parse(dateString);
    }

    @Override
    public Date parseFilename(String filename) {
        Date date = null;
        try {
            date = this.parseDate(this.findToken(filename));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    private String findToken(String input) {
        Matcher m = this.pathPattern.matcher(input);
        return m.find() && m.groupCount() >= 1 ? m.group(1) : "";
    }

    private SimpleDateFormat getDateFormatter(FileNamePattern fileNamePattern) {
        TimeZone timeZone;
        DateTokenConverter<Object> dateStringConverter = fileNamePattern.getPrimaryDateTokenConverter();
        String datePattern = dateStringConverter != null ? dateStringConverter.getDatePattern() : "yyyy-MM-dd";
        SimpleDateFormat dateFormatter = new SimpleDateFormat(datePattern, Locale.US);
        TimeZone timeZone2 = timeZone = dateStringConverter != null ? dateStringConverter.getTimeZone() : TimeZone.getDefault();
        if (timeZone != null) {
            dateFormatter.setTimeZone(timeZone);
        }
        return dateFormatter;
    }
}

