/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import android.text.TextUtils;
import ch.qos.logback.core.rolling.helper.FileProvider;
import ch.qos.logback.core.rolling.helper.LiteralPathPart;
import ch.qos.logback.core.rolling.helper.PathPart;
import ch.qos.logback.core.rolling.helper.RegexPathPart;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileFinder {
    private static final String REGEX_MARKER_START = "(?:\ufffe)?";
    private static final String REGEX_MARKER_END = "(?:\uffff)?";
    private FileProvider fileProvider;

    FileFinder(FileProvider fileProvider) {
        this.fileProvider = fileProvider;
    }

    List<String> findFiles(String pathPattern) {
        List<PathPart> pathParts = this.splitPath(pathPattern);
        PathPart pathPart = pathParts.get(0);
        List<File> foundFiles = this.findFiles(pathPart.listFiles(this.fileProvider), pathParts, 1);
        return this.toAbsolutePaths(foundFiles);
    }

    List<String> findDirs(String pathPattern) {
        List<PathPart> pathParts = this.splitPath(pathPattern);
        PathPart pathPart = pathParts.get(0);
        ArrayList<File> dirs = new ArrayList<File>();
        this.findDirs(pathPart.listFiles(this.fileProvider), pathParts, 1, dirs);
        return this.toAbsolutePaths(dirs);
    }

    private List<String> toAbsolutePaths(List<File> files) {
        ArrayList<String> filenames = new ArrayList<String>();
        for (File f : files) {
            filenames.add(f.getAbsolutePath());
        }
        return filenames;
    }

    private List<File> findFiles(List<File> files, List<PathPart> pathParts, int index) {
        ArrayList<File> matchedFiles = new ArrayList<File>();
        PathPart pathPart = pathParts.get(index);
        if (index >= pathParts.size() - 1) {
            for (File file : files) {
                if (!pathPart.matches(file)) continue;
                matchedFiles.add(file);
            }
            return matchedFiles;
        }
        for (File file : files) {
            if (!this.fileProvider.isDirectory(file) || !pathPart.matches(file)) continue;
            List<File> filesInDir = this.findFiles(Arrays.asList(this.fileProvider.listFiles(file, null)), pathParts, index + 1);
            matchedFiles.addAll(filesInDir);
        }
        return matchedFiles;
    }

    private void findDirs(List<File> files, List<PathPart> pathParts, int index, List<File> dirs) {
        if (index >= pathParts.size() - 1) {
            return;
        }
        PathPart pathPart = pathParts.get(index);
        for (File file : files) {
            if (!this.fileProvider.isDirectory(file) || !pathPart.matches(file)) continue;
            dirs.add(file);
            this.findDirs(Arrays.asList(this.fileProvider.listFiles(file, null)), pathParts, index + 1, dirs);
        }
    }

    List<PathPart> splitPath(String pattern) {
        ArrayList<PathPart> parts = new ArrayList<PathPart>();
        ArrayList<String> literals = new ArrayList<String>();
        for (String p : pattern.split(File.separator)) {
            boolean isRegex = p.contains(REGEX_MARKER_START) && p.contains(REGEX_MARKER_END);
            p = p.replace(REGEX_MARKER_START, "").replace(REGEX_MARKER_END, "");
            if (isRegex) {
                if (!literals.isEmpty()) {
                    parts.add(new LiteralPathPart(TextUtils.join((CharSequence)File.separator, literals)));
                    literals.clear();
                }
                parts.add(new RegexPathPart(p));
                continue;
            }
            literals.add(p);
        }
        if (!literals.isEmpty()) {
            parts.add(new LiteralPathPart(TextUtils.join((CharSequence)File.separator, literals)));
        }
        return parts;
    }

    static String regexEscapePath(String path) {
        if (path.contains(File.separator)) {
            Object[] parts = path.split(File.separator);
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].length() <= 0) continue;
                parts[i] = REGEX_MARKER_START + (String)parts[i] + REGEX_MARKER_END;
            }
            return TextUtils.join((CharSequence)File.separator, (Object[])parts);
        }
        return REGEX_MARKER_START + path + REGEX_MARKER_END;
    }

    static String unescapePath(String path) {
        return path.replace(REGEX_MARKER_START, "").replace(REGEX_MARKER_END, "");
    }
}

