/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.net.SocketConnector;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.SocketFactory;

public class SocketConnectorBase
implements SocketConnector {
    private final Lock lock = new ReentrantLock();
    private final Condition connectCondition = this.lock.newCondition();
    private final InetAddress address;
    private final int port;
    private SocketConnector.ExceptionHandler exceptionHandler;
    private SocketFactory socketFactory;
    private DelayStrategy delayStrategy;
    private Socket socket;

    public SocketConnectorBase(InetAddress address, int port, int initialDelay, int retryDelay) {
        this(address, port, new FixedDelay(initialDelay, retryDelay));
    }

    public SocketConnectorBase(InetAddress address, int port, DelayStrategy delayStrategy) {
        this.address = address;
        this.port = port;
        this.delayStrategy = delayStrategy;
    }

    public void run() {
        if (this.socket != null) {
            throw new IllegalStateException("connector cannot be reused");
        }
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new ConsoleExceptionHandler();
        }
        if (this.socketFactory == null) {
            this.socketFactory = SocketFactory.getDefault();
        }
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(this.delayStrategy.nextDelay());
                try {
                    this.socket = this.socketFactory.createSocket(this.address, this.port);
                    this.signalConnected();
                    break;
                }
                catch (Exception ex) {
                    this.exceptionHandler.connectionFailed(this, ex);
                }
            }
        }
        catch (InterruptedException ex) {
            this.exceptionHandler.connectionFailed(this, ex);
        }
    }

    private void signalConnected() {
        this.lock.lock();
        try {
            this.connectCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Socket awaitConnection() throws InterruptedException {
        return this.awaitConnection(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket awaitConnection(long delay) throws InterruptedException {
        this.lock.lock();
        try {
            boolean timeout = false;
            while (this.socket == null && !timeout) {
                timeout = !this.connectCondition.await(delay, TimeUnit.MILLISECONDS);
            }
            Socket socket = this.socket;
            return socket;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setExceptionHandler(SocketConnector.ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public Socket call() throws InterruptedException {
        return null;
    }

    private static class FixedDelay
    implements DelayStrategy {
        private final int retryDelay;
        private int nextDelay;

        public FixedDelay(int initialDelay, int retryDelay) {
            this.nextDelay = initialDelay;
            this.retryDelay = retryDelay;
        }

        public int nextDelay() {
            int delay = this.nextDelay;
            this.nextDelay = this.retryDelay;
            return delay;
        }
    }

    private static class ConsoleExceptionHandler
    implements SocketConnector.ExceptionHandler {
        private ConsoleExceptionHandler() {
        }

        public void connectionFailed(SocketConnector connector, Exception ex) {
            System.out.println(ex);
        }
    }

    public static interface DelayStrategy {
        public int nextDelay();
    }
}

