/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import android.util.Log;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogcatAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final int MAX_TAG_LENGTH = 23;
    private PatternLayoutEncoder encoder = null;
    private PatternLayoutEncoder tagEncoder = null;
    private boolean checkLoggable = false;

    @Override
    public void start() {
        if (this.encoder == null || this.encoder.getLayout() == null) {
            this.addError("No layout set for the appender named [" + this.name + "].");
            return;
        }
        if (this.tagEncoder != null) {
            Layout layout = this.tagEncoder.getLayout();
            if (layout == null) {
                this.addError("No tag layout set for the appender named [" + this.name + "].");
                return;
            }
            if (layout instanceof PatternLayout) {
                String pattern = this.tagEncoder.getPattern();
                if (!pattern.contains("%nopex")) {
                    this.tagEncoder.stop();
                    this.tagEncoder.setPattern(pattern + "%nopex");
                    this.tagEncoder.start();
                }
                PatternLayout tagLayout = (PatternLayout)layout;
                tagLayout.setPostCompileProcessor(null);
            }
        }
        super.start();
    }

    @Override
    public void append(ILoggingEvent event) {
        if (!this.isStarted()) {
            return;
        }
        String tag = this.getTag(event);
        switch (event.getLevel().levelInt) {
            case -2147483648: 
            case 5000: {
                if (this.checkLoggable && !Log.isLoggable((String)tag, (int)2)) break;
                Log.v((String)tag, (String)this.encoder.getLayout().doLayout(event));
                break;
            }
            case 10000: {
                if (this.checkLoggable && !Log.isLoggable((String)tag, (int)3)) break;
                Log.d((String)tag, (String)this.encoder.getLayout().doLayout(event));
                break;
            }
            case 20000: {
                if (this.checkLoggable && !Log.isLoggable((String)tag, (int)4)) break;
                Log.i((String)tag, (String)this.encoder.getLayout().doLayout(event));
                break;
            }
            case 30000: {
                if (this.checkLoggable && !Log.isLoggable((String)tag, (int)5)) break;
                Log.w((String)tag, (String)this.encoder.getLayout().doLayout(event));
                break;
            }
            case 40000: {
                if (this.checkLoggable && !Log.isLoggable((String)tag, (int)6)) break;
                Log.e((String)tag, (String)this.encoder.getLayout().doLayout(event));
                break;
            }
        }
    }

    public PatternLayoutEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
    }

    public PatternLayoutEncoder getTagEncoder() {
        return this.tagEncoder;
    }

    public void setTagEncoder(PatternLayoutEncoder encoder) {
        this.tagEncoder = encoder;
    }

    public void setCheckLoggable(boolean enable) {
        this.checkLoggable = enable;
    }

    public boolean getCheckLoggable() {
        return this.checkLoggable;
    }

    protected String getTag(ILoggingEvent event) {
        String tag;
        String string = tag = this.tagEncoder != null ? this.tagEncoder.getLayout().doLayout(event) : event.getLoggerName();
        if (this.checkLoggable && tag.length() > 23) {
            tag = tag.substring(0, 22) + "*";
        }
        return tag;
    }
}

