/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.android;

import android.os.Environment;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.OptionHelper;

public abstract class CommonPathUtil {
    private static final String ASSETS_DIRECTORY = "assets";

    public static String getMountedExternalStorageDirectoryPath() {
        if (EnvUtil.isAndroidOS()) {
            String path = null;
            String state = Environment.getExternalStorageState();
            if (state.equals("mounted") || state.equals("mounted_ro")) {
                path = Environment.getExternalStorageDirectory().getAbsolutePath();
            }
            return path;
        }
        return "/mnt/sdcard";
    }

    public static String getExternalStorageDirectoryPath() {
        if (EnvUtil.isAndroidOS()) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        String extDir = OptionHelper.getEnv("EXTERNAL_STORAGE");
        return extDir == null ? "/sdcard" : extDir;
    }

    public static String getFilesDirectoryPath(String packageName) {
        String dataDir = EnvUtil.isAndroidOS() ? Environment.getDataDirectory().getAbsolutePath() : "/data";
        return dataDir + "/data/" + packageName + "/files";
    }

    public static String getAssetsDirectoryPath() {
        return ASSETS_DIRECTORY;
    }

    public static String getDatabaseDirectoryPath(String packageName) {
        String dataDir = EnvUtil.isAndroidOS() ? Environment.getDataDirectory().getAbsolutePath() : "/data";
        return dataDir + "/data/" + packageName + "/databases";
    }
}

