/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.joran.util.MethodDescriptor;
import ch.qos.logback.core.joran.util.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector {
    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        String nm = name.substring(0, 1).toLowerCase(Locale.US);
        if (name.length() > 1) {
            nm = nm + name.substring(1);
        }
        return nm;
    }

    public static MethodDescriptor[] getMethodDescriptors(Class<?> clazz) {
        ArrayList<MethodDescriptor> methods = new ArrayList<MethodDescriptor>();
        for (Method m : clazz.getMethods()) {
            methods.add(new MethodDescriptor(m.getName(), m));
        }
        return methods.toArray(new MethodDescriptor[0]);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        String SETTER_PREFIX = "set";
        String GETTER_PREFIX = "get";
        int LEN_PREFIX = "set".length();
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (Method m : clazz.getMethods()) {
            boolean isSet;
            PropertyDescriptor pd = null;
            String mName = m.getName();
            boolean isGet = mName.startsWith("get") && mName.length() > LEN_PREFIX;
            boolean bl = isSet = mName.startsWith("set") && mName.length() > LEN_PREFIX;
            if (!isGet && !isSet) continue;
            String propName = Introspector.decapitalize(mName.substring(LEN_PREFIX));
            pd = (PropertyDescriptor)map.get(propName);
            if (pd == null) {
                pd = new PropertyDescriptor(propName);
                map.put(propName, pd);
            }
            Class<?>[] parmTypes = m.getParameterTypes();
            if (isSet) {
                if (parmTypes.length != 1) continue;
                pd.setWriteMethod(m);
                pd.setPropertyType(parmTypes[0]);
                continue;
            }
            if (!isGet || parmTypes.length != 0) continue;
            pd.setReadMethod(m);
            if (pd.getPropertyType() != null) continue;
            pd.setPropertyType(m.getReturnType());
        }
        return map.values().toArray(new PropertyDescriptor[0]);
    }
}

