/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import ch.qos.logback.classic.android.Clock;
import ch.qos.logback.classic.android.SQLiteLogCleaner;
import ch.qos.logback.classic.android.SystemClock;
import ch.qos.logback.classic.db.SQLBuilder;
import ch.qos.logback.classic.db.names.DBNameResolver;
import ch.qos.logback.classic.db.names.DefaultDBNameResolver;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.android.AndroidContextUtil;
import ch.qos.logback.core.util.Duration;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private SQLiteDatabase db;
    private String insertPropertiesSQL;
    private String insertExceptionSQL;
    private String insertSQL;
    private String filename;
    private DBNameResolver dbNameResolver;
    private Duration maxHistory;
    private long lastCleanupTime = 0L;
    private SQLiteLogCleaner logCleaner;
    private Clock clock = new SystemClock();
    private static final int TIMESTMP_INDEX = 1;
    private static final int FORMATTED_MESSAGE_INDEX = 2;
    private static final int LOGGER_NAME_INDEX = 3;
    private static final int LEVEL_STRING_INDEX = 4;
    private static final int THREAD_NAME_INDEX = 5;
    private static final int REFERENCE_FLAG_INDEX = 6;
    private static final int ARG0_INDEX = 7;
    private static final int CALLER_FILENAME_INDEX = 11;
    private static final int CALLER_CLASS_INDEX = 12;
    private static final int CALLER_METHOD_INDEX = 13;
    private static final int CALLER_LINE_INDEX = 14;
    private static final short PROPERTIES_EXIST = 1;
    private static final short EXCEPTION_EXISTS = 2;

    void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setDbNameResolver(DBNameResolver dbNameResolver) {
        this.dbNameResolver = dbNameResolver;
    }

    public String getMaxHistory() {
        return this.maxHistory != null ? this.maxHistory.toString() : "";
    }

    public long getMaxHistoryMs() {
        return this.maxHistory != null ? this.maxHistory.getMilliseconds() : 0L;
    }

    public void setMaxHistory(String maxHistory) {
        this.maxHistory = Duration.valueOf(maxHistory);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public File getDatabaseFile(String filename) {
        File dbFile = null;
        if (filename != null && filename.trim().length() > 0) {
            dbFile = new File(filename);
        }
        if (dbFile == null || dbFile.isDirectory()) {
            dbFile = new File(new AndroidContextUtil().getDatabasePath("logback.db"));
        }
        return dbFile;
    }

    @Override
    public void start() {
        this.started = false;
        File dbfile = this.getDatabaseFile(this.filename);
        if (dbfile == null) {
            this.addError("Cannot determine database filename");
            return;
        }
        boolean dbOpened = false;
        try {
            dbfile.getParentFile().mkdirs();
            this.addInfo("db path: " + dbfile.getAbsolutePath());
            this.db = SQLiteDatabase.openOrCreateDatabase((String)dbfile.getPath(), null);
            dbOpened = true;
        }
        catch (SQLiteException e) {
            this.addError("Cannot open database", e);
        }
        if (dbOpened) {
            if (this.dbNameResolver == null) {
                this.dbNameResolver = new DefaultDBNameResolver();
            }
            this.insertExceptionSQL = SQLBuilder.buildInsertExceptionSQL(this.dbNameResolver);
            this.insertPropertiesSQL = SQLBuilder.buildInsertPropertiesSQL(this.dbNameResolver);
            this.insertSQL = SQLBuilder.buildInsertSQL(this.dbNameResolver);
            try {
                this.db.execSQL(SQLBuilder.buildCreateLoggingEventTableSQL(this.dbNameResolver));
                this.db.execSQL(SQLBuilder.buildCreatePropertyTableSQL(this.dbNameResolver));
                this.db.execSQL(SQLBuilder.buildCreateExceptionTableSQL(this.dbNameResolver));
                this.clearExpiredLogs(this.db);
                super.start();
                this.started = true;
            }
            catch (SQLiteException e) {
                this.addError("Cannot create database tables", e);
            }
        }
    }

    private void clearExpiredLogs(SQLiteDatabase db) {
        if (this.lastCheckExpired(this.maxHistory, this.lastCleanupTime)) {
            this.lastCleanupTime = this.clock.currentTimeMillis();
            this.getLogCleaner().performLogCleanup(db, this.maxHistory);
        }
    }

    private boolean lastCheckExpired(Duration expiry, long lastCleanupTime) {
        boolean isExpired = false;
        if (expiry != null && expiry.getMilliseconds() > 0L) {
            long now = this.clock.currentTimeMillis();
            long timeDiff = now - lastCleanupTime;
            isExpired = lastCleanupTime <= 0L || timeDiff >= expiry.getMilliseconds();
        }
        return isExpired;
    }

    public SQLiteLogCleaner getLogCleaner() {
        if (this.logCleaner == null) {
            final Clock thisClock = this.clock;
            this.logCleaner = new SQLiteLogCleaner(){

                public void performLogCleanup(SQLiteDatabase db, Duration expiry) {
                    long expiryMs = thisClock.currentTimeMillis() - expiry.getMilliseconds();
                    String deleteExpiredLogsSQL = SQLBuilder.buildDeleteExpiredLogsSQL(SQLiteAppender.this.dbNameResolver, expiryMs);
                    db.execSQL(deleteExpiredLogsSQL);
                }
            };
        }
        return this.logCleaner;
    }

    public void setLogCleaner(SQLiteLogCleaner logCleaner) {
        this.logCleaner = logCleaner;
    }

    protected void finalize() throws Throwable {
        this.db.close();
    }

    @Override
    public void stop() {
        this.db.close();
        this.lastCleanupTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(ILoggingEvent eventObject) {
        if (this.isStarted()) {
            try {
                this.clearExpiredLogs(this.db);
                SQLiteStatement stmt = this.db.compileStatement(this.insertSQL);
                try {
                    this.db.beginTransaction();
                    long eventId = this.subAppend(eventObject, stmt);
                    if (eventId != -1L) {
                        this.secondarySubAppend(eventObject, eventId);
                        this.db.setTransactionSuccessful();
                    }
                }
                finally {
                    if (this.db.inTransaction()) {
                        this.db.endTransaction();
                    }
                    stmt.close();
                }
            }
            catch (Throwable e) {
                this.addError("Cannot append event", e);
            }
        }
    }

    private long subAppend(ILoggingEvent event, SQLiteStatement insertStatement) throws SQLException {
        this.bindLoggingEvent(insertStatement, event);
        this.bindLoggingEventArguments(insertStatement, event.getArgumentArray());
        this.bindCallerData(insertStatement, event.getCallerData());
        long insertId = -1L;
        try {
            insertId = insertStatement.executeInsert();
        }
        catch (SQLiteException e) {
            this.addWarn("Failed to insert loggingEvent", e);
        }
        return insertId;
    }

    private void secondarySubAppend(ILoggingEvent event, long eventId) throws SQLException {
        Map<String, String> mergedMap = this.mergePropertyMaps(event);
        this.insertProperties(mergedMap, eventId);
        if (event.getThrowableProxy() != null) {
            this.insertThrowable(event.getThrowableProxy(), eventId);
        }
    }

    private void bindLoggingEvent(SQLiteStatement stmt, ILoggingEvent event) throws SQLException {
        stmt.bindLong(1, event.getTimeStamp());
        stmt.bindString(2, event.getFormattedMessage());
        stmt.bindString(3, event.getLoggerName());
        stmt.bindString(4, event.getLevel().toString());
        stmt.bindString(5, event.getThreadName());
        stmt.bindLong(6, (long)SQLiteAppender.computeReferenceMask(event));
    }

    private void bindLoggingEventArguments(SQLiteStatement stmt, Object[] argArray) throws SQLException {
        int arrayLen = argArray != null ? argArray.length : 0;
        for (int i = 0; i < arrayLen && i < 4; ++i) {
            stmt.bindString(7 + i, this.asStringTruncatedTo254(argArray[i]));
        }
    }

    private String asStringTruncatedTo254(Object o) {
        String s = null;
        if (o != null) {
            s = o.toString();
        }
        if (s != null && s.length() > 254) {
            s = s.substring(0, 254);
        }
        return s == null ? "" : s;
    }

    private static short computeReferenceMask(ILoggingEvent event) {
        short mask = 0;
        int mdcPropSize = 0;
        if (event.getMDCPropertyMap() != null) {
            mdcPropSize = event.getMDCPropertyMap().keySet().size();
        }
        int contextPropSize = 0;
        if (event.getLoggerContextVO().getPropertyMap() != null) {
            contextPropSize = event.getLoggerContextVO().getPropertyMap().size();
        }
        if (mdcPropSize > 0 || contextPropSize > 0) {
            mask = 1;
        }
        if (event.getThrowableProxy() != null) {
            mask = (short)(mask | 2);
        }
        return mask;
    }

    private Map<String, String> mergePropertyMaps(ILoggingEvent event) {
        Map<String, String> mdcMap;
        HashMap<String, String> mergedMap = new HashMap<String, String>();
        Map<String, String> loggerContextMap = event.getLoggerContextVO().getPropertyMap();
        if (loggerContextMap != null) {
            mergedMap.putAll(loggerContextMap);
        }
        if ((mdcMap = event.getMDCPropertyMap()) != null) {
            mergedMap.putAll(mdcMap);
        }
        return mergedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertProperties(Map<String, String> mergedMap, long eventId) throws SQLException {
        if (mergedMap.size() > 0) {
            SQLiteStatement stmt = this.db.compileStatement(this.insertPropertiesSQL);
            try {
                for (Map.Entry<String, String> entry : mergedMap.entrySet()) {
                    stmt.bindLong(1, eventId);
                    stmt.bindString(2, entry.getKey());
                    stmt.bindString(3, entry.getValue());
                    stmt.executeInsert();
                }
            }
            finally {
                stmt.close();
            }
        }
    }

    private void bindCallerData(SQLiteStatement stmt, StackTraceElement[] callerDataArray) throws SQLException {
        StackTraceElement callerData;
        if (callerDataArray != null && callerDataArray.length > 0 && (callerData = callerDataArray[0]) != null) {
            stmt.bindString(11, callerData.getFileName());
            stmt.bindString(12, callerData.getClassName());
            stmt.bindString(13, callerData.getMethodName());
            stmt.bindString(14, Integer.toString(callerData.getLineNumber()));
        }
    }

    private void insertException(SQLiteStatement stmt, String txt, short i, long eventId) throws SQLException {
        stmt.bindLong(1, eventId);
        stmt.bindLong(2, (long)i);
        stmt.bindString(3, txt);
        stmt.executeInsert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertThrowable(IThrowableProxy tp, long eventId) throws SQLException {
        SQLiteStatement stmt = this.db.compileStatement(this.insertExceptionSQL);
        try {
            short baseIndex = 0;
            while (tp != null) {
                StringBuilder buf = new StringBuilder();
                ThrowableProxyUtil.subjoinFirstLine(buf, tp);
                short s = baseIndex;
                baseIndex = (short)(baseIndex + 1);
                this.insertException(stmt, buf.toString(), s, eventId);
                int commonFrames = tp.getCommonFrames();
                StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
                for (int i = 0; i < stepArray.length - commonFrames; ++i) {
                    StringBuilder sb = new StringBuilder();
                    sb.append('\t');
                    ThrowableProxyUtil.subjoinSTEP(sb, stepArray[i]);
                    short s2 = baseIndex;
                    baseIndex = (short)(baseIndex + 1);
                    this.insertException(stmt, sb.toString(), s2, eventId);
                }
                if (commonFrames > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append('\t').append("... ").append(commonFrames).append(" common frames omitted");
                    short s3 = baseIndex;
                    baseIndex = (short)(baseIndex + 1);
                    this.insertException(stmt, sb.toString(), s3, eventId);
                }
                tp = tp.getCause();
            }
        }
        finally {
            stmt.close();
        }
    }
}

