/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class RootLoggerAction
extends Action {
    Logger root;
    boolean inError = false;

    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
        this.inError = false;
        LoggerContext loggerContext = (LoggerContext)this.context;
        this.root = loggerContext.getLogger("ROOT");
        String string2 = interpretationContext.subst(attributes.getValue("level"));
        if (!OptionHelper.isEmpty(string2)) {
            Level level = Level.toLevel(string2);
            this.addInfo("Setting level of ROOT logger to " + level);
            this.root.setLevel(level);
        }
        interpretationContext.pushObject(this.root);
    }

    public void end(InterpretationContext interpretationContext, String string) {
        if (this.inError) {
            return;
        }
        Object object = interpretationContext.peekObject();
        if (object != this.root) {
            this.addWarn("The object on the top the of the stack is not the root logger");
            this.addWarn("It is: " + object);
        } else {
            interpretationContext.popObject();
        }
    }

    public void finish(InterpretationContext interpretationContext) {
    }
}

