/**
 * Copyright 2019 Anthony Trinh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.qos.logback.core.spi;

import java.util.List;

import ch.qos.logback.core.filter.Filter;

/**
 * Interface for attaching filters to objects.
 *
 * @author Ceki G&uuml;lc&uuml;
 */
public interface FilterAttachable<E> {
  /**
   * Add a filter.
   * @param newFilter filter to add
   */
  void addFilter(Filter<E> newFilter);

  void clearAllFilters();

  /**
   * Get a copy of all the filters contained within this FilterAttachable
   * object.
   *
   * @return all attached filters as a list
   */
  List<Filter<E>> getCopyOfAttachedFiltersList();

  /**
   * Loop through the filters in the chain. As soon as a filter decides on
   * ACCEPT or DENY, then that value is returned. If all of the filters return
   * NEUTRAL, then NEUTRAL is returned.
   * @param event the log event
   * @return filter result (ACCEPT, DENY, NEUTRAL)
   */
  FilterReply getFilterChainDecision(E event);
}
