/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.status.Status;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatusBase
implements Status {
    private static final List<Status> EMPTY_LIST = new ArrayList<Status>(0);
    int level;
    final String message;
    final Object origin;
    List<Status> childrenList;
    Throwable throwable;
    long date;

    StatusBase(int n, String string, Object object) {
        this(n, string, object, null);
    }

    StatusBase(int n, String string, Object object, Throwable throwable) {
        this.level = n;
        this.message = string;
        this.origin = object;
        this.throwable = throwable;
        this.date = System.currentTimeMillis();
    }

    @Override
    public synchronized void add(Status status) {
        if (status == null) {
            throw new NullPointerException("Null values are not valid Status.");
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<Status>();
        }
        this.childrenList.add(status);
    }

    @Override
    public synchronized boolean hasChildren() {
        return this.childrenList != null && this.childrenList.size() > 0;
    }

    @Override
    public synchronized Iterator<Status> iterator() {
        if (this.childrenList != null) {
            return this.childrenList.iterator();
        }
        return EMPTY_LIST.iterator();
    }

    @Override
    public synchronized boolean remove(Status status) {
        if (this.childrenList == null) {
            return false;
        }
        return this.childrenList.remove(status);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public synchronized int getEffectiveLevel() {
        int n = this.level;
        Iterator<Status> iterator = this.iterator();
        while (iterator.hasNext()) {
            Status status = iterator.next();
            int n2 = status.getEffectiveLevel();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Object getOrigin() {
        return this.origin;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public Long getDate() {
        return this.date;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.getEffectiveLevel()) {
            case 0: {
                stringBuilder.append("INFO");
                break;
            }
            case 1: {
                stringBuilder.append("WARN");
                break;
            }
            case 2: {
                stringBuilder.append("ERROR");
            }
        }
        if (this.origin != null) {
            stringBuilder.append(" in ");
            stringBuilder.append(this.origin);
            stringBuilder.append(" -");
        }
        stringBuilder.append(" ");
        stringBuilder.append(this.message);
        if (this.throwable != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.throwable);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.level;
        n = 31 * n + (this.message == null ? 0 : this.message.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StatusBase statusBase = (StatusBase)object;
        if (this.level != statusBase.level) {
            return false;
        }
        return !(this.message == null ? statusBase.message != null : !this.message.equals(statusBase.message));
    }
}

