/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Token {
    static final int PERCENT = 37;
    static final int RIGHT_PARENTHESIS = 41;
    static final int MINUS = 45;
    static final int DOT = 46;
    static final int CURLY_LEFT = 123;
    static final int CURLY_RIGHT = 125;
    static final int LITERAL = 1000;
    static final int FORMAT_MODIFIER = 1002;
    static final int SIMPLE_KEYWORD = 1004;
    static final int COMPOSITE_KEYWORD = 1005;
    static final int OPTION = 1006;
    static final int EOF = Integer.MAX_VALUE;
    static Token EOF_TOKEN = new Token(Integer.MAX_VALUE, "EOF");
    static Token RIGHT_PARENTHESIS_TOKEN = new Token(41);
    static Token BARE_COMPOSITE_KEYWORD_TOKEN = new Token(1005, "BARE");
    static Token PERCENT_TOKEN = new Token(37);
    private final int type;
    private final String value;
    private final List<String> optionsList;

    public Token(int n) {
        this(n, null, null);
    }

    public Token(int n, String string) {
        this(n, string, null);
    }

    public Token(int n, List<String> list) {
        this(n, null, list);
    }

    public Token(int n, String string, List<String> list) {
        this.type = n;
        this.value = string;
        this.optionsList = list;
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getOptionsList() {
        return this.optionsList;
    }

    public String toString() {
        String string = null;
        switch (this.type) {
            case 37: {
                string = "%";
                break;
            }
            case 1002: {
                string = "FormatModifier";
                break;
            }
            case 1000: {
                string = "LITERAL";
                break;
            }
            case 1006: {
                string = "OPTION";
                break;
            }
            case 1004: {
                string = "SIMPLE_KEYWORD";
                break;
            }
            case 1005: {
                string = "COMPOSITE_KEYWORD";
                break;
            }
            case 41: {
                string = "RIGHT_PARENTHESIS";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        if (this.value == null) {
            return "Token(" + string + ")";
        }
        return "Token(" + string + ", \"" + this.value + "\")";
    }

    public int hashCode() {
        int n = this.type;
        n = 29 * n + (this.value != null ? this.value.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Token)) {
            return false;
        }
        Token token = (Token)object;
        if (this.type != token.type) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(token.value) : token.value != null);
    }
}

