/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.STEUtil;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagingDataCalculator {
    static final StackTraceElementProxy[] STEP_ARRAY_TEMPLATE = new StackTraceElementProxy[0];
    HashMap<String, ClassPackagingData> cache = new HashMap();

    public void calculate(IThrowableProxy iThrowableProxy) {
        while (iThrowableProxy != null) {
            this.populateFrames(iThrowableProxy.getStackTraceElementProxyArray());
            IThrowableProxy[] iThrowableProxyArray = iThrowableProxy.getSuppressed();
            if (iThrowableProxyArray != null) {
                for (IThrowableProxy iThrowableProxy2 : iThrowableProxyArray) {
                    this.populateFrames(iThrowableProxy2.getStackTraceElementProxyArray());
                }
            }
            iThrowableProxy = iThrowableProxy.getCause();
        }
    }

    private void populateFrames(StackTraceElementProxy[] stackTraceElementProxyArray) {
        Throwable throwable = new Throwable("local stack reference");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = STEUtil.findNumberOfCommonFrames(stackTraceElementArray, stackTraceElementProxyArray);
        int n2 = stackTraceElementProxyArray.length - n;
        ClassLoader classLoader = null;
        ClassLoader classLoader2 = null;
        for (int i = 0; i < n; ++i) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[n2 + i];
            ClassPackagingData classPackagingData = this.computeBySTEP(stackTraceElementProxy, classLoader);
            stackTraceElementProxy.setClassPackagingData(classPackagingData);
        }
        this.populateUncommonFrames(n, stackTraceElementProxyArray, classLoader2);
    }

    private void populateUncommonFrames(int n, StackTraceElementProxy[] stackTraceElementProxyArray, ClassLoader classLoader) {
        int n2 = stackTraceElementProxyArray.length - n;
        for (int i = 0; i < n2; ++i) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[i];
            ClassPackagingData classPackagingData = this.computeBySTEP(stackTraceElementProxy, classLoader);
            stackTraceElementProxy.setClassPackagingData(classPackagingData);
        }
    }

    private ClassPackagingData computeBySTEP(StackTraceElementProxy stackTraceElementProxy, ClassLoader classLoader) {
        String string = stackTraceElementProxy.ste.getClassName();
        ClassPackagingData classPackagingData = this.cache.get(string);
        if (classPackagingData != null) {
            return classPackagingData;
        }
        Class<?> clazz = this.bestEffortLoadClass(classLoader, string);
        String string2 = this.getImplementationVersion(clazz);
        String string3 = this.getCodeLocation(clazz);
        classPackagingData = new ClassPackagingData(string3, string2, false);
        this.cache.put(string, classPackagingData);
        return classPackagingData;
    }

    private String getImplementationVersion(Class<?> clazz) {
        if (clazz == null) {
            return "na";
        }
        Package package_ = clazz.getPackage();
        if (package_ != null) {
            String string = package_.getImplementationVersion();
            if (string == null) {
                return "na";
            }
            return string;
        }
        return "na";
    }

    private String getCodeLocation(Class<?> clazz) {
        try {
            URL uRL;
            CodeSource codeSource;
            if (clazz != null && (codeSource = clazz.getProtectionDomain().getCodeSource()) != null && (uRL = codeSource.getLocation()) != null) {
                String string = uRL.toString();
                String string2 = this.getCodeLocation(string, '/');
                if (string2 != null) {
                    return string2;
                }
                return this.getCodeLocation(string, '\\');
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "na";
    }

    private String getCodeLocation(String string, char c) {
        int n = string.lastIndexOf(c);
        if (this.isFolder(n, string)) {
            n = string.lastIndexOf(c, n - 1);
            return string.substring(n + 1);
        }
        if (n > 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    private boolean isFolder(int n, String string) {
        return n != -1 && n + 1 == string.length();
    }

    private Class<?> loadClass(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            return null;
        }
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Class<?> bestEffortLoadClass(ClassLoader classLoader, String string) {
        Class<?> clazz = this.loadClass(classLoader, string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (classLoader2 != classLoader) {
            clazz = this.loadClass(classLoader2, string);
        }
        if (clazz != null) {
            return clazz;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

