/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.rolling.helper.TimeBasedArchiveRemover;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SizeAndTimeBasedArchiveRemover
extends TimeBasedArchiveRemover {
    protected static final int NO_INDEX = -1;

    public SizeAndTimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rollingCalendar) {
        super(fileNamePattern, rollingCalendar);
    }

    protected File[] getFilesInPeriod(Date date) {
        File file = new File(this.fileNamePattern.convertMultipleArguments(date, 0));
        File file2 = this.getParentDir(file);
        String string = this.createStemRegex(date);
        File[] fileArray = FileFilterUtil.filesInFolderMatchingStemRegex(file2, string);
        return fileArray;
    }

    private String createStemRegex(Date date) {
        String string = this.fileNamePattern.toRegexForFixedDate(date);
        return FileFilterUtil.afterLastSlash(string);
    }

    protected void descendingSort(File[] fileArray, Date date) {
        String string = this.createStemRegex(date);
        final Pattern pattern = Pattern.compile(string);
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                int n;
                int n2 = this.extractIndex(pattern, file);
                if (n2 == (n = this.extractIndex(pattern, file2))) {
                    return 0;
                }
                if (n < n2) {
                    return -1;
                }
                return 1;
            }

            private int extractIndex(Pattern pattern2, File file) {
                Matcher matcher = pattern2.matcher(file.getName());
                if (matcher.find()) {
                    String string = matcher.group(1);
                    if (string == null || string.isEmpty()) {
                        return -1;
                    }
                    return Integer.parseInt(string);
                }
                return -1;
            }
        });
    }
}

