/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

public class Node {
    static final int LITERAL = 0;
    static final int SIMPLE_KEYWORD = 1;
    static final int COMPOSITE_KEYWORD = 2;
    final int type;
    final Object value;
    Node next;

    Node(int n) {
        this(n, null);
    }

    Node(int n, Object object) {
        this.type = n;
        this.value = object;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public Node getNext() {
        return this.next;
    }

    public void setNext(Node node) {
        this.next = node;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Node)) {
            return false;
        }
        Node node = (Node)object;
        return this.type == node.type && (this.value != null ? this.value.equals(node.value) : node.value == null) && (this.next != null ? this.next.equals(node.next) : node.next == null);
    }

    public int hashCode() {
        int n = this.type;
        n = 31 * n + (this.value != null ? this.value.hashCode() : 0);
        return n;
    }

    String printNext() {
        if (this.next != null) {
            return " -> " + this.next;
        }
        return "";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 0: {
                stringBuffer.append("LITERAL(" + this.value + ")");
                break;
            }
            default: {
                stringBuffer.append(super.toString());
            }
        }
        stringBuffer.append(this.printNext());
        return stringBuffer.toString();
    }
}

