/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.ReconfigureOnChangeTask;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.net.URL;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.xml.sax.Attributes;

public class ConfigurationAction
extends Action {
    static final String INTERNAL_DEBUG_ATTR = "debug";
    static final String PACKAGING_DATA_ATTR = "packagingData";
    static final String SCAN_ATTR = "scan";
    static final String SCAN_PERIOD_ATTR = "scanPeriod";
    static final String DEBUG_SYSTEM_PROPERTY_KEY = "logback.debug";

    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
        String string2 = OptionHelper.getSystemProperty(DEBUG_SYSTEM_PROPERTY_KEY);
        if (string2 == null) {
            string2 = interpretationContext.subst(attributes.getValue(INTERNAL_DEBUG_ATTR));
        }
        if (OptionHelper.isEmpty(string2) || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("null")) {
            this.addInfo("debug attribute not set");
        } else {
            StatusListenerConfigHelper.addOnConsoleListenerInstance(this.context, new OnConsoleStatusListener());
        }
        this.processScanAttrib(interpretationContext, attributes);
        ContextUtil contextUtil = new ContextUtil(this.context);
        contextUtil.addHostNameAsProperty();
        interpretationContext.pushObject(this.getContext());
        LoggerContext loggerContext = (LoggerContext)this.context;
        boolean bl = OptionHelper.toBoolean(interpretationContext.subst(attributes.getValue(PACKAGING_DATA_ATTR)), false);
        loggerContext.setPackagingDataEnabled(bl);
    }

    String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    void processScanAttrib(InterpretationContext interpretationContext, Attributes attributes) {
        String string = interpretationContext.subst(attributes.getValue(SCAN_ATTR));
        if (!OptionHelper.isEmpty(string) && !"false".equalsIgnoreCase(string)) {
            ScheduledExecutorService scheduledExecutorService = this.context.getScheduledExecutorService();
            URL uRL = ConfigurationWatchListUtil.getMainWatchURL(this.context);
            if (uRL == null) {
                this.addWarn("Due to missing top level configuration file, reconfiguration on change (configuration file scanning) cannot be done.");
                return;
            }
            ReconfigureOnChangeTask reconfigureOnChangeTask = new ReconfigureOnChangeTask();
            reconfigureOnChangeTask.setContext(this.context);
            this.context.putObject("RECONFIGURE_ON_CHANGE_TASK", reconfigureOnChangeTask);
            String string2 = interpretationContext.subst(attributes.getValue(SCAN_PERIOD_ATTR));
            Duration duration = this.getDuration(string, string2);
            if (duration == null) {
                return;
            }
            this.addInfo("Will scan for changes in [" + uRL + "] ");
            this.addInfo("Setting ReconfigureOnChangeTask scanning period to " + duration);
            ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleAtFixedRate(reconfigureOnChangeTask, duration.getMilliseconds(), duration.getMilliseconds(), TimeUnit.MILLISECONDS);
            this.context.addScheduledFuture(scheduledFuture);
        }
    }

    private Duration getDuration(String string, String string2) {
        Duration duration = null;
        if (!OptionHelper.isEmpty(string2)) {
            try {
                duration = Duration.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("Error while converting [" + string + "] to long", numberFormatException);
            }
        }
        return duration;
    }

    public void end(InterpretationContext interpretationContext, String string) {
        this.addInfo("End of configuration.");
        interpretationContext.popObject();
    }
}

