/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HardenedObjectInputStream
extends ObjectInputStream {
    final List<String> whitelistedClassNames = new ArrayList<String>();
    static final String[] JAVA_PACKAGES = new String[]{"java.lang", "java.util"};

    public HardenedObjectInputStream(InputStream inputStream, String[] stringArray) throws IOException {
        super(inputStream);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.whitelistedClassNames.add(stringArray[i]);
            }
        }
    }

    public HardenedObjectInputStream(InputStream inputStream, List<String> list) throws IOException {
        super(inputStream);
        this.whitelistedClassNames.addAll(list);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (!this.isWhitelisted(string)) {
            throw new InvalidClassException("Unauthorized deserialization attempt", objectStreamClass.getName());
        }
        return super.resolveClass(objectStreamClass);
    }

    private boolean isWhitelisted(String string) {
        for (int i = 0; i < JAVA_PACKAGES.length; ++i) {
            if (!string.startsWith(JAVA_PACKAGES[i])) continue;
            return true;
        }
        for (String string2 : this.whitelistedClassNames) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    protected void addToWhitelist(List<String> list) {
        this.whitelistedClassNames.addAll(list);
    }
}

