/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.IADataForBasicProperty;
import ch.qos.logback.core.joran.action.ImplicitAction;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.util.PropertySetter;
import ch.qos.logback.core.util.AggregationType;
import java.util.Stack;
import org.xml.sax.Attributes;

public class NestedBasicPropertyIA
extends ImplicitAction {
    Stack<IADataForBasicProperty> actionDataStack = new Stack();

    public boolean isApplicable(ElementPath elementPath, Attributes attributes, InterpretationContext interpretationContext) {
        String string = elementPath.peekLast();
        if (interpretationContext.isEmpty()) {
            return false;
        }
        Object object = interpretationContext.peekObject();
        PropertySetter propertySetter = new PropertySetter(object);
        propertySetter.setContext(this.context);
        AggregationType aggregationType = propertySetter.computeAggregationType(string);
        switch (aggregationType) {
            case NOT_FOUND: 
            case AS_COMPLEX_PROPERTY: 
            case AS_COMPLEX_PROPERTY_COLLECTION: {
                return false;
            }
            case AS_BASIC_PROPERTY: 
            case AS_BASIC_PROPERTY_COLLECTION: {
                IADataForBasicProperty iADataForBasicProperty = new IADataForBasicProperty(propertySetter, aggregationType, string);
                this.actionDataStack.push(iADataForBasicProperty);
                return true;
            }
        }
        this.addError("PropertySetter.canContainComponent returned " + (Object)((Object)aggregationType));
        return false;
    }

    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
    }

    public void body(InterpretationContext interpretationContext, String string) {
        String string2 = interpretationContext.subst(string);
        IADataForBasicProperty iADataForBasicProperty = this.actionDataStack.peek();
        switch (iADataForBasicProperty.aggregationType) {
            case AS_BASIC_PROPERTY: {
                iADataForBasicProperty.parentBean.setProperty(iADataForBasicProperty.propertyName, string2);
                break;
            }
            case AS_BASIC_PROPERTY_COLLECTION: {
                iADataForBasicProperty.parentBean.addBasicProperty(iADataForBasicProperty.propertyName, string2);
            }
            default: {
                this.addError("Unexpected aggregationType " + (Object)((Object)iADataForBasicProperty.aggregationType));
            }
        }
    }

    public void end(InterpretationContext interpretationContext, String string) {
        this.actionDataStack.pop();
    }
}

