/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.Interpreter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.joran.spi.SimpleRuleStore;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericConfigurator
extends ContextAwareBase {
    protected Interpreter interpreter;

    public final void doConfigure(URL uRL) throws JoranException {
        InputStream inputStream = null;
        try {
            GenericConfigurator.informContextOfURLUsedForConfiguration(this.getContext(), uRL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
            this.doConfigure(inputStream);
        }
        catch (IOException iOException) {
            String string = "Could not open URL [" + uRL + "].";
            this.addError(string, iOException);
            throw new JoranException(string, iOException);
        }
    }

    public final void doConfigure(String string) throws JoranException {
        this.doConfigure(new File(string));
    }

    public final void doConfigure(File file) throws JoranException {
        FileInputStream fileInputStream = null;
        try {
            GenericConfigurator.informContextOfURLUsedForConfiguration(this.getContext(), file.toURI().toURL());
            fileInputStream = new FileInputStream(file);
            this.doConfigure(fileInputStream);
        }
        catch (IOException iOException) {
            String string = "Could not open [" + file.getPath() + "].";
            this.addError(string, iOException);
            throw new JoranException(string, iOException);
        }
    }

    public static void informContextOfURLUsedForConfiguration(Context context, URL uRL) {
        ConfigurationWatchListUtil.setMainWatchURL(context, uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doConfigure(InputStream inputStream) throws JoranException {
        try {
            this.doConfigure(new InputSource(inputStream));
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                String string = "Could not close the stream";
                this.addError(string, iOException);
                throw new JoranException(string, iOException);
            }
        }
    }

    protected abstract void addInstanceRules(RuleStore var1);

    protected abstract void addImplicitRules(Interpreter var1);

    protected void addDefaultNestedComponentRegistryRules(DefaultNestedComponentRegistry defaultNestedComponentRegistry) {
    }

    protected ElementPath initialElementPath() {
        return new ElementPath();
    }

    protected void buildInterpreter() {
        SimpleRuleStore simpleRuleStore = new SimpleRuleStore(this.context);
        this.addInstanceRules(simpleRuleStore);
        this.interpreter = new Interpreter(this.context, simpleRuleStore, this.initialElementPath());
        InterpretationContext interpretationContext = this.interpreter.getInterpretationContext();
        interpretationContext.setContext(this.context);
        this.addImplicitRules(this.interpreter);
        this.addDefaultNestedComponentRegistryRules(interpretationContext.getDefaultNestedComponentRegistry());
    }

    private final void doConfigure(InputSource inputSource) throws JoranException {
        long l = System.currentTimeMillis();
        if (!ConfigurationWatchListUtil.wasConfigurationWatchListReset(this.context)) {
            GenericConfigurator.informContextOfURLUsedForConfiguration(this.getContext(), null);
        }
        SaxEventRecorder saxEventRecorder = new SaxEventRecorder(this.context);
        saxEventRecorder.recordEvents(inputSource);
        this.doConfigure(saxEventRecorder.getSaxEventList());
        StatusUtil statusUtil = new StatusUtil(this.context);
        if (statusUtil.noXMLParsingErrorsOccurred(l)) {
            this.addInfo("Registering current configuration as safe fallback point");
            this.registerSafeConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConfigure(List<SaxEvent> list) throws JoranException {
        this.buildInterpreter();
        Object object = this.context.getConfigurationLock();
        synchronized (object) {
            this.interpreter.getEventPlayer().play(list);
        }
    }

    public void registerSafeConfiguration() {
        this.context.putObject("SAFE_JORAN_CONFIGURATION", this.interpreter.getEventPlayer().getCopyOfPlayerEventList());
    }

    public List<SaxEvent> recallSafeConfiguration() {
        return (List)this.context.getObject("SAFE_JORAN_CONFIGURATION");
    }
}

