/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.encoder.ByteArrayUtil;
import ch.qos.logback.core.encoder.EncoderBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamEncoder<E>
extends EncoderBase<E> {
    public static final int START_PEBBLE = 1853421169;
    public static final int STOP_PEBBLE = 640373619;
    private int MAX_BUFFER_SIZE = 100;
    List<E> bufferList = new ArrayList(this.MAX_BUFFER_SIZE);

    @Override
    public void doEncode(E e) throws IOException {
        this.bufferList.add(e);
        if (this.bufferList.size() == this.MAX_BUFFER_SIZE) {
            this.writeBuffer();
        }
    }

    void writeHeader(ByteArrayOutputStream byteArrayOutputStream, int n) {
        ByteArrayUtil.writeInt(byteArrayOutputStream, 1853421169);
        ByteArrayUtil.writeInt(byteArrayOutputStream, n);
        ByteArrayUtil.writeInt(byteArrayOutputStream, 0);
        ByteArrayUtil.writeInt(byteArrayOutputStream, 0x6E78F671 ^ n);
    }

    void writeFooter(ByteArrayOutputStream byteArrayOutputStream, int n) {
        ByteArrayUtil.writeInt(byteArrayOutputStream, 640373619);
        ByteArrayUtil.writeInt(byteArrayOutputStream, 0x262B5373 ^ n);
    }

    void writeBuffer() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
        int n = this.bufferList.size();
        this.writeHeader(byteArrayOutputStream, n);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        for (E e : this.bufferList) {
            objectOutputStream.writeObject(e);
        }
        this.bufferList.clear();
        objectOutputStream.flush();
        this.writeFooter(byteArrayOutputStream, n);
        Object object = byteArrayOutputStream.toByteArray();
        objectOutputStream.close();
        this.writeEndPosition((byte[])object);
        this.outputStream.write((byte[])object);
    }

    void writeEndPosition(byte[] byArray) {
        int n = 8;
        ByteArrayUtil.writeInt(byArray, n, byArray.length - n);
    }

    @Override
    public void init(OutputStream outputStream) throws IOException {
        super.init(outputStream);
        this.bufferList.clear();
    }

    @Override
    public void close() throws IOException {
        this.writeBuffer();
    }
}

