/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class StatusListenerAction
extends Action {
    boolean inError = false;
    StatusListener statusListener = null;

    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) throws ActionException {
        this.inError = false;
        String string2 = attributes.getValue("class");
        if (OptionHelper.isEmpty(string2)) {
            this.addError("Missing class name for statusListener. Near [" + string + "] line " + this.getLineNumber(interpretationContext));
            this.inError = true;
            return;
        }
        try {
            if (OnConsoleStatusListener.class.getName().equals(string2)) {
                OnConsoleStatusListener.addNewInstanceToContext(this.context);
            } else {
                this.statusListener = (StatusListener)OptionHelper.instantiateByClassName(string2, StatusListener.class, this.context);
                interpretationContext.getContext().getStatusManager().add(this.statusListener);
                if (this.statusListener instanceof ContextAware) {
                    ((ContextAware)((Object)this.statusListener)).setContext(this.context);
                }
            }
            this.addInfo("Added status listener of type [" + string2 + "]");
            interpretationContext.pushObject(this.statusListener);
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create an StatusListener of type [" + string2 + "].", exception);
            throw new ActionException(exception);
        }
    }

    public void finish(InterpretationContext interpretationContext) {
    }

    public void end(InterpretationContext interpretationContext, String string) {
        Object object;
        if (this.inError) {
            return;
        }
        if (this.statusListener instanceof LifeCycle) {
            ((LifeCycle)((Object)this.statusListener)).start();
        }
        if ((object = interpretationContext.peekObject()) != this.statusListener) {
            this.addWarn("The object at the of the stack is not the statusListener pushed earlier.");
        } else {
            interpretationContext.popObject();
        }
    }
}

