/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.util.AlmostAsIsEscapeUtil;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import ch.qos.logback.core.rolling.helper.MonoTypedConverter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FileNamePattern
extends ContextAwareBase {
    static final Map<String, String> CONVERTER_MAP = new HashMap<String, String>();
    String pattern;
    Converter<Object> headTokenConverter;

    public FileNamePattern(String string, Context context) {
        this.setPattern(FileFilterUtil.slashify(string));
        this.setContext(context);
        this.parse();
        ConverterUtil.startConverters(this.headTokenConverter);
    }

    void parse() {
        try {
            String string = this.escapeRightParantesis(this.pattern);
            Parser parser = new Parser(string, new AlmostAsIsEscapeUtil());
            parser.setContext(this.context);
            Node node = parser.parse();
            this.headTokenConverter = parser.compile(node, CONVERTER_MAP);
        }
        catch (ScanException scanException) {
            this.addError("Failed to parse pattern \"" + this.pattern + "\".", scanException);
        }
    }

    String escapeRightParantesis(String string) {
        return this.pattern.replace(")", "\\)");
    }

    public String toString() {
        return this.pattern;
    }

    public DateTokenConverter getPrimaryDateTokenConverter() {
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            DateTokenConverter dateTokenConverter;
            if (!(converter instanceof DateTokenConverter) || !(dateTokenConverter = (DateTokenConverter)converter).isPrimary()) continue;
            return dateTokenConverter;
        }
        return null;
    }

    public IntegerTokenConverter getIntegerTokenConverter() {
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            if (!(converter instanceof IntegerTokenConverter)) continue;
            return (IntegerTokenConverter)converter;
        }
        return null;
    }

    public String convertMultipleArguments(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            if (converter instanceof MonoTypedConverter) {
                MonoTypedConverter monoTypedConverter = (MonoTypedConverter)((Object)converter);
                for (Object object : objectArray) {
                    if (!monoTypedConverter.isApplicable(object)) continue;
                    stringBuilder.append(converter.convert(object));
                }
                continue;
            }
            stringBuilder.append(converter.convert(objectArray));
        }
        return stringBuilder.toString();
    }

    public String convert(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            stringBuilder.append(converter.convert(object));
        }
        return stringBuilder.toString();
    }

    public String convertInt(int n) {
        return this.convert(n);
    }

    public void setPattern(String string) {
        if (string != null) {
            this.pattern = string.trim();
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toRegexForFixedDate(Date date) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            if (converter instanceof LiteralConverter) {
                stringBuilder.append(converter.convert(null));
                continue;
            }
            if (converter instanceof IntegerTokenConverter) {
                stringBuilder.append("(\\d{1,3})");
                continue;
            }
            if (!(converter instanceof DateTokenConverter)) continue;
            stringBuilder.append(converter.convert(date));
        }
        return stringBuilder.toString();
    }

    public String toRegex() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter<Object> converter = this.headTokenConverter; converter != null; converter = converter.getNext()) {
            if (converter instanceof LiteralConverter) {
                stringBuilder.append(converter.convert(null));
                continue;
            }
            if (converter instanceof IntegerTokenConverter) {
                stringBuilder.append("\\d{1,2}");
                continue;
            }
            if (!(converter instanceof DateTokenConverter)) continue;
            DateTokenConverter dateTokenConverter = (DateTokenConverter)converter;
            stringBuilder.append(dateTokenConverter.toRegex());
        }
        return stringBuilder.toString();
    }

    static {
        CONVERTER_MAP.put("i", IntegerTokenConverter.class.getName());
        CONVERTER_MAP.put("d", DateTokenConverter.class.getName());
    }
}

