/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Compressor
extends ContextAwareBase {
    final CompressionMode compressionMode;
    static final int BUFFER_SIZE = 8192;

    public Compressor(CompressionMode compressionMode) {
        this.compressionMode = compressionMode;
    }

    public void compress(String string, String string2, String string3) {
        switch (this.compressionMode) {
            case GZ: {
                this.gzCompress(string, string2);
                break;
            }
            case ZIP: {
                this.zipCompress(string, string2, string3);
                break;
            }
            case NONE: {
                throw new UnsupportedOperationException("compress method called in NONE compression mode");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipCompress(String string, String string2, String string3) {
        File file;
        File file2 = new File(string);
        if (!file2.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + string + "] does not exist.", this));
            return;
        }
        if (string3 == null) {
            this.addStatus(new WarnStatus("The innerEntryName parameter cannot be null", this));
            return;
        }
        if (!string2.endsWith(".zip")) {
            string2 = string2 + ".zip";
        }
        if ((file = new File(string2)).exists()) {
            this.addStatus(new WarnStatus("The target compressed file named [" + string2 + "] exist already.", this));
            return;
        }
        this.addInfo("ZIP compressing [" + file2 + "] as [" + file + "]");
        this.createMissingTargetDirsIfNecessary(file);
        BufferedInputStream bufferedInputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
            ZipEntry zipEntry = this.computeZipEntry(string3);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[8192];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedInputStream = null;
            zipOutputStream.close();
            zipOutputStream = null;
            if (!file2.delete()) {
                this.addStatus(new WarnStatus("Could not delete [" + string + "].", this));
            }
        }
        catch (Exception exception) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + string + "] into [" + string2 + "].", this, exception));
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    ZipEntry computeZipEntry(File file) {
        return this.computeZipEntry(file.getName());
    }

    ZipEntry computeZipEntry(String string) {
        String string2 = Compressor.computeFileNameStr_WCS(string, this.compressionMode);
        return new ZipEntry(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gzCompress(String string, String string2) {
        File file;
        File file2 = new File(string);
        if (!file2.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + string + "] does not exist.", this));
            return;
        }
        if (!string2.endsWith(".gz")) {
            string2 = string2 + ".gz";
        }
        if ((file = new File(string2)).exists()) {
            this.addWarn("The target compressed file named [" + string2 + "] exist already. Aborting file compression.");
            return;
        }
        this.addInfo("GZ compressing [" + file2 + "] as [" + file + "]");
        this.createMissingTargetDirsIfNecessary(file);
        BufferedInputStream bufferedInputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            deflaterOutputStream = new GZIPOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[8192];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                ((GZIPOutputStream)deflaterOutputStream).write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedInputStream = null;
            deflaterOutputStream.close();
            deflaterOutputStream = null;
            if (!file2.delete()) {
                this.addStatus(new WarnStatus("Could not delete [" + string + "].", this));
            }
        }
        catch (Exception exception) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + string + "] into [" + string2 + "].", this, exception));
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (deflaterOutputStream != null) {
                try {
                    deflaterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String computeFileNameStr_WCS(String string, CompressionMode compressionMode) {
        int n = string.length();
        switch (compressionMode) {
            case GZ: {
                if (string.endsWith(".gz")) {
                    return string.substring(0, n - 3);
                }
                return string;
            }
            case ZIP: {
                if (string.endsWith(".zip")) {
                    return string.substring(0, n - 4);
                }
                return string;
            }
            case NONE: {
                return string;
            }
        }
        throw new IllegalStateException("Execution should not reach this point");
    }

    void createMissingTargetDirsIfNecessary(File file) {
        if (FileUtil.isParentDirectoryCreationRequired(file)) {
            boolean bl = FileUtil.createMissingParentDirectories(file);
            if (!bl) {
                this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
            } else {
                this.addInfo("Created missing parent directories for [" + file.getAbsolutePath() + "]");
            }
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

