/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.android;

import android.annotation.TargetApi;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Environment;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AndroidContextUtil {
    private static final String ASSETS_DIRECTORY = "assets";
    private ContextWrapper context;

    public AndroidContextUtil() {
        this(AndroidContextUtil.getContext());
    }

    public AndroidContextUtil(ContextWrapper contextWrapper) {
        this.context = contextWrapper;
    }

    private static ContextWrapper getContext() {
        try {
            Class<?> clazz = Class.forName("android.app.AppGlobals");
            Method method = clazz.getDeclaredMethod("getInitialApplication", new Class[0]);
            return (ContextWrapper)method.invoke(clazz, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public String getMountedExternalStorageDirectoryPath() {
        String string = null;
        String string2 = Environment.getExternalStorageState();
        if (string2.equals("mounted") || string2.equals("mounted_ro")) {
            string = this.absPath(Environment.getExternalStorageDirectory());
        }
        return string;
    }

    public String getExternalStorageDirectoryPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public String getExternalFilesDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getExternalFilesDir(null)) : "";
    }

    public String getCacheDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getCacheDir()) : "";
    }

    public String getExternalCacheDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getExternalCacheDir()) : "";
    }

    public String getPackageName() {
        return this.context != null ? this.context.getPackageName() : "";
    }

    public String getFilesDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getFilesDir()) : "";
    }

    @TargetApi(value=21)
    public String getNoBackupFilesDirectoryPath() {
        return Build.VERSION.SDK_INT >= 21 && this.context != null ? this.absPath(this.context.getNoBackupFilesDir()) : "";
    }

    public String getAssetsDirectoryPath() {
        return ASSETS_DIRECTORY;
    }

    public String getDatabaseDirectoryPath() {
        return this.context != null && this.context.getDatabasePath("x") != null ? this.context.getDatabasePath("x").getParent() : "";
    }

    public String getDatabasePath(String string) {
        return this.context != null ? this.absPath(this.context.getDatabasePath(string)) : "";
    }

    private String absPath(File file) {
        return file != null ? file.getAbsolutePath() : "";
    }
}

