/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import com.mapbox.services.android.navigation.v5.navigation.OfflineError;
import com.mapbox.services.android.navigation.v5.navigation.RouteTileDownloader;
import com.mapbox.services.android.navigation.v5.navigation.TarResponseErrorMap;
import com.mapbox.services.android.navigation.v5.utils.DownloadTask;
import java.util.HashMap;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class TarFetchedCallback
implements Callback<ResponseBody> {
    private final RouteTileDownloader downloader;
    private final DownloadTask downloadTask;

    TarFetchedCallback(RouteTileDownloader downloader, DownloadTask downloadTask) {
        this.downloader = downloader;
        this.downloadTask = downloadTask;
    }

    public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
        if (response.isSuccessful()) {
            this.downloadTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ResponseBody[]{(ResponseBody)response.body()});
        } else {
            HashMap<Integer, String> errorCodes = new HashMap<Integer, String>();
            TarResponseErrorMap errorMap = new TarResponseErrorMap(errorCodes);
            OfflineError error = new OfflineError(errorMap.buildErrorMessageWith(response));
            this.downloader.onError(error);
        }
    }

    public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable throwable) {
        OfflineError error = new OfflineError(throwable.getMessage());
        this.downloader.onError(error);
    }
}

