/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.services.android.navigation.v5.navigation.DirectionsRouteType;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigator;
import java.util.List;

class RouteHandler {
    private static final int INDEX_FIRST_ROUTE = 0;
    private static final int INDEX_FIRST_LEG = 0;
    private final MapboxNavigator mapboxNavigator;

    RouteHandler(MapboxNavigator mapboxNavigator) {
        this.mapboxNavigator = mapboxNavigator;
    }

    void updateRoute(DirectionsRoute route, DirectionsRouteType routeType) {
        if (routeType == DirectionsRouteType.NEW_ROUTE) {
            String routeJson = route.toJson();
            this.mapboxNavigator.setRoute(routeJson, 0, 0);
        } else {
            List legs = route.legs();
            for (int i = 0; i < legs.size(); ++i) {
                String annotationJson = ((RouteLeg)legs.get(i)).annotation().toJson();
                this.mapboxNavigator.updateAnnotations(annotationJson, 0, i);
            }
        }
    }
}

