/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.content.Context;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationNotification;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.notification.NavigationNotification;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;

class NavigationNotificationProvider {
    private NavigationNotification navigationNotification;
    private boolean shouldUpdate = true;

    NavigationNotificationProvider(Context applicationContext, MapboxNavigation mapboxNavigation) {
        this.navigationNotification = this.buildNotificationFrom(applicationContext, mapboxNavigation);
    }

    NavigationNotification retrieveNotification() {
        return this.navigationNotification;
    }

    void updateNavigationNotification(RouteProgress routeProgress) {
        if (this.shouldUpdate) {
            this.navigationNotification.updateNotification(routeProgress);
        }
    }

    void shutdown(Context applicationContext) {
        if (this.navigationNotification != null) {
            this.navigationNotification.onNavigationStopped(applicationContext);
        }
        this.navigationNotification = null;
        this.shouldUpdate = false;
    }

    private NavigationNotification buildNotificationFrom(Context applicationContext, MapboxNavigation mapboxNavigation) {
        MapboxNavigationOptions options = mapboxNavigation.options();
        if (options.navigationNotification() != null) {
            return options.navigationNotification();
        }
        return new MapboxNavigationNotification(applicationContext, mapboxNavigation);
    }
}

